/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.task;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.access.ArtifactCheck;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class TaskAutoGenArtifactChecks
implements ArtifactCheck {
    private static boolean deletionChecksEnabled = !AtsUtil.isInTest();

    public XResultData isDeleteable(Collection<? extends ArtifactToken> artifacts, XResultData results) {
        if (deletionChecksEnabled) {
            AtsApi atsApi = AtsApiService.get();
            if (artifacts.isEmpty()) {
                return results;
            }
            boolean isAtsAdmin = atsApi.getUserService().isAtsAdmin();
            this.checkAutoGeneratedTasks(isAtsAdmin, atsApi, artifacts, results);
        }
        return results;
    }

    public XResultData isRenamable(Collection<? extends ArtifactToken> artifacts, XResultData results) {
        AtsApi atsApi = AtsApiService.get();
        for (ArtifactToken artifactToken : artifacts) {
            if (!artifactToken.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task}) || !atsApi.getTaskService().isAutoGen((IAtsTask)artifactToken)) continue;
            results.errorf("Invalid to rename LBA ATS auto-generated task %s", new Object[]{artifactToken.toStringWithId()});
        }
        return results;
    }

    private void checkAutoGeneratedTasks(boolean isAtsAdmin, AtsApi atsApi, Collection<? extends ArtifactToken> artifacts, XResultData results) {
        for (ArtifactToken artifactToken : artifacts) {
            if (!artifactToken.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task}) || !atsApi.getTaskService().isAutoGen((IAtsTask)artifactToken)) continue;
            results.errorf("Invalid to delete LBA ATS auto-generated task %s", new Object[]{artifactToken.toStringWithId()});
        }
    }
}

