/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.task;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.task.AbstractAtsTaskService;
import org.eclipse.osee.ats.api.task.IAtsTaskProvider;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.core.task.internal.AtsTaskProviderCollector;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public abstract class AbstractAtsTaskServiceCore
extends AbstractAtsTaskService {
    protected String DE_REFERRENCED_NOTE = "No Matching Artifact; Task can be deleted.";

    public AbstractAtsTaskServiceCore(AtsApi atsApi) {
        super(atsApi);
    }

    public Collection<IAtsTaskProvider> getTaskProviders() {
        return AtsTaskProviderCollector.getTaskProviders();
    }

    public boolean isAutoGen(IAtsTask task) {
        for (IAtsTaskProvider provider : this.getTaskProviders()) {
            if (!provider.isAutoGen(task)) continue;
            return true;
        }
        return false;
    }

    public boolean isAutoGenDeReferenced(IAtsTask task) {
        String note = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)task, (AttributeTypeToken)AtsAttributeTypes.WorkflowNotes, (Object)"");
        boolean deReferenced = note.contains(this.DE_REFERRENCED_NOTE);
        return deReferenced;
    }

    public boolean removeDeReferencedNote(IAtsTask task, IAtsChangeSet changes) {
        boolean autoGen;
        boolean updated = false;
        String note = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)task, (AttributeTypeToken)AtsAttributeTypes.WorkflowNotes, (Object)"");
        if (note.contains(this.DE_REFERRENCED_NOTE)) {
            note = note.replaceAll(this.DE_REFERRENCED_NOTE, "");
            changes.setSoleAttributeValue((IAtsWorkItem)task, (AttributeTypeToken)AtsAttributeTypes.WorkflowNotes, note);
            updated = true;
        }
        if (!(autoGen = ((Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)task, (AttributeTypeToken)AtsAttributeTypes.TaskAutoGen, (Object)false)).booleanValue())) {
            changes.setSoleAttributeValue((IAtsObject)task, (AttributeTypeToken)AtsAttributeTypes.TaskAutoGen, (Object)true);
            updated = true;
        }
        return updated;
    }

    public void addDeReferencedNote(IAtsTask task, IAtsChangeSet changes) {
        String note = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)task, (AttributeTypeToken)AtsAttributeTypes.WorkflowNotes, (Object)"");
        if (!note.contains(this.DE_REFERRENCED_NOTE)) {
            note = String.valueOf(note) + this.DE_REFERRENCED_NOTE;
            changes.setSoleAttributeValue((IAtsWorkItem)task, (AttributeTypeToken)AtsAttributeTypes.WorkflowNotes, note);
        }
        changes.deleteAttributes((IAtsObject)task, (AttributeTypeToken)AtsAttributeTypes.TaskAutoGen);
    }
}

