/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.rule.validate;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.rule.validation.AbstractValidationRule;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class UniqueNameRule
extends AbstractValidationRule {
    private final ArtifactTypeToken artifactType;
    private final Collection<IdPair> idPairs = new LinkedList<IdPair>();
    private final Map<ArtifactTypeToken, List<ArtifactToken>> artTypeToArtifacts = new HashMap<ArtifactTypeToken, List<ArtifactToken>>();

    public UniqueNameRule(ArtifactTypeToken artifactType, AtsApi atsApi) {
        super(atsApi);
        this.artifactType = artifactType;
    }

    public boolean hasArtifactType(ArtifactTypeToken artType) {
        return artType.inheritsFrom((ArtifactTypeId)this.artifactType);
    }

    public void validate(ArtifactToken artifact, XResultData rd) {
        if (this.hasArtifactType(this.atsApi.getStoreService().getArtifactType((ArtifactId)artifact))) {
            List<ArtifactToken> arts = this.getArtifactsOfType((BranchId)artifact.getBranch(), artifact.getArtifactType());
            for (ArtifactToken art : arts) {
                if (!art.getName().equalsIgnoreCase(artifact.getName()) || !art.notEqual((Id)artifact) || this.hasIdPairAlreadyBeenEvaluated(art.getId(), artifact.getId()) || Strings.isNumeric((String)artifact.getName()) && !artifact.isTypeEqual((ArtifactTypeId)art.getArtifactType()) || this.isImplementationDetailsChild(artifact, art) || this.isImplementationDetailsChild(art, artifact)) continue;
                String errStr = "Artifacts have same name";
                this.logError(artifact, errStr, rd);
                this.addIdPair(art.getId(), artifact.getId());
            }
        }
    }

    protected List<ArtifactToken> getArtifactsOfType(BranchId branch, ArtifactTypeToken artifact) {
        List arts = this.artTypeToArtifacts.get(artifact);
        if (arts == null) {
            arts = this.atsApi.getQueryService().getArtifactsFromTypeWithInheritence(this.artifactType, branch, DeletionFlag.EXCLUDE_DELETED);
            this.artTypeToArtifacts.put(artifact, arts);
        }
        return arts;
    }

    private boolean isImplementationDetailsChild(ArtifactToken childArtifact, ArtifactToken parentArtifact) {
        return parentArtifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.SoftwareRequirementMsWord}) && childArtifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractImplementationDetails}) && this.atsApi.getRelationResolver().getParent((ArtifactId)childArtifact).equals(parentArtifact);
    }

    private void addIdPair(Long idA, Long idB) {
        this.idPairs.add(new IdPair(idA, idB));
    }

    private boolean hasIdPairAlreadyBeenEvaluated(Long idA, Long idB) {
        for (IdPair idPair : this.idPairs) {
            if ((!idPair.getIdA().equals(idA) || !idPair.getIdB().equals(idB)) && (!idPair.getIdA().equals(idB) || !idPair.getIdB().equals(idA))) continue;
            return true;
        }
        return false;
    }

    public String getRuleDescription() {
        return "Ensure no two artifacts have the same name value";
    }

    public String getRuleTitle() {
        return "Unique Names Check:";
    }

    private class IdPair {
        private final Long idA;
        private final Long idB;

        public IdPair(Long idA, Long idB) {
            this.idA = idA;
            this.idB = idB;
        }

        public Long getIdA() {
            return this.idA;
        }

        public Long getIdB() {
            return this.idB;
        }
    }
}

