/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.review;

import java.util.Collection;
import java.util.Date;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsPeerReviewDefinition;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.StateEventType;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsReviewHook;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class PeerReviewOnTransitionToHook
implements IAtsTransitionHook {
    public static IAtsPeerToPeerReview createNewPeerToPeerReview(IAtsPeerReviewDefinition peerRevDef, IAtsChangeSet changes, IAtsTeamWorkflow teamWf, Date createdDate, AtsUser createdBy) {
        Collection assignees;
        ReviewBlockType reviewBlockType;
        AtsApi atsApi = AtsApiService.get();
        String title = peerRevDef.getReviewTitle();
        if (!Strings.isValid((String)title)) {
            title = String.format("Review [%s]", teamWf.getName());
        }
        if (Named.getNames((Collection)atsApi.getReviewService().getReviews(teamWf)).contains(title)) {
            return null;
        }
        IAtsPeerToPeerReview peerRev = atsApi.getReviewService().createNewPeerToPeerReview(teamWf, title, peerRevDef.getRelatedToState(), createdDate, createdBy, changes);
        if (Strings.isValid((String)peerRevDef.getDescription())) {
            changes.setSoleAttributeFromString((IAtsObject)peerRev, (AttributeTypeGeneric)AtsAttributeTypes.Description, peerRevDef.getDescription());
        }
        if ((reviewBlockType = peerRevDef.getBlockingType()) != null) {
            changes.setSoleAttributeFromString((IAtsObject)peerRev, (AttributeTypeGeneric)AtsAttributeTypes.ReviewBlocks, reviewBlockType.name());
        }
        if (Strings.isValid((String)peerRevDef.getLocation())) {
            changes.setSoleAttributeFromString((IAtsObject)peerRev, (AttributeTypeGeneric)AtsAttributeTypes.Location, peerRevDef.getLocation());
        }
        if ((assignees = atsApi.getUserService().getUsersByUserIds((Collection)peerRevDef.getAssignees())).size() > 0) {
            changes.setAssignees((IAtsWorkItem)peerRev, assignees);
        }
        peerRev.getLog().addLog(LogType.Note, null, String.format("Review [%s] auto-generated", peerRevDef.getName()), atsApi.getUserService().getCurrentUser().getUserId());
        for (IAtsReviewHook provider : atsApi.getReviewService().getReviewHooks()) {
            provider.reviewCreated((IAtsAbstractReview)peerRev);
        }
        changes.add((Object)peerRev);
        return peerRev;
    }

    public void transitioned(IAtsWorkItem workItem, IStateToken fromState, IStateToken toState, Collection<AtsUser> toAssignees, AtsUser asUser, IAtsChangeSet changes, AtsApi atsApi) {
        if (!workItem.isTeamWorkflow()) {
            return;
        }
        Date createdDate = new Date();
        AtsUser createdBy = AtsCoreUsers.SYSTEM_USER;
        IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
        for (IAtsPeerReviewDefinition peerRevDef : workItem.getWorkDefinition().getStateByName(toState.getName()).getPeerReviews()) {
            IAtsPeerToPeerReview peerRev;
            if (peerRevDef.getStateEventType() == null || !peerRevDef.getStateEventType().equals((Object)StateEventType.TransitionTo) || (peerRev = PeerReviewOnTransitionToHook.createNewPeerToPeerReview(peerRevDef, changes, teamWf, createdDate, createdBy)) == null) continue;
            changes.add((Object)peerRev);
        }
    }

    public String getDescription() {
        return "Create PeerToPeer Review from transition if defined by StateDefinition";
    }
}

