/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.query.IAtsQuery;
import org.eclipse.osee.ats.api.query.IAtsQueryFilter;
import org.eclipse.osee.ats.api.query.IAtsWorkItemFilter;
import org.eclipse.osee.ats.api.query.ReleasedOption;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.query.AtsAttributeQuery;
import org.eclipse.osee.ats.core.query.AtsWorkItemFilter;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public abstract class AbstractAtsQueryImpl
implements IAtsQuery {
    protected final List<AtsAttributeQuery> andAttr;
    protected final List<AtsAttributeQuery> teamWorkflowAttr;
    protected final HashMap<RelationTypeSide, List<IAtsObject>> andRels;
    protected Collection<Long> teamDefIds;
    protected Collection<StateType> stateTypes;
    protected Collection<WorkItemType> workItemTypes;
    protected Collection<ArtifactTypeToken> artifactTypes;
    protected Collection<ArtifactId> artifactIds;
    protected final AtsApi atsApi;
    protected Collection<Long> aiIds;
    protected Long versionId;
    protected String stateName;
    protected String changeType;
    protected Long programId;
    protected Long insertionId;
    protected Long insertionActivityId;
    protected Long workPackageId;
    protected List<ArtifactId> onlyIds = null;
    private ReleasedOption releasedOption;
    protected final List<IAtsQueryFilter> queryFilters;

    public AbstractAtsQueryImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
        this.andRels = new HashMap();
        this.andAttr = new ArrayList<AtsAttributeQuery>();
        this.stateTypes = new ArrayList<StateType>();
        this.workItemTypes = new ArrayList<WorkItemType>();
        this.artifactTypes = new ArrayList<ArtifactTypeToken>();
        this.teamDefIds = new ArrayList<Long>();
        this.aiIds = new ArrayList<Long>();
        this.artifactIds = new ArrayList<ArtifactId>();
        this.teamWorkflowAttr = new ArrayList<AtsAttributeQuery>();
        this.queryFilters = new ArrayList<IAtsQueryFilter>();
    }

    public Collection<ArtifactId> getItemIds() {
        this.onlyIds = new LinkedList<ArtifactId>();
        this.getItems();
        return this.onlyIds;
    }

    public <T extends IAtsWorkItem> Collection<T> getItemsNew() {
        Set<ArtifactTypeToken> allArtTypes = this.getAllArtTypes();
        List<ArtifactTypeToken> teamWorkflowArtTypes = this.getTeamWorkflowArtTypes(allArtTypes);
        this.isTeamTypeDefAisOrVersionSearched(allArtTypes);
        Collection<Object> teamWfs = Collections.emptyList();
        HashSet allResults = new HashSet();
        if (!teamWorkflowArtTypes.isEmpty()) {
            teamWfs = this.getTeamWorkflowsNew(teamWorkflowArtTypes, allResults, allArtTypes);
        }
        if (allArtTypes.contains(AtsArtifactTypes.AbstractWorkflowArtifact)) {
            teamWfs = this.getTeamWorkflowsNew(allArtTypes, allResults, allArtTypes);
        }
        return teamWfs;
    }

    public <T extends IAtsWorkItem> Collection<T> getItems() {
        Set<ArtifactTypeToken> allArtTypes = this.getAllArtTypes();
        List<ArtifactTypeToken> teamWorkflowArtTypes = this.getTeamWorkflowArtTypes(allArtTypes);
        boolean teamsTypeDefOrAisOrVersionSearched = this.isTeamTypeDefAisOrVersionSearched(allArtTypes);
        Collection<Object> teamWfs = Collections.emptyList();
        Set allResults = new HashSet();
        if (!teamWorkflowArtTypes.isEmpty()) {
            teamWfs = this.getTeamWorkflows(teamWorkflowArtTypes, allResults, allArtTypes);
        }
        if (allArtTypes.contains(AtsArtifactTypes.AbstractWorkflowArtifact)) {
            teamWfs = this.getTeamWorkflows(allArtTypes, allResults, allArtTypes);
        }
        if (!teamWorkflowArtTypes.isEmpty() && teamsTypeDefOrAisOrVersionSearched) {
            this.getTasksAndReviewsFromResultingTeamWfs(teamWfs, allResults, allArtTypes, false);
        } else {
            this.getTasksFromSearchCriteria(allResults, allArtTypes, false);
            this.getReviewsFromSearchCriteria(allResults, allArtTypes, false);
        }
        this.getGoalsFromSearchCriteria(allResults, allArtTypes, false);
        this.getSprintsFromSearchCriteria(allResults, allArtTypes, false);
        for (IAtsQueryFilter filter : this.queryFilters) {
            allResults = filter.applyFilter(allResults);
        }
        return allResults;
    }

    public abstract Collection<? extends ArtifactToken> runQuery();

    public abstract Collection<? extends ArtifactToken> runQueryNew();

    private <T> Collection<T> collectResults(Set<T> allResults, Set<ArtifactTypeToken> allArtTypes, boolean newSearch) {
        HashSet<IAtsWorkItem> workItems = new HashSet<IAtsWorkItem>();
        if (this.isOnlyIds()) {
            this.onlyIds.addAll(this.handleReleaseOption(this.queryGetIds()));
        } else {
            for (ArtifactToken artifactToken : newSearch ? this.runQueryNew() : this.runQuery()) {
                IAtsWorkItem workItem;
                if (!this.isArtifactTypeMatch(artifactToken, allArtTypes) || (workItem = this.atsApi.getWorkItemService().getWorkItem(artifactToken)) == null) continue;
                workItems.add(workItem);
            }
            this.addtoResultsWithNullCheck(allResults, this.handleReleasedOption(workItems));
        }
        return workItems;
    }

    private <T> void addtoResultsWithNullCheck(Set<T> allResults, Collection<? extends T> workItems) {
        Conditions.assertFalse((boolean)workItems.contains(null), (String)"Null found in results.", (Object[])new Object[0]);
        allResults.addAll(workItems);
    }

    private Collection<ArtifactId> handleReleaseOption(List<ArtifactId> queryGetIds) {
        if (this.releasedOption != null && this.releasedOption != ReleasedOption.Both) {
            throw new UnsupportedOperationException("This option not supported");
        }
        return queryGetIds;
    }

    private <T> Collection<? extends T> handleReleasedOption(Set<T> workItems) {
        if (this.releasedOption == null) {
            return workItems;
        }
        HashSet<T> results = new HashSet<T>();
        if (this.isVersionSpecified()) {
            for (T workItem : workItems) {
                IAtsVersion version = this.atsApi.getVersionService().getTargetedVersion((IAtsWorkItem)workItem);
                if (version == null) continue;
                if (this.releasedOption == ReleasedOption.Released && version.isReleased()) {
                    results.add(workItem);
                    continue;
                }
                if (this.releasedOption != ReleasedOption.UnReleased || version.isReleased()) continue;
                results.add(workItem);
            }
        }
        return results;
    }

    private boolean isArtifactTypeMatch(ArtifactToken artifact, Collection<ArtifactTypeToken> artTypes) {
        if (artTypes.isEmpty()) {
            return true;
        }
        for (ArtifactTypeToken artType : artTypes) {
            if (!artifact.isOfType(new ArtifactTypeId[]{artType})) continue;
            return true;
        }
        return false;
    }

    private <T> void getTasksFromSearchCriteria(Set<T> allResults, Set<ArtifactTypeToken> allArtTypes, boolean newSearch) {
        LinkedList<ArtifactTypeToken> artTypes = new LinkedList<ArtifactTypeToken>();
        for (ArtifactTypeToken artType : allArtTypes) {
            if (!artType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.Task)) continue;
            artTypes.add(artType);
        }
        if (!artTypes.isEmpty()) {
            this.createQueryBuilder();
            this.getBaseSearchCriteria(artTypes, true, allArtTypes);
            if (this.isTeamTypeDefAisOrVersionSearched(allArtTypes)) {
                List<ArtifactId> teamWfIds = this.getRelatedTeamWorkflowIdsBasedOnTeamDefsAisAndVersions(this.teamWorkflowAttr);
                this.queryAndRelatedTo(AtsRelationTypes.TeamWfToTask_TeamWorkflow, teamWfIds);
            }
            this.addEvConfigCriteria();
            this.collectResults(allResults, allArtTypes, newSearch);
        }
    }

    private <T> void getReviewsFromSearchCriteria(Set<T> allResults, Set<ArtifactTypeToken> allArtTypes, boolean newSearch) {
        List<ArtifactTypeToken> artTypes = this.getReviewArtifactTypes(allArtTypes);
        if (!artTypes.isEmpty()) {
            this.createQueryBuilder();
            this.getBaseSearchCriteria(artTypes, true, allArtTypes);
            if (this.isTeamTypeDefAisOrVersionSearched(allArtTypes)) {
                List<ArtifactId> teamWfIds = this.getRelatedTeamWorkflowIdsBasedOnTeamDefsAisAndVersions(this.teamWorkflowAttr);
                this.queryAndRelatedTo(AtsRelationTypes.TeamWorkflowToReview_TeamWorkflow, teamWfIds);
            }
            this.collectResults(allResults, allArtTypes, newSearch);
        }
    }

    private <T> void getSprintsFromSearchCriteria(Set<T> allResults, Set<ArtifactTypeToken> allArtTypes, boolean newSearch) {
        LinkedList<ArtifactTypeToken> artTypes = new LinkedList<ArtifactTypeToken>();
        for (ArtifactTypeToken artType : allArtTypes) {
            if (!artType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.AgileSprint)) continue;
            artTypes.add(artType);
        }
        if (!artTypes.isEmpty()) {
            this.createQueryBuilder();
            this.getBaseSearchCriteria(artTypes, true, allArtTypes);
            this.collectResults(allResults, allArtTypes, newSearch);
        }
    }

    private <T> void getGoalsFromSearchCriteria(Set<T> allResults, Set<ArtifactTypeToken> allArtTypes, boolean newSearch) {
        LinkedList<ArtifactTypeToken> artTypes = new LinkedList<ArtifactTypeToken>();
        for (ArtifactTypeToken artType : allArtTypes) {
            if (!artType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.Goal) && !this.workItemTypes.contains(WorkItemType.AgileBacklog)) continue;
            artTypes.add(artType);
        }
        if (!artTypes.isEmpty()) {
            this.createQueryBuilder();
            this.getBaseSearchCriteria(artTypes, true, allArtTypes);
            boolean isAgileSpecified = this.workItemTypes.contains(WorkItemType.AgileBacklog);
            boolean isGoalSpecified = this.workItemTypes.contains(WorkItemType.Goal);
            if (isAgileSpecified && !isGoalSpecified) {
                this.queryAndExists(AtsRelationTypes.AgileTeamToBacklog_Backlog);
            } else if (isGoalSpecified && !isAgileSpecified) {
                this.queryAndNotExists(AtsRelationTypes.AgileTeamToBacklog_Backlog);
            }
            this.collectResults(allResults, allArtTypes, newSearch);
        }
    }

    public abstract void queryAndNotExists(RelationTypeSide var1);

    public abstract void queryAndExists(RelationTypeSide var1);

    private boolean typeIsSpecified(ArtifactTypeToken parentArtType, Set<ArtifactTypeToken> allArtTypes) {
        for (ArtifactTypeToken artifactType : allArtTypes) {
            if (!artifactType.inheritsFrom((ArtifactTypeId)parentArtType)) continue;
            return true;
        }
        return false;
    }

    private List<ArtifactTypeToken> getReviewArtifactTypes(Set<ArtifactTypeToken> allArtTypes) {
        LinkedList<ArtifactTypeToken> artTypes = new LinkedList<ArtifactTypeToken>();
        boolean isReviewSpecified = this.workItemTypes.contains(WorkItemType.Review) || this.typeIsSpecified(AtsArtifactTypes.AbstractReview, allArtTypes);
        boolean isPeerSpecified = this.workItemTypes.contains(WorkItemType.PeerReview) || this.typeIsSpecified(AtsArtifactTypes.PeerToPeerReview, allArtTypes);
        boolean isDecisionSpecified = this.workItemTypes.contains(WorkItemType.DecisionReview) || this.typeIsSpecified(AtsArtifactTypes.DecisionReview, allArtTypes);
        for (ArtifactTypeToken artType : allArtTypes) {
            if (isReviewSpecified && artType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.AbstractReview)) {
                artTypes.add(artType);
                continue;
            }
            if (isPeerSpecified && artType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.PeerToPeerReview)) {
                artTypes.add(artType);
                continue;
            }
            if (!isDecisionSpecified || !artType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.DecisionReview)) continue;
            artTypes.add(artType);
        }
        return artTypes;
    }

    private <T> void getTasksAndReviewsFromResultingTeamWfs(Collection<T> teamWfs, Set<T> allResults, Set<ArtifactTypeToken> allArtTypes, boolean newSearch) {
        LinkedList<ArtifactTypeToken> artTypes = new LinkedList<ArtifactTypeToken>();
        for (ArtifactTypeToken artType : allArtTypes) {
            if (!artType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.Task)) continue;
            artTypes.add(artType);
        }
        artTypes.addAll(this.getReviewArtifactTypes(allArtTypes));
        if (!artTypes.isEmpty()) {
            this.createQueryBuilder();
            for (Object teamWf : teamWfs) {
                for (IAtsTask task : this.atsApi.getTaskService().getTasks((IAtsTeamWorkflow)teamWf)) {
                    this.artifactIds.add(task.getArtifactId());
                }
                for (IAtsAbstractReview review : this.atsApi.getReviewService().getReviews((IAtsTeamWorkflow)teamWf)) {
                    this.artifactIds.add(review.getArtifactId());
                }
            }
            this.getBaseSearchCriteria(artTypes, false, allArtTypes);
            this.addEvConfigCriteria();
            this.collectResults(allResults, allArtTypes, newSearch);
        }
    }

    private <T extends IAtsWorkItem> Collection<T> getTeamWorkflowsNew(Collection<ArtifactTypeToken> teamWorkflowArtTypes, Set<T> allResults, Set<ArtifactTypeToken> allArtTypes) {
        return this.getTeamWorkflows(teamWorkflowArtTypes, allResults, allArtTypes, true);
    }

    private <T extends IAtsWorkItem> Collection<T> getTeamWorkflows(Collection<ArtifactTypeToken> teamWorkflowArtTypes, Set<T> allResults, Set<ArtifactTypeToken> allArtTypes) {
        return this.getTeamWorkflows(teamWorkflowArtTypes, allResults, allArtTypes, false);
    }

    private <T extends IAtsWorkItem> Collection<T> getTeamWorkflows(Collection<ArtifactTypeToken> teamWorkflowArtTypes, Set<T> allResults, Set<ArtifactTypeToken> allArtTypes, boolean newSearch) {
        this.createQueryBuilder();
        this.getBaseSearchCriteria(teamWorkflowArtTypes, true, allArtTypes);
        this.addTeamWorkflowAttributeCriteria();
        this.addTeamDefCriteria();
        this.addAiCriteria();
        this.addVersionCriteria();
        this.addEvConfigCriteria();
        return this.collectResults(allResults, allArtTypes, newSearch);
    }

    private void addEvConfigCriteria() {
        this.addWorkPackageCriteria();
        this.addInsertionActivityCriteria();
        this.addInsertionCriteria();
        this.addProgramCriteria();
    }

    protected boolean isProgramSpecified() {
        return this.programId != null && this.programId > 0L;
    }

    protected boolean isInsertionSpecified() {
        return this.insertionId != null && this.insertionId > 0L;
    }

    protected boolean isVersionSpecified() {
        return this.versionId != null && this.versionId > 0L;
    }

    protected boolean isInsertionActivitySpecified() {
        return this.insertionActivityId != null && this.insertionActivityId > 0L;
    }

    protected boolean isWorkPackageSpecified() {
        return this.workPackageId != null && this.workPackageId > 0L;
    }

    public abstract void createQueryBuilder();

    public abstract void queryAndIsOfType(ArtifactTypeToken var1);

    public boolean isOnlyIds() {
        return this.onlyIds != null;
    }

    public abstract List<ArtifactId> queryGetIds();

    public abstract List<ArtifactId> getRelatedTeamWorkflowIdsBasedOnTeamDefsAisAndVersions(List<AtsAttributeQuery> var1);

    private Set<ArtifactTypeToken> getAllArtTypes() {
        HashSet<ArtifactTypeToken> allArtTypes = new HashSet();
        if (this.artifactTypes != null && !this.artifactTypes.isEmpty()) {
            allArtTypes.addAll(this.artifactTypes);
        } else {
            allArtTypes = this.getArtifactTypesFromWorkItemTypes();
        }
        return allArtTypes;
    }

    private List<ArtifactTypeToken> getTeamWorkflowArtTypes(Set<ArtifactTypeToken> allArtTypes) {
        LinkedList<ArtifactTypeToken> teamWorkflowArtTypes = new LinkedList<ArtifactTypeToken>();
        for (ArtifactTypeToken artType : allArtTypes) {
            if (!artType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.TeamWorkflow)) continue;
            teamWorkflowArtTypes.add(artType);
        }
        return teamWorkflowArtTypes;
    }

    private boolean isTeamTypeDefAisOrVersionSearched(Set<ArtifactTypeToken> allArtTypes) {
        boolean teamDefsSearched = this.isTeamDefSpecified();
        boolean aisSearched = this.isActionableItemSpecified();
        boolean versionSearched = this.versionId != null && this.versionId > 0L;
        boolean teamWfAttrSpecified = this.isTeamWfAttrSpecified();
        return teamDefsSearched || teamWfAttrSpecified || aisSearched || versionSearched;
    }

    private boolean isActionableItemSpecified() {
        return this.aiIds != null && !this.aiIds.isEmpty();
    }

    private boolean isTeamDefSpecified() {
        return this.teamDefIds != null && !this.teamDefIds.isEmpty();
    }

    private boolean isTeamWfAttrSpecified() {
        return this.teamWorkflowAttr != null && !this.teamWorkflowAttr.isEmpty();
    }

    private boolean isArtifactTypesSpecified() {
        return !this.getAllArtTypes().isEmpty();
    }

    public IAtsQuery isOfType(ArtifactTypeToken ... artifactTypes) {
        this.artifactTypes = Arrays.asList(artifactTypes);
        return this;
    }

    public IAtsQuery isOfType(Collection<WorkItemType> workItemTypes) {
        for (WorkItemType type : workItemTypes) {
            this.workItemTypes.add(type);
        }
        return this;
    }

    public IAtsQuery isOfType(WorkItemType ... workItemType) {
        return this.isOfType(Arrays.asList(workItemType));
    }

    public IAtsQuery andTeam(IAtsTeamDefinition teamDef) {
        this.teamDefIds.add(teamDef.getId());
        return this;
    }

    public IAtsQuery andStateType(StateType ... stateType) {
        this.stateTypes = Arrays.asList(stateType);
        return this;
    }

    public IAtsQuery andTeam(Collection<IAtsTeamDefinition> teamDefs) {
        return this.andTeam(AtsObjects.toIds(teamDefs));
    }

    public IAtsQuery andAttr(AttributeTypeToken attributeType, Collection<String> values, QueryOption ... queryOptions) {
        this.andAttr.add(new AtsAttributeQuery(attributeType, values, queryOptions));
        return this;
    }

    public IAtsQuery andRelated(IAtsObject object, RelationTypeSide relation) {
        List<IAtsObject> list = this.andRels.get(relation);
        if (list == null) {
            list = new LinkedList<IAtsObject>();
            this.andRels.put(relation, list);
        }
        list.add(object);
        return this;
    }

    public IAtsQuery andIds(Long ... ids) {
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long artifactId = longArray[n2];
            this.artifactIds.add(ArtifactId.valueOf((Long)artifactId));
            ++n2;
        }
        return this;
    }

    public IAtsQuery andIds(Collection<ArtifactId> ids) {
        this.artifactIds.addAll(ids);
        return this;
    }

    public IAtsQuery andAtsIds(Collection<String> atsIds) {
        return this.andAttr((AttributeTypeToken)AtsAttributeTypes.AtsId, atsIds, new QueryOption[0]);
    }

    public IAtsQuery andLegacyIds(Collection<String> legacyIds) {
        return this.andAttr((AttributeTypeToken)AtsAttributeTypes.LegacyPcrId, legacyIds, new QueryOption[0]);
    }

    public IAtsWorkItemFilter andFilter() {
        return new AtsWorkItemFilter(this.getItems());
    }

    protected Set<ArtifactTypeToken> getArtifactTypesFromWorkItemTypes() {
        HashSet<ArtifactTypeToken> artifactTypes = new HashSet<ArtifactTypeToken>();
        if (this.workItemTypes != null) {
            for (WorkItemType workItemType : this.workItemTypes) {
                artifactTypes.add(workItemType.getArtifactType());
            }
        }
        return artifactTypes;
    }

    public IAtsQuery andAttr(AttributeTypeToken attributeType, String value, QueryOption ... queryOption) {
        return this.andAttr(attributeType, Collections.singleton(value), queryOption);
    }

    public <T extends IAtsWorkItem> ResultSet<T> getResults() {
        return ResultSets.newResultSet(this.getItems());
    }

    public <T extends IAtsWorkItem> ResultSet<T> getResultsNew() {
        return ResultSets.newResultSet(this.getItemsNew());
    }

    public IAtsQuery andAssignee(AtsUser ... assignees) {
        ArrayList<String> artIds = new ArrayList<String>();
        AtsUser[] atsUserArray = assignees;
        int n = assignees.length;
        int n2 = 0;
        while (n2 < n) {
            AtsUser user = atsUserArray[n2];
            artIds.add(user.getIdString());
            ++n2;
        }
        return this.andAttr((AttributeTypeToken)AtsAttributeTypes.CurrentStateAssignee, artIds, QueryOption.EXACT_MATCH_OPTIONS);
    }

    public IAtsQuery andAssigneeWas(AtsUser ... assignees) {
        ArrayList<String> userIds = new ArrayList<String>();
        AtsUser[] atsUserArray = assignees;
        int n = assignees.length;
        int n2 = 0;
        while (n2 < n) {
            AtsUser user = atsUserArray[n2];
            userIds.add("<" + user.getUserId() + ">");
            ++n2;
        }
        return this.andAttr((AttributeTypeToken)AtsAttributeTypes.Log, userIds, QueryOption.CONTAINS_MATCH_OPTIONS);
    }

    public <T extends ArtifactToken> ResultSet<T> getResultArtifacts() {
        ArrayList<ArtifactToken> items = new ArrayList<ArtifactToken>();
        for (IAtsWorkItem workItem : this.getResults()) {
            Conditions.assertNotNull((Object)workItem, (String)"Null found in results.", (Object[])new Object[0]);
            items.add(workItem.getStoreObject());
        }
        LinkedList<ArtifactToken> artifacts = new LinkedList<ArtifactToken>();
        for (ArtifactToken artifact : items) {
            boolean artifactTypeMatch = this.isArtifactTypeMatch(artifact, this.artifactTypes);
            boolean releaseOptionMatch = this.isReleaseOptionMatch((ArtifactId)artifact);
            if (!artifactTypeMatch || !releaseOptionMatch) continue;
            artifacts.add(artifact);
        }
        return ResultSets.newResultSet(artifacts);
    }

    public <T extends ArtifactToken> ResultSet<T> getResultArtifactsNew() {
        ArrayList<ArtifactToken> items = new ArrayList<ArtifactToken>();
        for (IAtsWorkItem workItem : this.getResultsNew()) {
            Conditions.assertNotNull((Object)workItem, (String)"Null found in results.", (Object[])new Object[0]);
            items.add(workItem.getStoreObject());
        }
        LinkedList<ArtifactToken> artifacts = new LinkedList<ArtifactToken>();
        for (ArtifactToken artifact : items) {
            boolean artifactTypeMatch = this.isArtifactTypeMatch(artifact, this.artifactTypes);
            boolean releaseOptionMatch = this.isReleaseOptionMatch((ArtifactId)artifact);
            if (!artifactTypeMatch || !releaseOptionMatch) continue;
            artifacts.add(artifact);
        }
        return ResultSets.newResultSet(artifacts);
    }

    private boolean isReleaseOptionMatch(ArtifactId artifact) {
        IAtsWorkItem workItem;
        IAtsTeamWorkflow teamWf;
        if (this.releasedOption == null || this.releasedOption == ReleasedOption.Both) {
            return true;
        }
        boolean match = false;
        if (artifact instanceof ArtifactToken && (teamWf = (workItem = this.atsApi.getWorkItemService().getWorkItem((ArtifactToken)artifact)).getParentTeamWorkflow()) != null) {
            boolean released = this.atsApi.getVersionService().isReleased(teamWf);
            if (this.releasedOption == ReleasedOption.Released && released || this.releasedOption == ReleasedOption.UnReleased && !released) {
                match = true;
            }
        }
        return match;
    }

    public IAtsQuery andOriginator(AtsUser atsUser) {
        return this.andAttr((AttributeTypeToken)AtsAttributeTypes.CreatedBy, atsUser.getUserId(), new QueryOption[0]);
    }

    public IAtsQuery andSubscribed(AtsUser atsUser) {
        return this.andRelated((IAtsObject)atsUser, AtsRelationTypes.SubscribedUser_User);
    }

    public IAtsQuery andFavorite(AtsUser atsUser) {
        return this.andRelated((IAtsObject)atsUser, AtsRelationTypes.FavoriteUser_User);
    }

    public IAtsQuery andTeam(List<Long> teamDefIds) {
        this.teamDefIds = teamDefIds;
        return this;
    }

    public IAtsQuery andActionableItem(IAtsActionableItem actionableItem) {
        this.aiIds.add(actionableItem.getId());
        return this;
    }

    public IAtsQuery andActionableItem(List<Long> aiIds) {
        this.aiIds = aiIds;
        return this;
    }

    public IAtsQuery andVersion(Long versionId) {
        this.versionId = versionId;
        return this;
    }

    public IAtsQuery andState(String stateName) {
        this.stateName = stateName;
        return this;
    }

    public IAtsQuery andChangeType(String changeType) {
        this.changeType = changeType;
        return this;
    }

    public IAtsQuery andProgram(Long programId) {
        this.programId = programId;
        return this;
    }

    public IAtsQuery andInsertion(Long insertionId) {
        this.insertionId = insertionId;
        return this;
    }

    public IAtsQuery andInsertionActivity(Long insertionActivityId) {
        this.insertionActivityId = insertionActivityId;
        return this;
    }

    public IAtsQuery andWorkPackage(Long workPackageId) {
        this.workPackageId = workPackageId;
        return this;
    }

    private void getBaseSearchCriteria(Collection<ArtifactTypeToken> artTypes, boolean withIds, Set<ArtifactTypeToken> allArtTypes) {
        boolean teamDefAndAiNotSpecified;
        this.createQueryBuilder();
        boolean bl = teamDefAndAiNotSpecified = !this.isTeamDefSpecified() && !this.isActionableItemSpecified();
        if (this.isArtifactTypesSpecified() && (this.isOnlyIds() || teamDefAndAiNotSpecified)) {
            this.queryAndIsOfType(artTypes);
        }
        if (withIds && !this.artifactIds.isEmpty()) {
            this.queryAndIds(this.artifactIds);
        }
        this.addStateTypeNameAndAttributeCriteria();
        this.addChangeTypeCriteria();
    }

    public abstract void queryAndIsOfType(Collection<ArtifactTypeToken> var1);

    private void addWorkPackageCriteria() {
        if (this.isWorkPackageSpecified()) {
            ArtifactToken workPackArt = this.atsApi.getQueryService().getArtifact(this.workPackageId);
            this.queryAnd((AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, workPackArt.getIdString());
        }
    }

    public abstract void queryAnd(AttributeTypeToken var1, String var2);

    private void addVersionCriteria() {
        if (this.versionId != null && this.versionId > 0L) {
            this.queryAndRelatedToLocalIds(AtsRelationTypes.TeamWorkflowTargetedForVersion_Version, ArtifactId.valueOf((Long)this.versionId));
        }
    }

    public abstract void queryAndRelatedToLocalIds(RelationTypeSide var1, ArtifactId var2);

    private void addAiCriteria() {
        if (this.isActionableItemSpecified()) {
            List<String> ids = AtsObjects.toIdStringsFromLong(this.aiIds);
            this.queryAnd((AttributeTypeToken)AtsAttributeTypes.ActionableItemReference, ids);
        }
    }

    private void addTeamDefCriteria() {
        if (this.isTeamDefSpecified()) {
            List<String> ids = AtsObjects.toIdStringsFromLong(this.teamDefIds);
            this.queryAnd((AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, ids);
        }
    }

    private void addAttributeCriteria() {
        if (!this.andAttr.isEmpty()) {
            for (AtsAttributeQuery attrQuery : this.andAttr) {
                this.queryAnd(attrQuery.getAttrType(), attrQuery.getValues(), attrQuery.getQueryOption());
            }
        }
    }

    private void addTeamWorkflowAttributeCriteria() {
        if (!this.teamWorkflowAttr.isEmpty()) {
            for (AtsAttributeQuery attrQuery : this.teamWorkflowAttr) {
                this.queryAnd(attrQuery.getAttrType(), attrQuery.getValues(), attrQuery.getQueryOption());
            }
        }
    }

    public abstract void queryAnd(AttributeTypeToken var1, Collection<String> var2, QueryOption[] var3);

    private void addRelationCriteria() {
        if (!this.andRels.isEmpty()) {
            for (Map.Entry<RelationTypeSide, List<IAtsObject>> entry : this.andRels.entrySet()) {
                LinkedList<ArtifactId> artIds = new LinkedList<ArtifactId>();
                for (IAtsObject object : entry.getValue()) {
                    artIds.add(ArtifactId.valueOf((Long)object.getId()));
                }
                this.queryAndRelatedTo(entry.getKey(), artIds);
            }
        }
    }

    public abstract void queryAndRelatedTo(RelationTypeSide var1, List<ArtifactId> var2);

    private void addStateNameCriteria() {
        if (this.stateName != null) {
            this.queryAnd((AttributeTypeToken)AtsAttributeTypes.CurrentStateName, this.stateName, QueryOption.EXACT_MATCH_OPTIONS);
        }
    }

    private void addChangeTypeCriteria() {
        if (this.changeType != null) {
            this.queryAnd((AttributeTypeToken)AtsAttributeTypes.ChangeType, this.changeType, QueryOption.EXACT_MATCH_OPTIONS);
        }
    }

    public abstract void queryAnd(AttributeTypeToken var1, String var2, QueryOption[] var3);

    private void addStateTypeCriteria() {
        if (!this.stateTypes.isEmpty()) {
            ArrayList<String> stateTypeNames = new ArrayList<String>();
            for (StateType type : this.stateTypes) {
                stateTypeNames.add(type.name());
            }
            this.queryAnd((AttributeTypeToken)AtsAttributeTypes.CurrentStateType, stateTypeNames);
        }
    }

    public abstract void queryAndIds(Collection<? extends ArtifactId> var1);

    public void addProgramCriteria() {
        if (!this.isInsertionSpecified() && this.programId != null && this.programId > 0L) {
            ArtifactToken programArt = this.atsApi.getQueryService().getArtifact(this.programId);
            LinkedList<String> workPackageIds = new LinkedList<String>();
            for (ArtifactId insertionArt : this.atsApi.getRelationResolver().getRelated((ArtifactId)programArt, AtsRelationTypes.ProgramToInsertion_Insertion)) {
                for (ArtifactId insertionActivityArt : this.atsApi.getRelationResolver().getRelated(insertionArt, AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity)) {
                    for (ArtifactId workPackageArt : this.atsApi.getRelationResolver().getRelated(insertionActivityArt, AtsRelationTypes.InsertionActivityToWorkPackage_WorkPackage)) {
                        workPackageIds.add(workPackageArt.getIdString());
                    }
                }
            }
            if (!workPackageIds.isEmpty()) {
                this.queryAnd((AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, workPackageIds);
            }
        }
    }

    public void addInsertionCriteria() {
        if (!this.isInsertionActivitySpecified() && this.insertionId != null && this.insertionId > 0L) {
            ArtifactToken insertionArt = this.atsApi.getQueryService().getArtifact(this.insertionId);
            LinkedList<String> workPackageIds = new LinkedList<String>();
            for (ArtifactId insertionActivityArt : this.atsApi.getRelationResolver().getRelated((ArtifactId)insertionArt, AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity)) {
                for (ArtifactId workPackageArt : this.atsApi.getRelationResolver().getRelated(insertionActivityArt, AtsRelationTypes.InsertionActivityToWorkPackage_WorkPackage)) {
                    workPackageIds.add(workPackageArt.getIdString());
                }
            }
            if (!workPackageIds.isEmpty()) {
                this.queryAnd((AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, workPackageIds);
            }
        }
    }

    public abstract void queryAnd(AttributeTypeToken var1, Collection<String> var2);

    public void addInsertionActivityCriteria() {
        List<String> workPackageIds;
        if (!this.isWorkPackageSpecified() && this.insertionActivityId != null && this.insertionActivityId > 0L && !(workPackageIds = this.getWorkPackageIdsFromActivity()).isEmpty()) {
            this.queryAnd((AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, workPackageIds);
        }
    }

    private List<String> getWorkPackageIdsFromActivity() {
        LinkedList<String> ids = new LinkedList<String>();
        if (this.insertionActivityId != null && this.insertionActivityId > 0L) {
            ArtifactToken insertionActivityArt = this.atsApi.getQueryService().getArtifact(this.insertionActivityId);
            for (ArtifactId workPackageArt : this.atsApi.getRelationResolver().getRelated((ArtifactId)insertionActivityArt, AtsRelationTypes.InsertionActivityToWorkPackage_WorkPackage)) {
                ids.add(workPackageArt.getIdString());
            }
        }
        return ids;
    }

    private void addStateTypeNameAndAttributeCriteria() {
        this.addStateTypeCriteria();
        this.addStateNameCriteria();
        this.addAttributeCriteria();
        this.addRelationCriteria();
    }

    public IAtsWorkItemFilter createFilter() {
        return new AtsWorkItemFilter(this.getItems());
    }

    public IAtsQuery andReleased(ReleasedOption releasedOption) {
        this.releasedOption = releasedOption;
        return this;
    }

    public List<AtsAttributeQuery> getTeamWorkflowAttr() {
        return this.teamWorkflowAttr;
    }

    public IAtsQuery andTeamWorkflowAttr(AttributeTypeToken attributeType, List<String> values, QueryOption ... queryOptions) {
        this.teamWorkflowAttr.add(new AtsAttributeQuery(attributeType, values, queryOptions));
        return this;
    }

    public IAtsQuery andFilter(IAtsQueryFilter queryFilter) {
        this.queryFilters.add(queryFilter);
        return this;
    }

    public boolean exists() {
        return !this.getItemIds().isEmpty();
    }

    public IAtsQuery andTag(String ... tags) {
        List<String> values = Arrays.asList(tags);
        return this.andAttr((AttributeTypeToken)CoreAttributeTypes.StaticId, values, QueryOption.EXACT_MATCH_OPTIONS);
    }

    public IAtsQuery andActive(boolean active) {
        return this.andAttr((AttributeTypeToken)CoreAttributeTypes.Active, active ? "true" : "false", new QueryOption[0]);
    }

    public <T extends IAtsWorkItem> Collection<T> getItems(Class<T> clazz) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll(this.getItems());
    }

    public IAtsQuery andName(String name) {
        return this.andAttr((AttributeTypeToken)CoreAttributeTypes.Name, name, new QueryOption[0]);
    }

    public IAtsQuery andName(String name, QueryOption ... queryOption) {
        return this.andAttr((AttributeTypeToken)CoreAttributeTypes.Name, name, queryOption);
    }

    public IAtsQuery andWorkItemType(WorkItemType ... workItemTypes) {
        this.workItemTypes.clear();
        WorkItemType[] workItemTypeArray = workItemTypes;
        int n = workItemTypes.length;
        int n2 = 0;
        while (n2 < n) {
            WorkItemType type = workItemTypeArray[n2];
            this.workItemTypes.add(type);
            ++n2;
        }
        return this;
    }

    public IAtsQuery andVersion(IAtsVersion version) {
        this.andVersion(version.getId());
        return this;
    }

    public IAtsQuery andNotExists(AttributeTypeToken attributeType) {
        this.createQueryBuilder();
        this.queryAndNotExists(attributeType);
        return this;
    }

    protected abstract void queryAndNotExists(AttributeTypeToken var1);

    public IAtsQuery andExists(AttributeTypeToken attributeType) {
        this.createQueryBuilder();
        this.queryAndExists(attributeType);
        return this;
    }

    protected abstract void queryAndExists(AttributeTypeToken var1);

    public String getChangeType() {
        return this.changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }
}

