/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config.tx;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.config.Csci;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.config.tx.AtsTeamDefinitionArtifactToken;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTx;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTxTeamDef;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTxVersion;
import org.eclipse.osee.ats.api.config.tx.IAtsProgramArtifactToken;
import org.eclipse.osee.ats.api.config.tx.IAtsTeamDefinitionArtifactToken;
import org.eclipse.osee.ats.api.config.tx.IAtsVersionArtifactToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.data.AtsTaskDefToken;
import org.eclipse.osee.ats.api.query.NextRelease;
import org.eclipse.osee.ats.api.query.ReleasedOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.core.config.tx.AbstractAtsConfigTxObject;
import org.eclipse.osee.framework.core.data.AccessContextToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsConfigTxTeamDef
extends AbstractAtsConfigTxObject<IAtsConfigTxTeamDef>
implements IAtsConfigTxTeamDef {
    private final IAtsTeamDefinition teamDef;
    private final ArtifactToken workPackageEnumArt = ArtifactToken.SENTINEL;

    public AtsConfigTxTeamDef(IAtsObject atsObject, AtsApi atsApi, IAtsChangeSet changes, IAtsConfigTx cfgTx) {
        super(atsObject, atsApi, changes, cfgTx);
        Conditions.assertTrue((boolean)(atsObject instanceof IAtsTeamDefinition), (String)"AtsObject must be of type IAtsTeamDefinition", (Object[])new Object[0]);
        this.teamDef = (IAtsTeamDefinition)atsObject;
    }

    public IAtsConfigTxTeamDef andWorkDef(NamedId workDefId) {
        this.changes.setSoleAttributeValue((IAtsObject)this.teamDef, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference, (Object)workDefId);
        return this;
    }

    public IAtsConfigTxTeamDef andLeads(UserToken ... leads) {
        UserToken[] userTokenArray = leads;
        int n = leads.length;
        int n2 = 0;
        while (n2 < n) {
            UserToken lead = userTokenArray[n2];
            this.changes.relate((Object)this.teamDef, AtsRelationTypes.TeamLead_Lead, (Object)lead);
            ++n2;
        }
        return this;
    }

    public IAtsConfigTxTeamDef andMembers(UserToken ... members) {
        UserToken[] userTokenArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            UserToken member = userTokenArray[n2];
            this.changes.relate((Object)this.teamDef, AtsRelationTypes.TeamMember_Member, (Object)member);
            ++n2;
        }
        return this;
    }

    public IAtsConfigTxTeamDef andVersion(String name, ReleasedOption released, BranchToken branch, NextRelease nextRelease, IAtsVersionArtifactToken ... parallelVersions) {
        IAtsConfigTxVersion version = this.cfgTx.createVersion(name, released, branch, nextRelease, this.teamDef);
        this.handleParallelVersions(version, parallelVersions);
        return this;
    }

    private void handleParallelVersions(IAtsConfigTxVersion version, IAtsVersionArtifactToken ... parallelVersions) {
        IAtsVersionArtifactToken[] iAtsVersionArtifactTokenArray = parallelVersions;
        int n = parallelVersions.length;
        int n2 = 0;
        while (n2 < n) {
            IAtsVersionArtifactToken parallelVer = iAtsVersionArtifactTokenArray[n2];
            this.changes.relate((ArtifactId)version.getVersion().getStoreObject(), AtsRelationTypes.ParallelVersion_Child, (ArtifactId)parallelVer);
            ++n2;
        }
    }

    public IAtsConfigTxTeamDef andParallelVersion(IAtsVersion ver1, IAtsVersion ver2) {
        this.changes.relate((Object)ver1, AtsRelationTypes.ParallelVersion_Child, (Object)ver2);
        return this;
    }

    public IAtsConfigTxTeamDef andVersion(IAtsVersionArtifactToken versionTok, ReleasedOption released, BranchToken branch, NextRelease nextRelease, IAtsVersionArtifactToken ... parallelVersions) {
        IAtsConfigTxVersion version = this.cfgTx.createVersion(versionTok, released, branch, nextRelease, this.teamDef);
        this.handleParallelVersions(version, parallelVersions);
        return this;
    }

    public IAtsConfigTxTeamDef andVersion(IAtsVersionArtifactToken ... versionToks) {
        IAtsVersionArtifactToken[] iAtsVersionArtifactTokenArray = versionToks;
        int n = versionToks.length;
        int n2 = 0;
        while (n2 < n) {
            IAtsVersionArtifactToken versionTok = iAtsVersionArtifactTokenArray[n2];
            this.cfgTx.createVersion(versionTok, ReleasedOption.UnReleased, null, NextRelease.None, this.teamDef);
            ++n2;
        }
        return this;
    }

    public IAtsConfigTxTeamDef createChildTeamDef(IAtsTeamDefinition parent, IAtsTeamDefinitionArtifactToken childTok) {
        return this.cfgTx.createTeamDef(parent, childTok);
    }

    public IAtsConfigTxTeamDef createChildTeamDef(String name) {
        return this.createChildTeamDef(this.teamDef, AtsTeamDefinitionArtifactToken.valueOf((Long)Lib.generateArtifactIdAsInt(), (String)name));
    }

    public IAtsConfigTxTeamDef andTeamWorkflowArtifactType(ArtifactTypeToken artifactType) {
        this.changes.setSoleAttributeValue((IAtsObject)this.teamDef, (AttributeTypeToken)AtsAttributeTypes.TeamWorkflowArtifactType, (Object)artifactType.getName());
        return this;
    }

    public IAtsConfigTxTeamDef andRelatedTaskWorkflowDefinition(NamedId ... taskWorkDefs) {
        NamedId[] namedIdArray = taskWorkDefs;
        int n = taskWorkDefs.length;
        int n2 = 0;
        while (n2 < n) {
            NamedId id = namedIdArray[n2];
            this.changes.addAttribute((IAtsObject)this.teamDef, (AttributeTypeToken)AtsAttributeTypes.RelatedTaskWorkflowDefinitionReference, (Object)id);
            ++n2;
        }
        return this;
    }

    public IAtsConfigTxTeamDef andRelatedPeerWorkflowDefinition(NamedId ... peerWorkDefs) {
        NamedId[] namedIdArray = peerWorkDefs;
        int n = peerWorkDefs.length;
        int n2 = 0;
        while (n2 < n) {
            NamedId id = namedIdArray[n2];
            this.changes.addAttribute((IAtsObject)this.teamDef, (AttributeTypeToken)AtsAttributeTypes.RelatedPeerWorkflowDefinitionReference, (Object)id);
            ++n2;
        }
        return this;
    }

    public IAtsTeamDefinition getTeamDef() {
        return this.teamDef;
    }

    public IAtsConfigTxTeamDef andTaskSet(AtsTaskDefToken ... taskSets) {
        AtsTaskDefToken[] atsTaskDefTokenArray = taskSets;
        int n = taskSets.length;
        int n2 = 0;
        while (n2 < n) {
            AtsTaskDefToken taskSet = atsTaskDefTokenArray[n2];
            this.changes.addAttribute((IAtsObject)this.teamDef, (AttributeTypeToken)AtsAttributeTypes.TaskSetId, (Object)taskSet.getId());
            ++n2;
        }
        return this;
    }

    public IAtsConfigTxVersion andVersionTx(IAtsVersionArtifactToken versionTok, ReleasedOption released, BranchToken branch, NextRelease nextRelease, IAtsVersionArtifactToken ... parallelVersions) {
        IAtsConfigTxVersion version = this.cfgTx.createVersion(versionTok, released, branch, nextRelease, this.teamDef);
        this.handleParallelVersions(version, parallelVersions);
        return version;
    }

    public IAtsConfigTxTeamDef andWorkType(WorkType workType) {
        this.changes.addAttribute((IAtsObject)this.teamDef, (AttributeTypeToken)AtsAttributeTypes.WorkType, (Object)workType.name());
        return this;
    }

    public IAtsConfigTxTeamDef andProgram(IAtsProgramArtifactToken program) {
        this.changes.addAttribute((IAtsObject)this.teamDef, (AttributeTypeToken)AtsAttributeTypes.ProgramId, (Object)program);
        return this;
    }

    public IAtsConfigTxTeamDef andCsci(Csci ... cscis) {
        Csci[] csciArray = cscis;
        int n = cscis.length;
        int n2 = 0;
        while (n2 < n) {
            Csci csci = csciArray[n2];
            this.changes.addAttribute((IAtsObject)this.teamDef, (AttributeTypeToken)AtsAttributeTypes.CSCI, (Object)csci.name());
            ++n2;
        }
        return this;
    }

    public IAtsConfigTxTeamDef andAccessContexts(AccessContextToken ... contextIds) {
        AccessContextToken[] accessContextTokenArray = contextIds;
        int n = contextIds.length;
        int n2 = 0;
        while (n2 < n) {
            AccessContextToken id = accessContextTokenArray[n2];
            this.and((AttributeTypeToken)CoreAttributeTypes.AccessContextId, String.format("%s, %s", id.getIdString(), id.getName()));
            ++n2;
        }
        return this;
    }

    public IAtsConfigTxTeamDef andAtsIdPrefix(String atsIdPrefix, String seqName, String seqStart) {
        this.changes.setSoleAttributeValue((IAtsObject)this.teamDef, (AttributeTypeToken)AtsAttributeTypes.AtsIdPrefix, (Object)atsIdPrefix);
        this.changes.setSoleAttributeValue((IAtsObject)this.teamDef, (AttributeTypeToken)AtsAttributeTypes.AtsIdSequenceName, (Object)seqName);
        this.changes.addAtsIdSequence(seqName, seqStart);
        return this;
    }

    public IAtsConfigTxTeamDef andWorkPackages(String artName, String ... workPackageNames) {
        if (this.workPackageEnumArt.isInvalid()) {
            Conditions.assertTrue((boolean)Strings.isValid((String)artName), (String)"Invalid art name", (Object[])new Object[0]);
            Conditions.assertTrue((workPackageNames.length > 0 ? 1 : 0) != 0, (String)"Work Package Names can not be empty", (Object[])new Object[0]);
            ArtifactToken enumArt = this.changes.createArtifact(CoreArtifactTypes.OseeTypeEnum, artName);
            this.changes.relate((Object)this.teamDef, CoreRelationTypes.DefaultHierarchical_Child, (Object)enumArt);
            this.changes.addTag(enumArt, "Work Package Enum Art");
            String[] stringArray = workPackageNames;
            int n = workPackageNames.length;
            int n2 = 0;
            while (n2 < n) {
                String workPackage = stringArray[n2];
                Conditions.assertTrue((boolean)Strings.isValid((String)artName), (String)"Invalid package name", (Object[])new Object[0]);
                this.changes.addAttribute((ArtifactId)enumArt, (AttributeTypeToken)CoreAttributeTypes.IdValue, (Object)workPackage);
                ++n2;
            }
        }
        return this;
    }

    public IAtsConfigTxTeamDef andTags(String ... tags) {
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            this.changes.addAttribute((IAtsObject)this.teamDef, (AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)tag);
            ++n2;
        }
        return this;
    }
}

