/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.config.IAtsConfigurationsService;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTx;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.core.config.tx.AtsConfigTxImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;

public abstract class AbstractAtsConfigurationService
implements IAtsConfigurationsService {
    protected AtsConfigurations atsConfigurations;
    protected AtsApi atsApi;
    public static Pattern keyValuePattern = Pattern.compile("^(.*)=(.*)", 32);

    public void setAtsApi(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public IAtsConfigTx createConfigTx(String name) {
        return new AtsConfigTxImpl(name, this.atsApi);
    }

    public boolean isAtsBaseCreated() {
        return this.atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.AtsTopFolder) != null;
    }

    public AtsUser getUserByUserId(String userId) {
        Long artId = (Long)this.getConfigurations().getUserIdToUserArtId().get(userId);
        AtsUser user = (AtsUser)this.getConfigurations().getIdToUser().get(artId);
        return user;
    }

    public AtsUser getUserByName(String name) {
        Long artId = (Long)this.getConfigurations().getUserNameToUserArtId().get(name);
        AtsUser user = (AtsUser)this.getConfigurations().getIdToUser().get(artId);
        return user;
    }

    public AtsUser getUser(ArtifactId userArt) {
        AtsUser user = (AtsUser)this.getConfigurations().getIdToUser().get(userArt.getId());
        return user;
    }

    public AtsUser getUserByLoginId(String loginId) {
        AtsUser user = (AtsUser)this.getConfigurations().getLoginIdToUser().get(loginId);
        return user;
    }
}

