/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.access;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.access.AtsAccessContextTokens;
import org.eclipse.osee.ats.api.access.IAtsAccessService;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AccessContextToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsAccessService
implements IAtsAccessService {
    private static final LoadingCache<BranchId, Collection<AccessContextToken>> branchIdToContextIdCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<BranchId, Collection<AccessContextToken>>(){

        public Collection<AccessContextToken> load(BranchId branch) {
            return AtsApiService.get().getAtsAccessService().getContextIds(branch, false);
        }
    });
    private final AtsApi atsApi;
    private Map<String, Long> accessGuidToId = null;

    public AtsAccessService(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public boolean isApplicable(BranchId branch) {
        boolean result = false;
        try {
            ArtifactId associatedArtifact;
            if (this.atsApi.getAtsBranch().notEqual((Id)branch) && (associatedArtifact = this.atsApi.getBranchService().getAssociatedArtifactId(branch)).isValid()) {
                ArtifactToken assocArt = this.atsApi.getQueryService().getArtifact(associatedArtifact);
                result = assocArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AtsArtifact});
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(AtsAccessService.class, (Level)Level.INFO, (String)"Error determining access applicibility", (Throwable)ex);
        }
        return result;
    }

    public Collection<AccessContextToken> getContextIds(BranchId branch) {
        return this.getContextIds(branch, false);
    }

    public Collection<AccessContextToken> getContextIds(BranchId branch, boolean useCache) {
        ArrayList<AccessContextToken> contextIds;
        if (useCache) {
            try {
                contextIds = (Collection)branchIdToContextIdCache.get((Object)branch);
                if (contextIds != null) {
                    return contextIds;
                }
            }
            catch (ExecutionException executionException) {}
        }
        contextIds = new ArrayList();
        if (branch.isInvalid()) {
            contextIds.add(AtsAccessContextTokens.ATS_BRANCH_READ);
            branchIdToContextIdCache.put((Object)branch, contextIds);
            return contextIds;
        }
        try {
            if (this.atsApi.getAtsBranch().notEqual((Id)branch) && contextIds.isEmpty()) {
                ArtifactId assocArtifact = this.atsApi.getBranchService().getAssociatedArtifactId(branch);
                ArtifactToken assocArt = this.atsApi.getQueryService().getArtifact(assocArtifact);
                if (assocArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                    contextIds.addAll(this.getFromWorkflow((IAtsTeamWorkflow)assocArt));
                } else {
                    contextIds.add(AtsAccessContextTokens.ATS_BRANCH_READ);
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(AtsAccessService.class, (Level)Level.SEVERE, (String)"Exception obtaining Branch Access Context Id; Deny returned", (Throwable)ex);
            contextIds.add(AtsAccessContextTokens.ATS_BRANCH_READ);
        }
        return contextIds;
    }

    public Collection<AccessContextToken> getFromWorkflow(IAtsTeamWorkflow teamWf) {
        HashSet<AccessContextToken> contextIds = new HashSet<AccessContextToken>();
        try {
            ArtifactToken artifact;
            contextIds.addAll(this.getFromArtifact(this.atsApi.getQueryService().getArtifact((IAtsObject)teamWf)));
            if (contextIds.isEmpty()) {
                for (IAtsActionableItem aia : this.atsApi.getActionableItemService().getActionableItems((IAtsWorkItem)teamWf)) {
                    ArtifactToken artifact2 = this.atsApi.getQueryService().getArtifact((IAtsObject)aia);
                    if (artifact2 == null) continue;
                    contextIds.addAll(this.getFromArtifact(artifact2));
                }
            }
            if (contextIds.isEmpty() && (artifact = this.atsApi.getQueryService().getArtifact((IAtsObject)teamWf.getTeamDefinition())) != null) {
                contextIds.addAll(this.getFromArtifact(artifact));
            }
        }
        catch (Exception ex) {
            OseeLog.log(AtsAccessService.class, (Level)Level.SEVERE, (String)"Exception obtaining Branch Access Context Id; Deny returned", (Throwable)ex);
            return Arrays.asList(AtsAccessContextTokens.ATS_BRANCH_READ);
        }
        return contextIds;
    }

    private Collection<AccessContextToken> getFromArtifact(ArtifactToken artifact) {
        HashSet<AccessContextToken> contextIds = new HashSet<AccessContextToken>();
        try {
            for (String id : this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)artifact, (AttributeTypeToken)CoreAttributeTypes.AccessContextId)) {
                contextIds.add(AccessContextToken.valueOf((Long)this.convertAccessAttributeToContextId(id, artifact), (String)("From [" + artifact.getArtifactType().getName() + "]" + artifact.toStringWithId() + " as [" + id + "]")));
            }
            ArtifactToken parent = this.atsApi.getRelationResolver().getParent((ArtifactId)artifact);
            if (contextIds.isEmpty() && parent != null) {
                contextIds.addAll(this.getFromArtifact(parent));
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(AtsAccessService.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return contextIds;
    }

    private Long convertAccessAttributeToContextId(String value, ArtifactToken art) {
        String idStr = value.split(",")[0];
        if (Strings.isNumeric((String)idStr)) {
            return Long.valueOf(idStr);
        }
        if (GUID.isValid((CharSequence)idStr)) {
            return this.getContextGuidToIdMap().get(idStr);
        }
        throw new OseeArgumentException("Invalid access value [%s] on artifact %s", new Object[]{value, art.toStringWithId()});
    }

    public Map<String, Long> getContextGuidToIdMap() {
        if (this.accessGuidToId == null) {
            this.accessGuidToId = new ConcurrentHashMap<String, Long>();
            ArtifactToken mapArt = this.atsApi.getQueryService().getArtifact((ArtifactId)CoreArtifactTokens.AccessIdMap);
            if (mapArt.isValid()) {
                String mapStr = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)mapArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)"");
                String[] stringArray = mapStr.split("\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    String[] values = line.split(",");
                    String guid = values[1];
                    Long id = Long.valueOf(values[0]);
                    this.accessGuidToId.put(guid, id);
                    ++n2;
                }
            }
        }
        return this.accessGuidToId;
    }

    public void setContextIds(IAtsObject atsObject, AccessContextToken ... contextIds) {
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set Context Ids");
        AccessContextToken[] accessContextTokenArray = contextIds;
        int n = contextIds.length;
        int n2 = 0;
        while (n2 < n) {
            AccessContextToken token = accessContextTokenArray[n2];
            changes.addAttribute(atsObject, (AttributeTypeToken)CoreAttributeTypes.AccessContextId, (Object)String.format("%s, %s", token.getIdString(), token.getName()));
            ++n2;
        }
        changes.execute();
    }

    public void clearCaches() {
        branchIdToContextIdCache.invalidateAll();
    }

    public boolean isWorkflowEditable(IAtsWorkItem workItem) {
        boolean isAccessControlWrite = AtsApiService.get().getStoreService().isAccessControlWrite(workItem);
        return isAccessControlWrite;
    }
}

