/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.define.ide.traceability.data.BaseTraceDataCache;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class CodeUnitData
extends BaseTraceDataCache {
    private final Map<String, Artifact> codeUnitMap = new HashMap<String, Artifact>();

    public CodeUnitData(BranchId branch) {
        super("Code Unit Data", branch);
    }

    @Override
    protected void doBulkLoad(IProgressMonitor monitor) throws Exception {
        List codeUnits = ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.CodeUnit, (BranchId)this.getBranch());
        this.populateTraceMap(monitor, codeUnits, this.codeUnitMap);
        monitor.worked(30);
    }

    @Override
    public void reset() {
        super.reset();
        this.codeUnitMap.clear();
    }

    public Collection<Artifact> getAllCodeUnits() {
        return this.codeUnitMap.values();
    }

    public Artifact getCodeUnitByName(String codeUnitName) {
        return this.codeUnitMap.get(codeUnitName);
    }
}

