/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.TemplateManagerEndpoint;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.publishing.FormatIndicator;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.DoubleHashMap;
import org.eclipse.osee.framework.jdk.core.util.DoubleMap;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.internal.ServiceUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBox;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.builder.XWidgetBuilder;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PublishingTemplateBlam
extends AbstractBlam {
    private static final String blamDescription = "Finds a Publishing Template using the server side Publishing Template Manager.";
    private static final String blamName = "Publishing Template BLAM";
    private static final String variableArtifactTypeName = "Artifact Type Name";
    private static final String variableByOptions = "Request Publishing Template By Options";
    private static final String variableFormat = "Format";
    private static final String variableGetAs = "Get As";
    private static final String variableIdentifier = "Identifier";
    private static final String variableOption = "Option";
    private static final String variablePresentationType = "Presentation Type";
    private static final String variableRendererId = "Renderer Id";
    private static final String xWidgetGroupByIdentifier = "byIdentifier";
    private static final String xWidgetGroupByOptions = "byOptions";
    private static Map<String, String> xwidgetGroups = Map.of("Renderer Id", "byOptions", "Artifact Type Name", "byOptions", "Presentation Type", "byOptions", "Option", "byOptions", "Identifier", "byIdentifier");
    private final DoubleMap<String, Boolean, Color> xWidgetBackgroundColors;
    private final Map<String, XWidget> xWidgets = new HashMap<String, XWidget>();

    public PublishingTemplateBlam() {
        super(blamName, blamDescription, null);
        this.xWidgetBackgroundColors = new DoubleHashMap();
    }

    private void enableDisableXWidget(String xWidgetLabel, boolean byOptionsIsChecked) {
        XWidget xWidget = this.xWidgets.get(xWidgetLabel);
        String group = xwidgetGroups.get(xWidgetLabel);
        if (Objects.isNull(group)) {
            return;
        }
        boolean enabled = false;
        switch (group) {
            case "byOptions": {
                enabled = byOptionsIsChecked;
                break;
            }
            case "byIdentifier": {
                enabled = !byOptionsIsChecked;
            }
        }
        xWidget.setEditable(enabled);
        if (!(xWidget instanceof XText)) {
            return;
        }
        XText xText = (XText)xWidget;
        this.xWidgetBackgroundColors.get((Object)xWidgetLabel, (Object)enabled).ifPresent(arg_0 -> ((XText)xText).setBackground(arg_0));
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.DEFINE_HEALTH);
    }

    public List<XWidgetRendererItem> getXWidgetItems() {
        return new XWidgetBuilder().andXCombo(variableGetAs, Arrays.stream(GetAs.values()).map(GetAs::getSelectionString).collect(Collectors.toList())).endWidget().andXCombo(variableFormat, Arrays.stream(FormatIndicator.values()).map(FormatIndicator::getFormatName).collect(Collectors.toList())).endWidget().andWidget(variableByOptions, "XCheckBox").andDefault((Object)true).endWidget().andWidget("By Option Parameters:", "XLabel").endWidget().andWidget(variableRendererId, "XText").andFillVertically().andHeight(22).endWidget().andWidget(variableArtifactTypeName, "XText").andFillVertically().andHeight(22).endWidget().andWidget(variablePresentationType, "XText").andFillVertically().andHeight(22).endWidget().andWidget(variableOption, "XText").andFillVertically().andHeight(22).endWidget().andWidget("By Identifier Parameters:", "XLabel").endWidget().andWidget(variableIdentifier, "XText").andFillVertically().andHeight(22).endWidget().getItems();
    }

    private void requestPublishingTemplate(GetAs getAs, PublishingTemplateRequest publishingTemplateRequest) {
        try {
            OseeClient oseeClient = ServiceUtil.getOseeClient();
            TemplateManagerEndpoint templateManagerEndpoint = oseeClient.getTemplateManagerEndpoint();
            String result = getAs.isPublishingTemplate() ? templateManagerEndpoint.getPublishingTemplate(publishingTemplateRequest).toString() : templateManagerEndpoint.getPublishingTemplateStatus(publishingTemplateRequest);
            String fileName = "PUBLISHING_TEMPLATE_BLAM_" + Lib.getDateTimeString() + ".txt";
            File file = OseeData.getFile((String)fileName);
            Throwable throwable = null;
            Object var9_13 = null;
            try (FileWriter fileWriter = new FileWriter(file);){
                fileWriter.write(result);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Program.launch((String)file.getAbsolutePath());
        }
        catch (Exception e) {
            Message message = new Message().title((CharSequence)"Publishing Template Request Failed").reasonFollows((Throwable)e);
            Throwable cause = e.getCause();
            if (Objects.nonNull(cause)) {
                message.reasonFollows("Caused By", cause);
            }
            AWorkbench.popup((AWorkbench.MessageType)AWorkbench.MessageType.Informational, (String)"Publishing Template Blam Error", (String)"Failed to obtain the requested publishing template.", (String)message.toString(), null, (int)1);
        }
    }

    private void runByIdentifier(VariableMap variableMap, GetAs getAs, FormatIndicator formatIndicator) throws Exception {
        String identifier = variableMap.getString(variableIdentifier);
        if (identifier == null) {
            throw new OseeArgumentException("Must specify an identifier.", new Object[0]);
        }
        PublishingTemplateRequest publishingTemplateRequest = new PublishingTemplateRequest(identifier, formatIndicator);
        this.requestPublishingTemplate(getAs, publishingTemplateRequest);
    }

    private void runByOptions(VariableMap variableMap, GetAs getAs, FormatIndicator formatIndicator) throws Exception {
        String rendererId = variableMap.getString(variableRendererId);
        String artifactTypeName = variableMap.getString(variableArtifactTypeName);
        String presentationType = variableMap.getString(variablePresentationType);
        String option = variableMap.getString(variableOption);
        if (rendererId == null) {
            throw new OseeArgumentException("Must specify a renderer identifier.", new Object[0]);
        }
        if (presentationType == null) {
            throw new OseeArgumentException("Must specifiy a presentation type.", new Object[0]);
        }
        PublishingTemplateRequest publishingTemplateRequest = new PublishingTemplateRequest(rendererId, artifactTypeName, presentationType, option, formatIndicator);
        this.requestPublishingTemplate(getAs, publishingTemplateRequest);
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        String getAsSelection = variableMap.getString(variableGetAs);
        String formatName = variableMap.getString(variableFormat);
        boolean byOptions = variableMap.getBoolean(variableByOptions);
        GetAs getAs = GetAs.ofSelectionString(getAsSelection).orElse(null);
        if (Objects.isNull((Object)getAs)) {
            throw new OseeArgumentException("Must make a selection for \"Get As\".", new Object[0]);
        }
        FormatIndicator formatIndicator = FormatIndicator.ofFormatName((String)formatName).orElse(null);
        if (Objects.isNull(formatIndicator)) {
            if (getAs.isPublishingTemplate()) {
                throw new OseeArgumentException("Must select a format.", new Object[0]);
            }
            formatIndicator = FormatIndicator.WORD_ML;
        }
        if (byOptions) {
            this.runByOptions(variableMap, getAs, formatIndicator);
        } else {
            this.runByIdentifier(variableMap, getAs, formatIndicator);
        }
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, modListener, isEditable);
        String xWidgetLabel = xWidget.getLabel();
        this.xWidgets.put(xWidgetLabel, xWidget);
        if (xWidget instanceof XText) {
            XText xText = (XText)xWidget;
            Color color = xText.getBackground();
            Device device = color.getDevice();
            int red = color.getRed();
            int blue = color.getBlue();
            int green = color.getGreen();
            red = red > 128 ? red / 2 : red * 2;
            blue = blue > 128 ? blue / 2 : blue * 2;
            green = green > 128 ? green / 2 : green * 2;
            Color disabledColor = new Color(device, red, blue, green);
            this.xWidgetBackgroundColors.put((Object)xWidgetLabel, (Object)true, (Object)color);
            this.xWidgetBackgroundColors.put((Object)xWidgetLabel, (Object)false, (Object)disabledColor);
        }
        if (variableByOptions.equals(xWidgetLabel)) {
            final XCheckBox byOptionsCheckBox = (XCheckBox)xWidget;
            byOptionsCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    super.widgetSelected(selectionEvent);
                    boolean isChecked = byOptionsCheckBox.isChecked();
                    PublishingTemplateBlam.this.xWidgets.keySet().forEach(xWidgetLabel -> PublishingTemplateBlam.this.enableDisableXWidget((String)xWidgetLabel, isChecked));
                }
            });
        }
        this.enableDisableXWidget(xWidgetLabel, true);
    }

    public static enum GetAs {
        PUBLISHING_TEMPLATE("Publishing Template"),
        PUBLISHING_TEMPLATE_STATUS("Publishing Template Status");

        private static final Map<String, GetAs> selectionStrings;
        private @NonNull String selectionString;

        static {
            selectionStrings = new HashMap<String, GetAs>();
            GetAs[] getAsArray = GetAs.values();
            int n = getAsArray.length;
            int n2 = 0;
            while (n2 < n) {
                GetAs getAs = getAsArray[n2];
                selectionStrings.put(getAs.selectionString, getAs);
                ++n2;
            }
        }

        public static Optional<GetAs> ofSelectionString(String selectionString) {
            return Objects.nonNull(selectionString) ? Optional.ofNullable(selectionStrings.get(selectionString)) : Optional.empty();
        }

        private GetAs(String selectionString) {
            this.selectionString = (String)Conditions.requireNonNull((Object)selectionString);
        }

        public @NonNull String getSelectionString() {
            return this.selectionString;
        }

        public boolean isPublishingTemplate() {
            return this == PUBLISHING_TEMPLATE;
        }
    }
}

