/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.JaxRsApi;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.utility.OseeInfo;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.osee.framework.ui.swt.Displays;

public class PublishingClearCachesBlam
extends AbstractBlam {
    private static String blamDescription = "Clears the Publishing Template and Datarights Configuration caches on all servers.";
    private static String blamName = "Publishing Clear Caches BLAM";

    public PublishingClearCachesBlam() {
        super(blamName, blamDescription, null);
    }

    private void clearServerCache(JaxRsApi jaxRsApi, Target target, String server, XResultData xResultData, String userAuthId) {
        try {
            WebTarget webTarget = jaxRsApi.newTargetUrl(String.format("%s%s", server, target.getUrlTail()));
            Response response = webTarget.request().delete();
            int responseStatus = response.getStatus();
            if (responseStatus == 204 || responseStatus == 200 || responseStatus == 202) {
                xResultData.logf("\n\nServer %s cache clear was successful.", new Object[]{server});
            } else {
                Response.StatusType statusType = response.getStatusInfo();
                xResultData.logf("\n\nERROR: Server %s cache clear was not successful.", new Object[]{server});
                xResultData.logf("\nResponse: %d - %s", new Object[]{statusType.getStatusCode(), statusType.getReasonPhrase()});
            }
        }
        catch (Exception e) {
            xResultData.logf("\n\nERROR: Server %s cache clear exception %s.\n", new Object[]{server, e.getLocalizedMessage()});
        }
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.DEFINE_HEALTH);
    }

    public List<XWidgetRendererItem> getXWidgetItems() {
        return List.of();
    }

    public String getXWidgetsXml() {
        return "<xWidgets/>";
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(blamName, -1);
        OseeClient oseeClient = (OseeClient)OsgiUtil.getService(((Object)((Object)this)).getClass(), OseeClient.class);
        JaxRsApi jaxRsApi = oseeClient.jaxRsApi();
        final XResultData xResultData = new XResultData();
        String userAuthId = (String)oseeClient.userService().getUser().getLoginIds().get(0);
        xResultData.log("Clear Publishing Template and Data Rights Configuration Caches All Servers");
        long serverCount = Arrays.stream(OseeInfo.getValue((String)"osee.health.servers").replaceAll(" ", "").split(",")).filter(Predicate.not(Strings::isInvalidOrBlank)).peek(server -> Arrays.stream(Target.values()).forEach(target -> this.clearServerCache(jaxRsApi, (Target)((Object)((Object)target)), (String)server, xResultData, userAuthId))).count();
        if (serverCount == 0L) {
            xResultData.logf("\n\nNo %s configured. Other server caches were not cleared.\n\n", new Object[]{"osee.health.servers"});
            Arrays.stream(Target.values()).forEach(target -> target.clearAttachedServerCache(oseeClient));
            xResultData.logf("Connected server caches cleared.", new Object[0]);
        }
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                XResultDataUI.report((XResultData)xResultData, (String)"Cache Clear Results");
            }
        });
        monitor.done();
    }

    private static enum Target {
        DATARIGHTS_MANAGER(oseeClient -> oseeClient.getTemplateManagerEndpoint().deleteCache(), "/define/datarights"),
        TEMPLATE_MANAGER(oseeClient -> oseeClient.getDataRightsEndpoint().deleteCache(), "/define/templatemanager");

        private Consumer<OseeClient> attachedServerClear;
        private String urlTail;

        private Target(Consumer<OseeClient> attachedServerClear, String urlTail) {
            this.attachedServerClear = attachedServerClear;
            this.urlTail = urlTail;
        }

        void clearAttachedServerCache(OseeClient oseeClient) {
            this.attachedServerClear.accept(oseeClient);
        }

        String getUrlTail() {
            return this.urlTail;
        }
    }
}

