/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.widgets.builder.XWidgetBuilder;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.swt.program.Program;

public class PublishingAttributeContentBlam
extends AbstractBlam {
    private static String blamDescription = "Extracts the contents of an Artifact's attribute to a text editor.";
    private static String blamName = "Publishing Attribute Content BLAM";
    private static String messageArtifactIdentifierMustEnterPrefix = "Must enter Artifact Identifier as ";
    private static String messageAttributeIdentifierNotValidForArtifact = "Attribute Identifier is not valid for the type of Artifact.";
    private static final String messageAttributeTypeIdentifierMustEnter = "Must enter Attribute Type Identifier as a long greater than zero.";
    private static String messageBlamFailure = String.valueOf(blamName) + " failed";
    private static final String messageBranchIdentifierMustEnter = "Must enter Branch Identifier as a long greater than zero.";
    private static String messageId32Positive = "an int greater than zero";
    private static String messageId64Positive = "a long greater than zero";
    private static String messageTransactionIdentifierMustEnter = "Must enter Transaction Identifier as a long greater than zero or as \"SENTINEL\".";
    private static String variableArtifactIdentifier = "Artifact Identifier";
    private static String variableAttributeTypeIdentifier = "Attribute Type Identifier";
    private static String variableBranchIdentifier = "Branch Identifier";
    private static String variableTransactionIdentifier = "Transaction Identifier";
    private final String messageArtifactIdentifierMustEnter;
    private final boolean useLongIds = ArtifactToken.USE_LONG_IDS;

    public PublishingAttributeContentBlam() {
        super(blamName, blamDescription, null);
        this.messageArtifactIdentifierMustEnter = this.useLongIds ? messageArtifactIdentifierMustEnterPrefix.concat(messageId64Positive) : messageArtifactIdentifierMustEnterPrefix.concat(messageId32Positive);
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.DEFINE_HEALTH);
    }

    private long getIdentifier(String blamVariable, String mustEnterMessage, boolean forceLong, StringBuilder message) {
        Long identifier;
        String identifierString = this.variableMap.getString(blamVariable);
        if (Objects.isNull(identifierString)) {
            message.append(mustEnterMessage).append("\n");
            return -2L;
        }
        if ("SENTINEL".equals(identifierString)) {
            return -1L;
        }
        try {
            identifier = this.useLongIds || forceLong ? Long.valueOf(identifierString) : Long.valueOf(Integer.valueOf(identifierString).intValue());
        }
        catch (Exception exception) {
            message.append(mustEnterMessage).append("\n");
            return -2L;
        }
        if (identifier <= 0L) {
            message.append(mustEnterMessage).append("\n");
            return -2L;
        }
        return identifier;
    }

    public List<XWidgetRendererItem> getXWidgetItems() {
        return new XWidgetBuilder().andWidget(variableBranchIdentifier, "XText").endWidget().andWidget(variableArtifactIdentifier, "XText").endWidget().andWidget(variableAttributeTypeIdentifier, "XText").endWidget().andWidget(variableTransactionIdentifier, "XText").endWidget().getItems();
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        this.variableMap = variableMap;
        try {
            Artifact artifact;
            StringBuilder message = new StringBuilder(1024);
            long branchIdentifier = this.getIdentifier(variableBranchIdentifier, messageBranchIdentifierMustEnter, true, message);
            long artifactIdentifier = this.getIdentifier(variableArtifactIdentifier, this.messageArtifactIdentifierMustEnter, false, message);
            long attributeTypeIdentifier = this.getIdentifier(variableAttributeTypeIdentifier, messageAttributeTypeIdentifierMustEnter, true, message);
            long transactionIdentifier = this.getIdentifier(variableTransactionIdentifier, messageTransactionIdentifierMustEnter, true, message);
            if (message.length() > 0) {
                AWorkbench.popup((String)message.toString());
                return;
            }
            Artifact artifact2 = artifact = transactionIdentifier == -1L ? ArtifactQuery.getArtifactFromId((long)artifactIdentifier, (BranchId)BranchId.valueOf((Long)branchIdentifier)) : ArtifactQuery.getHistoricalArtifactFromId((ArtifactId)ArtifactId.valueOf((Long)artifactIdentifier), (TransactionToken)TransactionToken.valueOf((TransactionId)TransactionId.valueOf((Long)transactionIdentifier), (BranchId)BranchId.valueOf((Long)branchIdentifier)), (DeletionFlag)DeletionFlag.EXCLUDE_DELETED);
            if (!artifact.isAttributeTypeValid(AttributeTypeId.valueOf((Long)attributeTypeIdentifier))) {
                AWorkbench.popup((String)messageAttributeIdentifierNotValidForArtifact);
                return;
            }
            List attributeList = artifact.getAttributes(AttributeTypeId.valueOf((Long)attributeTypeIdentifier));
            String attributeExtractionMessage = attributeList.stream().map(attribute -> {
                Object value = attribute.getValue();
                if (value instanceof String) {
                    return (String)value;
                }
                return attribute.toString();
            }).collect(Collectors.joining("\n\n"));
            String fileName = new StringBuilder(1024).append("PUBLISHING_ATTRIBUTE_CONTENT_BLAM_").append(artifactIdentifier).append("-").append(branchIdentifier).append("-").append(attributeTypeIdentifier).append("-").append(transactionIdentifier).append("-").append(Lib.getDateTimeString()).append(".txt").toString();
            File file = OseeData.getFile((String)fileName);
            Throwable throwable = null;
            Object var18_16 = null;
            try (FileWriter fileWriter = new FileWriter(file);){
                fileWriter.write(attributeExtractionMessage);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Program.launch((String)file.getAbsolutePath());
        }
        catch (Exception e) {
            AWorkbench.popup((String)new Message().title((CharSequence)messageBlamFailure).reasonFollows((Throwable)e).toString());
        }
    }
}

