/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcException;

public class JdbcConnectionImpl
implements JdbcConnection {
    private final Connection conn;

    public JdbcConnectionImpl(Connection conn) {
        this.conn = conn;
    }

    @Override
    public void close() {
        this.destroy();
    }

    @Override
    public boolean isClosed() {
        boolean result = false;
        try {
            result = this.conn.isClosed();
        }
        catch (SQLException sQLException) {}
        return result;
    }

    @Override
    public DatabaseMetaData getMetaData() throws JdbcException {
        try {
            return this.conn.getMetaData();
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    protected PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    protected PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    protected PreparedStatement prepareStatementGen(String sql) throws SQLException {
        return this.conn.prepareStatement(sql, 1);
    }

    protected CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    protected void destroy() {
        try {
            this.conn.close();
        }
        catch (SQLException sQLException) {}
    }

    protected void setAutoCommit(boolean autoCommit) throws JdbcException {
        try {
            this.conn.setAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    protected boolean getAutoCommit() throws JdbcException {
        try {
            return this.conn.getAutoCommit();
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    protected void commit() throws JdbcException {
        try {
            this.conn.commit();
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    protected void rollback() throws JdbcException {
        try {
            this.conn.rollback();
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }
}

