/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.ChainingArrayList;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedBase;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.jdbc.ObjectType;
import org.eclipse.osee.jdbc.SqlColumn;

public class SqlTable
extends NamedBase {
    private final String aliasPrefix;
    private final ObjectType objectType;
    private final ChainingArrayList<SqlColumn> columns;
    private final ArrayList<String> constraints;
    private final ArrayList<String> statements;
    private final int indexLevel;
    private String insertSql;
    private String tableExtras;

    public SqlTable(String tableName, String aliasPrefix) {
        this(tableName, aliasPrefix, -1);
    }

    public SqlTable(String tableName, String aliasPrefix, int indexLevel) {
        this(tableName, aliasPrefix, ObjectType.UNKNOWN, indexLevel);
    }

    public SqlTable(String tableName, String aliasPrefix, ObjectType objectType) {
        this(tableName, aliasPrefix, objectType, -1);
    }

    public SqlTable(String tableName, String aliasPrefix, ObjectType objectType, int indexLevel) {
        super(tableName);
        this.aliasPrefix = aliasPrefix;
        this.objectType = objectType;
        this.columns = new ChainingArrayList();
        this.constraints = new ArrayList();
        this.statements = new ArrayList();
        this.indexLevel = indexLevel;
    }

    public String getPrefix() {
        return this.aliasPrefix;
    }

    public String getTableExtras() {
        return this.tableExtras;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public List<SqlColumn> getColumns() {
        return this.columns;
    }

    public List<String> getConstraints() {
        return this.constraints;
    }

    public List<String> getStatements() {
        return this.statements;
    }

    public int getIndexLevel() {
        return this.indexLevel;
    }

    public SqlColumn addColumn(String name, JDBCType type) {
        return (SqlColumn)((Object)this.columns.addAndReturn((Object)new SqlColumn(this, name, type)));
    }

    public SqlColumn addColumn(String name, JDBCType type, boolean isNull) {
        return (SqlColumn)((Object)this.columns.addAndReturn((Object)new SqlColumn(this, name, type, isNull)));
    }

    public SqlColumn addAutoIncrementColumn(String name, JDBCType type) {
        return (SqlColumn)((Object)this.columns.addAndReturn((Object)new SqlColumn(this, name, type, false, true)));
    }

    public SqlColumn addColumnWithValueConstraint(String name, JDBCType type, boolean isNull, String valueConstraint) {
        return (SqlColumn)((Object)this.columns.addAndReturn((Object)new SqlColumn(this, name, type, isNull, 0, valueConstraint)));
    }

    public SqlColumn addVarCharColumn(String name, int length) {
        return (SqlColumn)((Object)this.columns.addAndReturn((Object)new SqlColumn(this, name, JDBCType.VARCHAR, true, length, "")));
    }

    public SqlColumn addVarCharColumn(String name, int length, boolean isNull) {
        return (SqlColumn)((Object)this.columns.addAndReturn((Object)new SqlColumn(this, name, JDBCType.VARCHAR, false, length, "")));
    }

    public void setPrimaryKeyConstraint(SqlColumn ... columns) {
        this.constraints.add("CONSTRAINT " + this.getName() + "_PK PRIMARY KEY (" + Collections.toString((String)",", Arrays.asList(columns)) + ")");
    }

    public void setPrimaryKeyConstraint(String key, SqlColumn ... columns) {
        this.constraints.add("CONSTRAINT " + key + "_PK PRIMARY KEY (" + Collections.toString((String)",", Arrays.asList(columns)) + ")");
    }

    public void setForeignKeyConstraint(String constraintName, SqlColumn column, SqlTable refTable, SqlColumn refColumn) {
        this.constraints.add("CONSTRAINT " + constraintName + " FOREIGN KEY (" + (Object)((Object)column) + ") REFERENCES " + (Object)((Object)refTable) + " (" + (Object)((Object)refColumn) + ")");
    }

    public void setForeignKeyConstraintCascadeDelete(String constraintName, SqlColumn column, SqlTable refTable, SqlColumn refColumn) {
        this.constraints.add("CONSTRAINT " + constraintName + " FOREIGN KEY (" + (Object)((Object)column) + ") REFERENCES " + (Object)((Object)refTable) + " (" + (Object)((Object)refColumn) + ") ON DELETE CASCADE");
    }

    public void setUniqueKeyConstraint(String constraintName, String columnName) {
        this.constraints.add("CONSTRAINT " + constraintName + " UNIQUE (" + columnName + ")");
    }

    public void createIndex(String indexName, boolean hasIndexTablespace, SqlColumn ... columns) {
        this.addStatement("CREATE INDEX " + indexName + " ON " + this.getName() + " (" + Collections.toString((String)", ", Arrays.asList(columns)) + ")");
    }

    public void addStatement(String statement) {
        this.statements.add(statement);
    }

    public void setTableExtras(String extras) {
        this.tableExtras = extras;
    }

    public String getInsertIntoSqlWithValues(Object ... parameters) {
        StringBuilder strB = this.getInsertIntoSqlStart();
        int i = 0;
        while (i < parameters.length) {
            JDBCType type;
            if (i != 0) {
                strB.append(", ");
            }
            if ((type = ((SqlColumn)((Object)this.columns.get(i))).getType()).equals(JDBCType.VARCHAR)) {
                strB.append("'");
                strB.append(parameters[i]);
                strB.append("'");
            } else if (parameters[i] instanceof Id) {
                strB.append(((Id)parameters[i]).getIdString());
            } else {
                strB.append(parameters[i].toString());
            }
            ++i;
        }
        strB.append(")");
        return strB.toString();
    }

    public String getInsertSql() {
        if (this.insertSql == null) {
            this.insertSql = this.generateInsertIntoSql();
        }
        return this.insertSql;
    }

    private String generateInsertIntoSql() {
        StringBuilder strB = this.getInsertIntoSqlStart();
        int i = 0;
        while (i < this.columns.size()) {
            if (i != 0) {
                strB.append(", ");
            }
            strB.append("?");
            ++i;
        }
        strB.append(")");
        return strB.toString();
    }

    private StringBuilder getInsertIntoSqlStart() {
        StringBuilder strB = new StringBuilder("INSERT INTO ");
        strB.append(this.getName());
        strB.append(" (");
        Collections.appendToBuilder(this.columns, (String)", ", (StringBuilder)strB);
        strB.append(") VALUES (");
        return strB;
    }

    public String getSelectInsertString(String whereClause) {
        String insertSelectSql = this.getInsertIntoSqlWithValues(this.columns.toArray());
        String firstString = "select '" + insertSelectSql.substring(0, insertSelectSql.lastIndexOf("(") + 1) + "'||";
        String params = insertSelectSql.substring(insertSelectSql.lastIndexOf("(") + 1, insertSelectSql.lastIndexOf(")"));
        boolean first = true;
        String[] stringArray = params.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (first) {
                first = false;
            } else {
                firstString = String.valueOf(firstString) + "||','||";
            }
            firstString = string.contains("'") ? String.valueOf(firstString) + "''''||" + string.replace("'", "") + "||''''" : String.valueOf(firstString) + string;
            ++n2;
        }
        firstString = String.valueOf(firstString) + "||');' insertString from " + this.getName() + whereClause;
        return firstString;
    }
}

