/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.artifacts;

import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.OteArtifactTypes;
import org.eclipse.osee.framework.core.enums.OteAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.attribute.providers.IAttributeDataProvider;
import org.eclipse.osee.framework.skynet.core.attribute.providers.MappedAttributeDataProvider;
import org.eclipse.osee.ote.define.artifacts.OteArtifactFetcher;
import org.eclipse.osee.ote.define.artifacts.TestRunOperator;

public class ArtifactTestRunOperator
implements TestRunOperator {
    private static final OteArtifactFetcher<Artifact> TEST_RUN_ARTIFACT_FETCHER = new OteArtifactFetcher(OteArtifactTypes.TestRun);
    private static final OteArtifactFetcher<Artifact> TEST_SCRIPT_ARTIFACT_FETCHER = new OteArtifactFetcher(CoreArtifactTypes.TestCase);
    private final Artifact artifact;

    public ArtifactTestRunOperator(Artifact artifact) {
        this.checkForNull(artifact);
        this.checkForType(artifact);
        this.artifact = artifact;
    }

    private void checkForNull(Artifact artifact) {
        if (artifact == null) {
            throw new OseeArgumentException("Artifact was null.", new Object[0]);
        }
    }

    private void checkForType(Artifact artifact) {
        if (!artifact.isOfType(new ArtifactTypeId[]{OteArtifactTypes.TestRun})) {
            throw new OseeArgumentException("Unable to operate on type [%s]. Only [%s] allowed.", new Object[]{artifact.getArtifactTypeName(), OteArtifactTypes.TestRun});
        }
    }

    public static ArtifactTestRunOperator getNewArtifactWithOperator(BranchToken branch) {
        return new ArtifactTestRunOperator(TEST_RUN_ARTIFACT_FETCHER.getNewArtifact(branch));
    }

    public static OteArtifactFetcher<Artifact> getTestRunFetcher() {
        return TEST_RUN_ARTIFACT_FETCHER;
    }

    public static OteArtifactFetcher<Artifact> getTestScriptFetcher() {
        return TEST_SCRIPT_ARTIFACT_FETCHER;
    }

    public Artifact getTestRunArtifact() {
        return this.artifact;
    }

    public String getDescriptiveName() {
        return this.artifact.getName();
    }

    @Override
    public String getScriptRevision() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Revision, (Object)"");
    }

    public String getScriptUrl() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)OteAttributeTypes.TestScriptUrl, (Object)"");
    }

    public void setLastDateUploaded(Date value) {
        this.artifact.setSoleAttributeValue((AttributeTypeId)OteAttributeTypes.LastDateUploaded, (Object)value);
    }

    @Override
    public Date getLastDateUploaded() {
        return (Date)this.artifact.getSoleAttributeValue((AttributeTypeId)OteAttributeTypes.LastDateUploaded, null);
    }

    public void setChecksum(String value) {
        this.artifact.setSoleAttributeValue((AttributeTypeId)OteAttributeTypes.Checksum, (Object)value);
    }

    @Override
    public String getChecksum() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)OteAttributeTypes.Checksum, (Object)"");
    }

    public String getOutfileExtension() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Extension, (Object)"");
    }

    public void setOutfileExtension(String outfile) {
        this.artifact.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Extension, (Object)outfile);
    }

    public boolean isFromLocalWorkspace() {
        return this.getLastDateUploaded() == null;
    }

    public void setLocalOutfileURI(String uri) {
        IAttributeDataProvider provider;
        if (this.getOutfileAttribute() != null && (provider = this.getOutfileAttribute().getAttributeDataProvider()) instanceof MappedAttributeDataProvider) {
            ((MappedAttributeDataProvider)provider).setLocalUri(uri);
        }
    }

    @Override
    public String getOutfileUrl() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)OteAttributeTypes.OutfileUrl);
    }

    public String getOutfileContents() {
        try {
            return Lib.inputStreamToString((InputStream)new URI(this.getOutfileUrl()).toURL().openStream());
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public Attribute<InputStream> getOutfileAttribute() {
        List attributes = this.artifact.getAttributes((AttributeTypeId)OteAttributeTypes.OutfileUrl);
        return attributes != null && attributes.size() > 0 ? (Attribute)attributes.get(0) : null;
    }

    public boolean isScriptRevisionValid() {
        boolean toReturn = false;
        try {
            new URI(this.getScriptUrl());
            String revision = this.getScriptRevision();
            if (Strings.isValid((String)revision)) {
                toReturn = true;
            }
        }
        catch (Exception exception) {}
        return toReturn;
    }

    public boolean hasNotBeenCommitted() {
        Artifact fetched = null;
        try {
            fetched = ArtifactTestRunOperator.getTestRunFetcher().searchForUniqueArtifactMatching((AttributeTypeId)OteAttributeTypes.Checksum, this.getChecksum(), (BranchId)this.artifact.getBranch());
        }
        catch (Exception exception) {}
        return fetched == null;
    }

    public boolean isCommitAllowed() {
        return this.isScriptRevisionValid() && this.hasNotBeenCommitted();
    }

    public boolean hasValidArtifact() {
        return this.artifact != null && !this.artifact.isDeleted();
    }

    public void createTestScriptSoftLink() {
        Artifact testScript = ArtifactTestRunOperator.getTestScriptFetcher().searchForUniqueArtifactMatching((AttributeTypeId)CoreAttributeTypes.Name, this.artifact.getName(), (BranchId)this.artifact.getBranch());
        if (testScript != null) {
            this.artifact.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.TestScriptGuid, (Object)testScript.getGuid());
        }
    }

    @Override
    public String getPartition() {
        String name = this.artifact.getName();
        String[] data = name.split("\\.");
        if (data.length - 3 > 0) {
            name = data[data.length - 3];
        }
        return name;
    }

    @Override
    public String getSubsystem() {
        String name = this.artifact.getName();
        String[] data = name.split("\\.");
        if (data.length - 2 > 0) {
            name = data[data.length - 2];
        }
        return name;
    }

    @Override
    public int getTestPointsPassed() {
        return (Integer)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.PassedCount);
    }

    @Override
    public int getTestPointsFailed() {
        return (Integer)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.FailedCount);
    }

    @Override
    public int getTotalTestPoints() {
        return (Integer)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.TotalTestPoints);
    }

    @Override
    public Date getEndDate() {
        return this.processDateAttribute((AttributeTypeId)CoreAttributeTypes.EndDate);
    }

    @Override
    public Date getLastModifiedDate() {
        return this.processDateAttribute((AttributeTypeId)CoreAttributeTypes.LastModifiedDate);
    }

    @Override
    public Date getTestStartDate() {
        return this.processDateAttribute((AttributeTypeId)CoreAttributeTypes.StartDate);
    }

    private Date processDateAttribute(AttributeTypeId attributeType) {
        Date date = (Date)this.artifact.getSoleAttributeValue(attributeType, null);
        if (date == null) {
            date = new Date(0L);
        }
        return date;
    }

    @Override
    public boolean wasAborted() {
        boolean toReturn = true;
        try {
            toReturn = (Boolean)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ScriptAborted, (Object)false);
        }
        catch (Exception exception) {}
        return toReturn;
    }

    @Override
    public String getTestResultStatus() {
        int passed;
        int total;
        String result = "FAILED";
        if (!this.wasAborted() && (total = this.getTotalTestPoints()) > 0 && this.getTestPointsFailed() <= 0 && (passed = this.getTestPointsPassed()) == total) {
            result = "PASSED";
        }
        return result;
    }

    @Override
    public boolean isBatchModeAllowed() {
        boolean toReturn = false;
        try {
            toReturn = (Boolean)this.artifact.getSoleAttributeValue((AttributeTypeId)OteAttributeTypes.IsBatchModeAllowed, (Object)false);
        }
        catch (Exception exception) {}
        return toReturn;
    }

    @Override
    public String getOseeVersion() {
        return ((String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.OseeVersion, (Object)"")).trim();
    }

    @Override
    public String getOseeServerTitle() {
        return ((String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.OseeServerTitle, (Object)"")).trim();
    }

    @Override
    public String getOseeServerVersion() {
        return ((String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.OseeServerJarVersion, (Object)"")).trim();
    }

    @Override
    public String getProcessorId() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ProcessorId, (Object)"");
    }

    @Override
    public String getRunDuration() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ElapsedDate, (Object)"");
    }

    @Override
    public String getQualificationLevel() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.QualificationLevel, (Object)"");
    }

    @Override
    public String getBuildId() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)OteAttributeTypes.BuildId, (Object)"");
    }

    @Override
    public String getRanOnOperatingSystem() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.OsName, (Object)"");
    }

    @Override
    public String getLastAuthor() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.LastAuthor, null);
    }

    @Override
    public String getScriptSimpleName() {
        String rawName = this.getDescriptiveName();
        String[] qualifiers = rawName.split("\\.");
        return qualifiers[qualifiers.length - 1];
    }
}

