/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.viewers.data;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.ote.ui.define.viewers.data.DataItem;
import org.eclipse.osee.ote.ui.define.viewers.data.IXViewerItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ScriptItem
extends DataItem
implements IXViewerItem {
    private static final Matcher urlMatcher = Pattern.compile("(.*)?/(branches|trunk|tags)?(.*)").matcher("");
    private static final String DEFAULT_SCRIPT_NAME = "Script Unknown";
    private static final String DEFAULT_REVISION = "?";
    private static boolean isFullDescriptionMode = true;
    private String scriptUrl;
    private String revision;
    private final Integer key;

    public ScriptItem(String scriptUrl, String revision, DataItem parentItem) {
        super(parentItem);
        this.setScriptUrlAndRevision(scriptUrl, revision);
        this.key = this.generateKey();
    }

    private void setScriptUrlAndRevision(String scriptUrl, String revision) {
        boolean wasThereAnError = false;
        try {
            new URI(scriptUrl);
            this.scriptUrl = scriptUrl;
        }
        catch (Exception exception) {
            wasThereAnError = true;
        }
        try {
            if (Strings.isValid((String)revision)) {
                this.revision = revision;
            } else {
                wasThereAnError = true;
            }
        }
        catch (Exception exception) {
            wasThereAnError = true;
        }
        if (wasThereAnError) {
            this.setDefaultValues();
        }
    }

    private void setDefaultValues() {
        this.scriptUrl = DEFAULT_SCRIPT_NAME;
        this.revision = DEFAULT_REVISION;
    }

    @Override
    public String getData() {
        return String.format("[%s][%s]", this.scriptUrl, this.revision);
    }

    @Override
    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    }

    @Override
    public String getLabel(int index) {
        String toReturn = "";
        if (index == 0) {
            toReturn = !this.scriptUrl.equals(DEFAULT_SCRIPT_NAME) && !this.revision.equals(DEFAULT_REVISION) && ScriptItem.isFullDescriptionModeEnabled() ? this.getFullLabel() : this.getShortLabel();
        }
        return toReturn;
    }

    private String getFullLabel() {
        String repository = null;
        String type = "";
        String path = null;
        urlMatcher.reset(this.scriptUrl);
        if (urlMatcher.find()) {
            repository = urlMatcher.group(1);
            type = urlMatcher.group(2);
            if (!Strings.isValid((String)type)) {
                type = "";
            }
            path = urlMatcher.group(3);
        }
        return String.format("%s [%s] [%s, %s: %s]", this.getScriptName(), this.revision, repository, StringUtils.capitalize((String)type), path);
    }

    private String getScriptName() {
        String url = this.scriptUrl;
        int lastIndex = url.lastIndexOf("/") + 1;
        url = url.substring(lastIndex, url.length());
        return Lib.removeExtension((String)url);
    }

    private String getShortLabel() {
        String url = this.scriptUrl;
        if (!DEFAULT_SCRIPT_NAME.equals(this.scriptUrl)) {
            url = this.getScriptName();
        }
        return String.format("%s [%s]", url, this.revision);
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    private Integer generateKey() {
        int value = 0;
        byte[] byArray = (String.valueOf(this.scriptUrl) + this.revision).getBytes();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte aByte = byArray[n2];
            value += aByte;
            ++n2;
        }
        return value;
    }

    public static void setFullDescriptionModeEnabled(boolean isEnabled) {
        isFullDescriptionMode = isEnabled;
    }

    public static boolean isFullDescriptionModeEnabled() {
        return isFullDescriptionMode;
    }
}

