/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.reports.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.reports.output.IReportWriter;

public class ExcelReportWriter
implements IReportWriter {
    private ISheetWriter sheetWriter;
    private final StringWriter stringWriter;
    private String result;
    private String title = Long.toString(new Date().getTime());

    public ExcelReportWriter() {
        this.stringWriter = new StringWriter();
        try {
            this.sheetWriter = new ExcelXmlWriter((Writer)this.stringWriter);
        }
        catch (IOException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    @Override
    public String getReport() throws IOException {
        if (this.result == null) {
            this.generate();
        }
        return this.result;
    }

    @Override
    public int length() throws IOException {
        if (this.result == null) {
            this.generate();
        }
        return this.result.length();
    }

    @Override
    public void writeHeader(String[] headers) {
        try {
            this.sheetWriter.startSheet(this.title, headers.length);
            this.sheetWriter.writeRow((Object[])headers);
        }
        catch (IOException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    @Override
    public void writeRow(String ... cellData) {
        try {
            this.sheetWriter.writeRow((Object[])cellData);
        }
        catch (IOException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    @Override
    public void writeTitle(String title) {
        this.title = title;
    }

    @Override
    public void writeToOutput(OutputStream outputStream) throws IOException {
        if (this.result == null) {
            this.generate();
        }
        outputStream.write(this.result.getBytes("UTF-8"));
    }

    private void generate() throws IOException {
        this.sheetWriter.endSheet();
        this.sheetWriter.endWorkbook();
        this.result = this.stringWriter.toString();
    }
}

