/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.reports.html;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.reports.html.HtmlActiveTableColumnData;
import org.eclipse.osee.ote.ui.define.utilities.HtmlStringUtils;
import org.osgi.framework.Bundle;

public class HtmlActiveTable {
    private static final String TEMPLATE_PATH = "templates/HtmlActiveTableTemplate";
    private static final String ELEMENT_NAME_TAG = "##ELEMENT_NAME##";
    private static final String TABLE_HEIGHT = "##HEIGHT##";
    private static final String TABLE_WIDTH = "##WIDTH##";
    private static final String TABLE_TITLE = "##TABLE_TITLE##";
    private static final String TABLE_DATA_TAG = "##TABLE_DATA##";
    private static final String CUSTOM_FUNCTIONS_TAG = "##CUSTOM_FUNCTIONS##";
    private static final String COLUMN_METADATA_TAG = "##COLUMN_DATA##";
    private static final String COLUMN_CUSTOMIZATIONS_TAG = "##COLUMN_CUSTOMIZATIONS_DATA##";
    private static final String AUTO_EXPAND_ON_COLUMN = "##AUTO_EXPAND_COLUMN##";
    private String elementName = "ID";
    private String tableHeight = "";
    private String tableWidth = "";
    private String tableTitle;
    private final List<List<String>> rowData = new ArrayList<List<String>>();
    private final List<HtmlActiveTableColumnData> columnList = new ArrayList<HtmlActiveTableColumnData>();

    public HtmlActiveTable() {
        this.tableTitle = this.getClass().getName();
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public void setTableHeight(String tableHeight) {
        this.tableHeight = tableHeight;
    }

    public void setTableWidth(String tableWidth) {
        this.tableWidth = tableWidth;
    }

    public void setTableTitle(String tableTitle) {
        this.tableTitle = tableTitle;
    }

    private URL getTemplate() throws IOException {
        URL url = null;
        Bundle bundle = Activator.getInstance().getBundle();
        if (bundle != null) {
            url = bundle.getEntry(TEMPLATE_PATH);
            url = FileLocator.resolve((URL)url);
        }
        return url;
    }

    public void addColumn(HtmlActiveTableColumnData columnData) {
        this.columnList.add(columnData);
    }

    private String getColumnDataStoreInfo() {
        StringBuilder builder = new StringBuilder();
        int size = this.columnList.size();
        int index = 0;
        while (index < size) {
            HtmlActiveTableColumnData data = this.columnList.get(index);
            builder.append(data.asMetaData());
            if (index + 1 < size) {
                builder.append(",\n");
            }
            ++index;
        }
        return builder.toString();
    }

    private String getColumnCustomizations() {
        StringBuilder builder = new StringBuilder();
        int size = this.columnList.size();
        int index = 0;
        while (index < size) {
            HtmlActiveTableColumnData data = this.columnList.get(index);
            String row = data.asColumnCustomization();
            if (index == 0) {
                row = row.substring(1, row.length());
                builder.append("{ id:");
                String name = data.getName().toLowerCase();
                builder.append(HtmlStringUtils.addSingleQuotes(HtmlStringUtils.escapeString(name)));
                builder.append(", ");
            }
            builder.append(row);
            if (index + 1 < size) {
                builder.append(",\n");
            }
            ++index;
        }
        return builder.toString();
    }

    public String generate() throws IOException {
        URL url = this.getTemplate();
        if (url != null) {
            String template = Lib.inputStreamToString((InputStream)url.openStream());
            try {
                template = template.replace(ELEMENT_NAME_TAG, this.elementName);
                String widthEntry = "autoWidth: true";
                if (Strings.isValid((String)this.tableWidth)) {
                    widthEntry = "width: " + this.tableWidth;
                }
                template = template.replace(TABLE_WIDTH, widthEntry);
                String heightEntry = "autoHeight: true";
                if (Strings.isValid((String)this.tableHeight)) {
                    heightEntry = "height: " + this.tableHeight;
                }
                template = template.replace(TABLE_HEIGHT, heightEntry);
                template = template.replace(TABLE_TITLE, this.tableTitle);
                template = template.replace(COLUMN_METADATA_TAG, this.getColumnDataStoreInfo());
                template = template.replace(TABLE_DATA_TAG, this.generateTableData());
                template = template.replace(CUSTOM_FUNCTIONS_TAG, this.getCustomFunction());
                template = template.replace(COLUMN_CUSTOMIZATIONS_TAG, this.getColumnCustomizations());
                template = template.replace(AUTO_EXPAND_ON_COLUMN, this.getAutoExpandColumn());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return template;
        }
        return null;
    }

    private String getAutoExpandColumn() {
        StringBuilder builder = new StringBuilder();
        if (this.columnList.size() > 0) {
            builder.append("autoExpandColumn: ");
            HtmlActiveTableColumnData data = this.columnList.get(0);
            String name = data.getName().toLowerCase();
            builder.append(HtmlStringUtils.addSingleQuotes(HtmlStringUtils.escapeString(name)));
            builder.append(", autoExpandMin: ");
            builder.append(data.getWidth());
            builder.append(", autoExpandMax: ");
            builder.append(data.getWidth() * 10);
        }
        return builder.toString();
    }

    private String generateTableData() {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (index < this.rowData.size()) {
            builder.append(this.processRow(this.rowData.get(index)));
            if (index + 1 < this.rowData.size()) {
                builder.append(", ");
            }
            ++index;
        }
        return builder.toString();
    }

    private String processRow(List<String> values) {
        StringBuilder builder = new StringBuilder();
        builder.append("[ ");
        int index = 0;
        while (index < values.size()) {
            String rawData = values.get(index);
            String data = HtmlStringUtils.escapeString(rawData != null ? rawData : "");
            HtmlActiveTableColumnData metaData = this.columnList.get(index);
            if (!Strings.isValid((String)metaData.getType()) || metaData.getType().equalsIgnoreCase("string")) {
                data = HtmlStringUtils.addSingleQuotes(data);
            }
            builder.append(data);
            if (index + 1 < values.size()) {
                builder.append(",");
            }
            ++index;
        }
        builder.append(" ]\n");
        return builder.toString();
    }

    public void addDataRow(String ... values) {
        this.rowData.add(Arrays.asList(values));
    }

    public String getElementName() {
        return this.elementName;
    }

    private String getCustomFunction() {
        StringBuilder builder = new StringBuilder();
        return builder.toString();
    }
}

