/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.ote.define.operations.ImportOutfileOperation;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.jobs.CommitJobDialog;

public class CommitTestRunJob
extends Job {
    private static final String JOB_NAME = "Commit Test Runs";
    private final CommitJobDialog jobDialog;
    private Artifact[] committed;

    public CommitTestRunJob(Artifact[] allitems, Artifact[] preSelected, boolean isOverrideAllowed) {
        this(allitems, preSelected, null, isOverrideAllowed);
    }

    public CommitTestRunJob(Artifact[] allitems, Artifact[] preSelected, Artifact[] unselectable, boolean isOverrideAllowed) {
        super(JOB_NAME);
        this.jobDialog = new CommitJobDialog(allitems, preSelected, unselectable, isOverrideAllowed);
    }

    public Artifact[] getCommitted() {
        return this.committed;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus toReturn;
        block5: {
            toReturn = Status.CANCEL_STATUS;
            this.jobDialog.schedule();
            try {
                this.jobDialog.join();
            }
            catch (InterruptedException ex1) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)ex1.toString(), (Throwable)ex1);
            }
            toReturn = this.jobDialog.getResult();
            if (toReturn.getSeverity() == 0) {
                Object[] items = this.jobDialog.getSelected();
                String comment = this.jobDialog.getMessage();
                monitor.beginTask("Commit Artifacts", items.length * 2);
                try {
                    this.committed = this.commitSelectedArtifacts(monitor, comment, items);
                    toReturn = Status.OK_STATUS;
                }
                catch (Exception ex) {
                    if (monitor.isCanceled()) break block5;
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error committing Artifacts.", (Throwable)ex);
                    toReturn = new Status(4, "org.eclipse.osee.ote.ui.define", "Error committing Artifacts.", (Throwable)ex);
                }
            }
        }
        return toReturn;
    }

    private Artifact[] commitSelectedArtifacts(IProgressMonitor monitor, String comment, Object[] items) throws Exception {
        Map<BranchToken, List<Artifact>> commitMap = this.getArtifactsByBranch(items);
        ArrayList<Artifact> committedList = new ArrayList<Artifact>();
        for (BranchToken branch : commitMap.keySet()) {
            monitor.setTaskName(String.format("Committing Artifacts into Branch: [%s]", branch.getName()));
            List<Artifact> artList = commitMap.get(branch);
            ImportOutfileOperation.commitTestRunTx((IProgressMonitor)monitor, (String)comment, (BranchId)branch, (Artifact[])artList.toArray(new Artifact[artList.size()]));
            committedList.addAll(artList);
        }
        return committedList.toArray(new Artifact[committedList.size()]);
    }

    private Map<BranchToken, List<Artifact>> getArtifactsByBranch(Object[] items) {
        HashMap<BranchToken, List<Artifact>> branchMap = new HashMap<BranchToken, List<Artifact>>();
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            Artifact testRun = (Artifact)object;
            BranchToken branch = testRun.getBranchToken();
            ArrayList<Artifact> artList = (ArrayList<Artifact>)branchMap.get(branch);
            if (artList == null) {
                artList = new ArrayList<Artifact>();
                branchMap.put(branch, artList);
            }
            artList.add(testRun);
            ++n2;
        }
        return branchMap;
    }
}

