/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.text.Rule;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.text.rules.ReplaceAll;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class RenameFiles {
    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.out.println("Usage: java library.RenameFiles <directory> <full path pattern> <replacement>\n");
            return;
        }
        ReplaceAll rule = new ReplaceAll(Pattern.compile(args[1]), args[2]);
        List<File> files = Lib.recursivelyListFiles(new File(args[0]).getCanonicalFile());
        int size = files.size();
        int renamedFileCount = 0;
        int i = 0;
        while (i < size) {
            File file = files.get(i);
            ChangeSet newName = ((Rule)rule).computeChanges(file.getPath());
            if (rule.ruleWasApplicable()) {
                File newFile = new File(newName.toString());
                if (file.renameTo(newFile)) {
                    System.out.println(String.valueOf(file.getPath()) + " became " + newFile.getPath());
                    ++renamedFileCount;
                } else {
                    System.out.println(String.valueOf(file.getPath()) + " failed to become " + newFile.getPath());
                }
            }
            ++i;
        }
        System.out.println("Changed " + renamedFileCount + " files");
    }
}

