/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class Zip {
    private Zip() {
    }

    public static byte[] compressByteBuffer(ByteBuffer byteBuffer, String name) {
        return Zip.compressBytes(byteBuffer.array(), name);
    }

    public static byte[] compressBytes(byte[] bytes, String name) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
                return Zip.compressStream(byteArrayInputStream, name);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw OseeCoreException.wrap(e);
        }
    }

    public static void compressDirectory(File directory, String zipTarget, boolean includeSubDirectories) throws IOException, IllegalArgumentException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(String.format("Error source is not a directory: [%s]", directory));
        }
        if (!Strings.isValid(zipTarget)) {
            throw new IllegalArgumentException("Error target zip filename is invalid");
        }
        ZipOutputStream outputStream = null;
        try {
            outputStream = new ZipOutputStream(new FileOutputStream(zipTarget));
            Zip.compressDirectory(directory.getPath(), directory, outputStream, includeSubDirectories);
        }
        catch (Throwable throwable) {
            Lib.close(outputStream);
            throw throwable;
        }
        Lib.close(outputStream);
    }

    private static void compressDirectory(String basePath, File source, ZipOutputStream outputStream, boolean includeSubDirectories) throws IOException {
        File[] children = source.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.isDirectory()) {
                    Zip.compressFile(basePath, file, outputStream);
                } else if (includeSubDirectories) {
                    Zip.compressDirectory(basePath, file, outputStream, includeSubDirectories);
                }
                ++n2;
            }
        }
    }

    public static byte[] compressFile(File file) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream outputStream = null;
        try {
            outputStream = new ZipOutputStream(bos);
            Zip.compressFile(null, file, outputStream);
            outputStream.closeEntry();
        }
        catch (Throwable throwable) {
            Lib.close(outputStream);
            Lib.close(bos);
            throw throwable;
        }
        Lib.close(outputStream);
        Lib.close(bos);
        return bos.toByteArray();
    }

    public static void compressFile(String basePath, File file, ZipOutputStream outputStream) throws IOException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            String entryName = file.getPath();
            if (Strings.isValid(basePath) && entryName.startsWith(basePath)) {
                if (!basePath.endsWith(File.separator)) {
                    basePath = String.valueOf(basePath) + File.separator;
                }
                entryName = entryName.replace(basePath, "");
            }
            ZipEntry entry = new ZipEntry(entryName);
            outputStream.putNextEntry(entry);
            Lib.inputStreamToOutputStream(inputStream, outputStream);
        }
        catch (Throwable throwable) {
            Lib.close(inputStream);
            throw throwable;
        }
        Lib.close(inputStream);
    }

    public static void compressFiles(String basePath, Collection<File> files, String zipTarget) throws IOException {
        if (!Strings.isValid(zipTarget)) {
            throw new IllegalArgumentException("Error target zip filename is invalid");
        }
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(zipTarget));
            for (File file : files) {
                if (file.isDirectory()) continue;
                Zip.compressFile(basePath, file, out);
            }
        }
        catch (Throwable throwable) {
            Lib.close(out);
            throw throwable;
        }
        Lib.close(out);
    }

    public static byte[] compressStream(InputStream in, String name) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(bos);
            out.putNextEntry(new ZipEntry(name));
            Lib.inputStreamToOutputStream(in, out);
            out.closeEntry();
        }
        catch (Throwable throwable) {
            Lib.close(out);
            throw throwable;
        }
        Lib.close(out);
        return bos.toByteArray();
    }

    public static byte[] compressString(String string, String name, Charset charset) {
        return Zip.compressBytes(string.getBytes(charset), name);
    }

    public static byte[] decompressBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(inputStream);
            in.getNextEntry();
            Lib.inputStreamToOutputStream(in, out);
        }
        catch (Throwable throwable) {
            Lib.close(in);
            Lib.close(out);
            throw throwable;
        }
        Lib.close(in);
        Lib.close(out);
        return out.toByteArray();
    }

    public static void decompressStream(InputStream inputStream, File targetDirectory) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(inputStream);
            if (!targetDirectory.exists()) {
                targetDirectory.mkdirs();
            }
            ZipEntry entry = null;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String zipEntryName = entry.getName();
                BufferedOutputStream outputStream = null;
                try {
                    File target = new File(targetDirectory, zipEntryName);
                    if (entry.isDirectory()) continue;
                    File parent = target.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    outputStream = new BufferedOutputStream(new FileOutputStream(target));
                    Lib.inputStreamToOutputStream(zipInputStream, outputStream);
                }
                finally {
                    Lib.close(outputStream);
                }
            }
        }
        catch (Throwable throwable) {
            Lib.close(zipInputStream);
            throw throwable;
        }
        Lib.close(zipInputStream);
    }

    public static void decompressStream(InputStream inputStream, File targetDirectory, String subDirName) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(inputStream);
            if (!targetDirectory.exists()) {
                targetDirectory.mkdirs();
            }
            ZipEntry entry = null;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String zipEntryName = entry.getName();
                BufferedOutputStream outputStream = null;
                try {
                    if (entry.isDirectory() || !zipEntryName.contains("/" + subDirName + "/") && !zipEntryName.startsWith(String.valueOf(subDirName) + "/")) continue;
                    int subDirIndex = zipEntryName.indexOf(subDirName);
                    File target = new File(targetDirectory, zipEntryName = zipEntryName.substring(subDirIndex));
                    File parent = target.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    outputStream = new BufferedOutputStream(new FileOutputStream(target));
                    Lib.inputStreamToOutputStream(zipInputStream, outputStream);
                }
                finally {
                    Lib.close(outputStream);
                }
            }
        }
        catch (Throwable throwable) {
            Lib.close(zipInputStream);
            throw throwable;
        }
        Lib.close(zipInputStream);
    }

    public static String decompressStream(InputStream inputStream, OutputStream outputStream) {
        String zipEntryName = null;
        ZipInputStream zipInputStream = null;
        try {
            try {
                zipInputStream = new ZipInputStream(inputStream);
                ZipEntry entry = zipInputStream.getNextEntry();
                zipEntryName = entry.getName();
                Lib.inputStreamToOutputStream(zipInputStream, outputStream);
            }
            catch (Exception exception) {
                throw new OseeCoreException("Failed to decompress zip stream", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            Lib.close(zipInputStream);
            throw throwable;
        }
        Lib.close(zipInputStream);
        return zipEntryName;
    }

    public static void decompressStream(ZipInputStream zis, byte[] streamBuffer, File unzipLocation) {
        try {
            ZipEntry zipEntry = zis.getNextEntry();
            unzipLocation.mkdirs();
            while (zipEntry != null) {
                File uploadedDirectory = Zip.newFile(unzipLocation, zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!uploadedDirectory.isDirectory() && !uploadedDirectory.mkdirs()) {
                        zis.close();
                        throw new OseeCoreException("Failed to create directory " + uploadedDirectory, new Object[0]);
                    }
                } else {
                    File parent = uploadedDirectory.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        zis.close();
                        throw new OseeCoreException("Failed to create directory " + parent, new Object[0]);
                    }
                    try {
                        Throwable throwable = null;
                        Object var7_10 = null;
                        try (FileOutputStream fos = new FileOutputStream(uploadedDirectory);){
                            int len;
                            while ((len = zis.read(streamBuffer)) > 0) {
                                fos.write(streamBuffer, 0, len);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception ex) {
                        throw new OseeCoreException(ex);
                    }
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (Exception ex) {
            throw new OseeCoreException(ex);
        }
    }

    private static File newFile(File destinationDir, ZipEntry zipEntry) {
        File destFile = new File(destinationDir, zipEntry.getName());
        try {
            String destDirPath = destinationDir.getCanonicalPath();
            String destFilePath = destFile.getCanonicalPath();
            if (!destFilePath.startsWith(String.valueOf(destDirPath) + File.separator)) {
                throw new OseeCoreException("Entry is outside of the target dir: " + zipEntry.getName(), new Object[0]);
            }
        }
        catch (IOException ex) {
            throw new OseeCoreException(ex);
        }
        return destFile;
    }
}

