/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.jdk.core.type.CharSequenceWindow;

public class Strings {
    private static final String AMP = "&";
    private static final String AND = "and";
    private static final String DBL_AMP = "&&";
    public static final String EMPTY_STRING = "";
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");
    private static final String QUOTE_STR = "\"";
    private static final String SPACE_COMMON = "\n|\t|\r|" + System.getProperty("line.separator");
    private static final String STR = "%s%s%s";
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final Pattern SAFENAME = Pattern.compile("^[\\p{L}\\p{N}\\s#$\\-\\.<=>\\[\\]^_`\\{\\}]{1,64}$");
    private static Pattern lineBreak = Pattern.compile("\\R");

    public static String buildStatement(List<?> items, String joiningWord) {
        String statement = null;
        if (items != null) {
            StringBuilder niceList = new StringBuilder();
            if (items.size() >= 2) {
                int andIndex = items.size() - 2;
                int itemIndex = 0;
                while (itemIndex < items.size()) {
                    niceList.append(items.get(itemIndex));
                    if (itemIndex == andIndex) {
                        niceList.append(' ');
                        niceList.append(joiningWord);
                        niceList.append(' ');
                    } else if (itemIndex < andIndex) {
                        niceList.append(", ");
                    }
                    ++itemIndex;
                }
            } else if (!items.isEmpty()) {
                niceList.append(items.get(0));
            }
            statement = niceList.toString();
        }
        return statement;
    }

    public static String buildStatment(List<?> items) {
        return Strings.buildStatement(items, AND);
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static boolean containsIgnoreCase(Collection<String> validValues, String val) {
        for (String validValue : validValues) {
            if (!validValue.equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    public static String emptyString() {
        return EMPTY_STRING;
    }

    public static String escapeAmpersands(String stringWithAmp) {
        return Strings.saferReplace(stringWithAmp, AMP, DBL_AMP);
    }

    public static String intern(String str) {
        return str == null ? null : str.intern();
    }

    public static boolean isBlank(CharSequence value) {
        int i = 0;
        while (i < value.length()) {
            if (!Character.isWhitespace(value.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isInvalid(CharSequence ... values) {
        if (values == null || values.length == 0) {
            return true;
        }
        CharSequence[] charSequenceArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence value = charSequenceArray[n2];
            if (value == null || value.length() == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isInvalid(String value) {
        return value == null || value.isEmpty();
    }

    public static boolean isInValid(String value) {
        return !Strings.isValid(value);
    }

    public static boolean isInvalidOrBlank(String value) {
        return value == null || value.isBlank();
    }

    public static boolean isInvalidOrBlank(CharSequence value) {
        return Objects.isNull(value) || value.length() == 0 || Strings.isBlank(value);
    }

    public static boolean isNotNumeric(String idStr) {
        return !Strings.isNumeric(idStr);
    }

    public static boolean isNameValid(String name) {
        boolean valid = false;
        if (Strings.isValidAndNonBlank(name)) {
            Matcher matcher = SAFENAME.matcher(name);
            valid = matcher.matches();
        }
        return valid;
    }

    public static boolean isNumeric(String value) {
        boolean result = false;
        if (Strings.isValid(value)) {
            Matcher matcher = NUMERIC_PATTERN.matcher(value);
            result = matcher.matches();
        }
        return result;
    }

    public static boolean isPrintable(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    public static boolean isPrintable(String str) {
        return str.equals(Strings.removeNonPrintableCharacters(str));
    }

    public static boolean isValid(CharSequence ... values) {
        if (values == null || values.length == 0) {
            return false;
        }
        CharSequence[] charSequenceArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence value = charSequenceArray[n2];
            if (value == null || value.length() == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isValid(String value) {
        return value != null && !value.isEmpty();
    }

    public static boolean isValidAndNonBlank(String value) {
        return value != null && !value.isBlank();
    }

    public static boolean isValidAndNonBlank(CharSequence value) {
        return Objects.nonNull(value) && value.length() > 0 && !Strings.isBlank(value);
    }

    public static boolean isValidAndNonBlank(Object value) {
        return value instanceof String && !((String)value).isBlank();
    }

    public static String minimize(String value) {
        return Strings.saferReplace(value, SPACE_COMMON, EMPTY_STRING);
    }

    public static boolean notEquals(String tested, String ... tests) {
        if (tested == null && (tests == null || tests.length == 0)) {
            return false;
        }
        if (tested == null) {
            return true;
        }
        if (tests == null || tests.length == 0) {
            return true;
        }
        int i = 0;
        while (i < tests.length) {
            String toTest = tests[i];
            if (toTest == null) {
                return true;
            }
            if (tested.compareTo(toTest) != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean notEquals(CharSequence tested, String ... tests) {
        if (tested == null && (tests == null || tests.length == 0)) {
            return false;
        }
        if (tested == null) {
            return true;
        }
        if (tests == null || tests.length == 0) {
            return true;
        }
        int i = 0;
        while (i < tests.length) {
            String toTest = tests[i];
            if (toTest == null) {
                return true;
            }
            if (CharSequence.compare(tested, toTest) != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String quote(String nameReference) {
        return Strings.wrapWith(nameReference, QUOTE_STR, false);
    }

    public static String removeAllButAlphaNumeric(String str) {
        str = str.replaceAll(" ", "_");
        str = str.replaceAll("[^a-zA-Z0-9_]", EMPTY_STRING);
        return str;
    }

    public static String removeNonPrintableCharacters(String str) {
        str = str.replaceAll("[^\\x00-\\x7F]", EMPTY_STRING);
        str = str.replaceAll("[\\p{Cntrl}&&[^\r\n\t]]", EMPTY_STRING);
        str = str.replaceAll("\\p{C}", EMPTY_STRING);
        return str.trim();
    }

    public static int saferLength(CharSequence input) {
        return Strings.isValid(input) ? input.length() : 0;
    }

    public static String saferReplace(String inputStr, String target, String replacement) {
        return Strings.isValid(inputStr) ? inputStr.replaceAll(target, replacement) : inputStr;
    }

    public static int indexOf(CharSequence charSequence, char character, int start) {
        if (Objects.isNull(charSequence)) {
            return -1;
        }
        int max = charSequence.length();
        int i = start >= 0 ? start : 0;
        while (i < max && charSequence.charAt(i) != character) {
            ++i;
        }
        return i < max ? i : -1;
    }

    public static <T extends Collection<String>> T split(char delimiter, String string, Supplier<T> collectionFactory) {
        int position;
        Collection result = (Collection)Objects.requireNonNull(collectionFactory).get();
        if (Objects.isNull(string)) {
            return (T)result;
        }
        int lastPosition = 0;
        while ((position = string.indexOf(delimiter, lastPosition)) >= 0) {
            result.add(string.substring(lastPosition, position));
            lastPosition = position + 1;
        }
        result.add(string.substring(lastPosition, string.length()));
        return (T)result;
    }

    public static <T extends Collection<String>> T split(char delimiter, String string, int maxSplits, Supplier<T> collectionFactory) {
        int position;
        Collection result = (Collection)Objects.requireNonNull(collectionFactory).get();
        if (Objects.isNull(string)) {
            return (T)result;
        }
        int count = 0;
        int lastPosition = 0;
        while ((position = string.indexOf(delimiter, lastPosition)) >= 0 && count < maxSplits) {
            result.add(string.substring(lastPosition, position));
            lastPosition = position + 1;
            ++count;
        }
        result.add(string.substring(lastPosition, string.length()));
        return (T)result;
    }

    public static <T extends Collection<String>> T split(char delimiter, CharSequence charSequence, Supplier<T> collectionFactory) {
        int position;
        Collection result = (Collection)Objects.requireNonNull(collectionFactory).get();
        if (Objects.isNull(charSequence)) {
            return (T)result;
        }
        int lastPosition = 0;
        while ((position = Strings.indexOf(charSequence, delimiter, lastPosition)) >= 0) {
            result.add(charSequence.subSequence(lastPosition, position).toString());
            lastPosition = position + 1;
        }
        result.add(charSequence.subSequence(lastPosition, charSequence.length()).toString());
        return (T)result;
    }

    public static <T extends Collection<String>> T split(char delimiter, CharSequence charSequence, int maxSplits, Supplier<T> collectionFactory) {
        int position;
        Collection result = (Collection)Objects.requireNonNull(collectionFactory).get();
        if (Objects.isNull(charSequence)) {
            return (T)result;
        }
        int count = 0;
        int lastPosition = 0;
        while ((position = Strings.indexOf(charSequence, delimiter, lastPosition)) >= 0 && count < maxSplits) {
            result.add(charSequence.subSequence(lastPosition, position).toString());
            lastPosition = position + 1;
            ++count;
        }
        result.add(charSequence.subSequence(lastPosition, charSequence.length()).toString());
        return (T)result;
    }

    public static <T extends Collection<CharSequenceWindow>> T splitToLinesInCharSequenceWindows(CharSequence charSequence, Supplier<T> collectionFactory) {
        Collection result = (Collection)Objects.requireNonNull(collectionFactory).get();
        if (Objects.isNull(charSequence)) {
            return (T)result;
        }
        int lastPosition = 0;
        Matcher matcher = lineBreak.matcher(charSequence);
        while (matcher.find()) {
            int position = matcher.start();
            result.add(new CharSequenceWindow(charSequence, lastPosition, position));
            lastPosition = matcher.end();
        }
        if (lastPosition < charSequence.length()) {
            result.add(new CharSequenceWindow(charSequence, lastPosition));
        }
        return (T)result;
    }

    public static <T extends Collection<CharSequenceWindow>> T splitToCharSequenceWindows(char delimiter, CharSequence charSequence, Supplier<T> collectionFactory) {
        int position;
        Collection result = (Collection)Objects.requireNonNull(collectionFactory).get();
        if (Objects.isNull(charSequence)) {
            return (T)result;
        }
        int lastPosition = 0;
        while ((position = Strings.indexOf(charSequence, delimiter, lastPosition)) >= 0) {
            result.add(new CharSequenceWindow(charSequence, lastPosition, position));
            lastPosition = position + 1;
        }
        result.add(new CharSequenceWindow(charSequence, lastPosition));
        return (T)result;
    }

    public static <T extends Collection<CharSequenceWindow>> T splitToCharSequenceWindows(char delimiter, CharSequence charSequence, int maxSplits, Supplier<T> collectionFactory) {
        int position;
        Collection result = (Collection)Objects.requireNonNull(collectionFactory).get();
        if (Objects.isNull(charSequence)) {
            return (T)result;
        }
        int count = 0;
        int lastPosition = 0;
        while ((position = Strings.indexOf(charSequence, delimiter, lastPosition)) >= 0 && count < maxSplits) {
            result.add(new CharSequenceWindow(charSequence, lastPosition, position));
            lastPosition = position + 1;
            ++count;
        }
        result.add(new CharSequenceWindow(charSequence, lastPosition));
        return (T)result;
    }

    public static String totallySaferReplace(CharSequence input, Pattern pattern, String replacement) {
        return Strings.isInvalid(input) || Objects.isNull(pattern) ? (Objects.isNull(input) ? null : input.toString()) : pattern.matcher(input).replaceAll(Objects.nonNull(replacement) ? replacement : EMPTY_STRING);
    }

    public static String truncate(String value, int length) {
        return Strings.truncate(value, length, false);
    }

    public static String truncate(String value, int length, boolean ellipsis) {
        if (!Strings.isValid(value)) {
            return Strings.emptyString();
        }
        String toReturn = value;
        if (value.length() > length) {
            int len = ellipsis && length - 3 > 0 ? length - 3 : length;
            toReturn = String.valueOf(value.substring(0, Math.min(length, len))) + (ellipsis ? "..." : Strings.emptyString());
        }
        return toReturn;
    }

    public static String truncateEndChar(String str, int value) {
        if (Strings.isValid(str) && value == str.charAt(str.length() - 1)) {
            str = Strings.truncate(str, str.length() - 1);
        }
        return str;
    }

    public static String unquote(String nameReference) {
        return Strings.wrapWith(nameReference, QUOTE_STR, true);
    }

    public static String wrapWith(String value, String surroundStr, boolean unWrap) {
        if (Strings.isValid(value)) {
            value = value.trim();
            if (unWrap) {
                if (value.startsWith(surroundStr) && value.endsWith(surroundStr) && 2 * surroundStr.length() < value.length()) {
                    value = value.substring(surroundStr.length(), value.length() - surroundStr.length());
                }
            } else {
                value = String.format(STR, surroundStr, value, surroundStr);
            }
        }
        return value;
    }

    private Strings() {
    }

    public static boolean containsIgnoreCase(@Nullable String string, @Nullable String searchString) {
        if (string == null && searchString == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        if (searchString == null) {
            return true;
        }
        return string.toLowerCase().contains(searchString.toLowerCase());
    }

    public static boolean isLong(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        try {
            Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

