/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class StringRange
implements ToMessage {
    public static int NONNEGATIVE_ENDPOINTS = 1;
    public static int NONNEGATIVE_RANGE = 2;
    private static String[] errorTitles = new String[]{"", "StringRange::new, range length is negative.", "StringRange::new, range end point(s) are negative.", "StringRange::new, range length is negative and range end point(s) are negative."};
    private final int end;
    private final int length;
    private final int options;
    private final int start;

    public StringRange(int start, int end) {
        this.start = start;
        this.end = end;
        this.length = end - start;
        this.options = 0;
    }

    public StringRange(int start, int end, int options) {
        this.start = start;
        this.end = end;
        this.length = end - start;
        this.options = options;
        int status = ((this.options & NONNEGATIVE_RANGE) > 0 && this.length < 0 ? 1 : 0) + ((this.options & NONNEGATIVE_ENDPOINTS) > 0 && (this.start < 0 || this.end < 0) ? 2 : 0);
        if (status > 0) {
            throw new IndexOutOfBoundsException(new Message().title(errorTitles[status]).indentInc().segment("Start", this.start).segment("End", this.end).segment("Length", this.length).toString());
        }
    }

    public StringRange(int start, int end, int offset, int options) {
        this(start + offset, end + offset, options);
    }

    public int absLength() {
        return this.length >= 0 ? this.length : -this.length;
    }

    public StringRange addOffset(int offset) {
        return new StringRange(this.start() + offset, this.end() + offset, this.options);
    }

    public int baseIndex(int index) {
        int baseIndex = this.start + (this.isPositive() ? index : -index - 1);
        this.requireInRange(baseIndex);
        return baseIndex;
    }

    public int end() {
        return this.end;
    }

    public boolean equals(Object other) {
        return other instanceof StringRange && this.start == ((StringRange)other).start && this.end == ((StringRange)other).end;
    }

    public int hashCode() {
        int o = (this.start < 0 ? 2 : 0) + (this.end < 0 ? 1 : 0);
        int e = this.start < this.end ? this.end * this.end + this.start : this.start * this.start + this.start + this.end;
        return o + 4 * e;
    }

    public boolean isInRange(int index) {
        return this.start <= this.end ? index >= this.start && index < this.end : index >= this.end && index < this.start;
    }

    public boolean isInRange(StringRange range) {
        return Math.min(range.start, range.end) >= Math.min(this.start, this.end) && Math.max(range.start, range.end) <= Math.max(this.start, this.end);
    }

    public boolean isPositive() {
        return this.start <= this.end;
    }

    public int length() {
        return this.length;
    }

    private String outOfRangeMessage(int index, String message) {
        return new Message().title(message).title("Index out of bounds for StringRange.").indentInc().segment("index", index).segment("range", this).toString();
    }

    private String rangeOutOfRangeMessage(StringRange checkRange, String message) {
        return new Message().title(message).title("StringRange is out of bounds for StringRange.").indentInc().segment("this range", this).segment("check range", checkRange).toString();
    }

    public void requireInRange(int index) {
        if (!this.isInRange(index)) {
            throw new IndexOutOfBoundsException(this.outOfRangeMessage(index, null));
        }
    }

    public void requireInRange(int index, String message) {
        if (!this.isInRange(index)) {
            throw new IndexOutOfBoundsException(this.outOfRangeMessage(index, message));
        }
    }

    public void requireInRange(int index, Supplier<String> messageSupplier) {
        if (!this.isInRange(index)) {
            throw new IndexOutOfBoundsException(this.outOfRangeMessage(index, Objects.nonNull(messageSupplier) ? messageSupplier.get() : null));
        }
    }

    public void requireInRange(StringRange checkRange) {
        if (!this.isInRange(checkRange)) {
            throw new IndexOutOfBoundsException(this.rangeOutOfRangeMessage(checkRange, null));
        }
    }

    public void requireInRange(StringRange checkRange, String message) {
        if (!this.isInRange(checkRange)) {
            throw new IndexOutOfBoundsException(this.rangeOutOfRangeMessage(checkRange, message));
        }
    }

    public void requireInRange(StringRange checkRange, Supplier<String> messageSupplier) {
        if (!this.isInRange(checkRange)) {
            throw new IndexOutOfBoundsException(this.rangeOutOfRangeMessage(checkRange, Objects.nonNull(messageSupplier) ? messageSupplier.get() : null));
        }
    }

    public int start() {
        return this.start;
    }

    StringRange subRange(int start, int end) {
        return this.subRange(start, end, this.options);
    }

    StringRange subRange(int start, int end, int options) {
        return this.isPositive() ? new StringRange(start, end, this.start, options) : new StringRange(-start, -end, this.start, options);
    }

    @Override
    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title("StringRange").indentInc().segment("start", this.start).segment("end", this.end).segment("length", this.length).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

