/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.xml.publishing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.osee.framework.core.xml.publishing.AbstractElement;

public class AbstractElementList<P extends AbstractElement, C extends AbstractElement>
implements Iterable<C>,
AutoCloseable {
    private final P parent;
    private final List<C> childList;
    private boolean closed;

    public AbstractElementList(P parent) {
        this.parent = (AbstractElement)Objects.requireNonNull(parent, "AbstractElementList::new, parameter \"parent\" cannot be null.");
        this.childList = new ArrayList<C>();
        this.closed = false;
    }

    void add(C child) {
        if (this.closed) {
            throw new IllegalStateException("AbstractElementList::add, the list has already been closed.");
        }
        Objects.requireNonNull(child, "AbstractElementList::add, parameter \"child\" cannot be null.");
        this.childList.add(child);
    }

    @Override
    public void close() {
        if (this.closed) {
            throw new IllegalStateException("AbstractElementList::close, the list has already been closed.");
        }
        this.closed = true;
    }

    public Optional<C> get(int i) {
        return i >= 0 && i < this.size() ? Optional.of((AbstractElement)this.childList.get(i)) : Optional.empty();
    }

    P getParent() {
        return this.parent;
    }

    @Override
    public Iterator<C> iterator() {
        return new Iterator<C>(){
            private int i = 0;
            private final int m;
            {
                this.m = AbstractElementList.this.childList.size();
            }

            @Override
            public boolean hasNext() {
                return this.i < this.m;
            }

            @Override
            public C next() {
                if (this.i >= this.m) {
                    throw new NoSuchElementException("AbstractElementList::iterator, no more elements.");
                }
                return (AbstractElement)AbstractElementList.this.childList.get(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.childList.size();
    }

    public Stream<C> stream() {
        return this.childList.stream();
    }
}

