/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.ServiceLoader;
import java.util.logging.Level;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.util.tracker.ServiceTracker;

public final class OsgiUtil {
    private OsgiUtil() {
    }

    public static void close(ServiceTracker<?, ?> tracker) {
        if (tracker != null) {
            try {
                tracker.close();
            }
            catch (Exception ex) {
                OseeLog.log(OsgiUtil.class, (Level)Level.WARNING, (Throwable)ex);
            }
        }
    }

    public static BundleContext createOsgiBundleContext() {
        FrameworkFactory frameworkFactory = ServiceLoader.load(FrameworkFactory.class).iterator().next();
        HashMap config = new HashMap();
        Framework framework = frameworkFactory.newFramework(config);
        try {
            framework.start();
        }
        catch (BundleException ex1) {
            throw new OseeCoreException("Bundle Exception has occured: " + (Object)((Object)ex1), new Object[0]);
        }
        return framework.getBundleContext();
    }

    public static <T> T getService(Class<?> classFromBundle, Class<T> serviceClass) {
        BundleContext context = FrameworkUtil.getBundle(classFromBundle).getBundleContext();
        if (context == null) {
            throw new OseeCoreException("BundleContext is null for " + classFromBundle, new Object[0]);
        }
        ServiceReference serviceReference = context.getServiceReference(serviceClass);
        if (serviceReference == null) {
            throw new OseeCoreException("ServiceReference is null for " + serviceClass, new Object[0]);
        }
        Object service = context.getService(serviceReference);
        if (service == null) {
            throw new OseeCoreException("getService is null for " + serviceClass, new Object[0]);
        }
        return (T)service;
    }

    public static InputStream getResourceAsStream(Class<?> classFromBundle, String resourcePath) {
        try {
            return new BufferedInputStream(OsgiUtil.getResourceAsUrl(classFromBundle, resourcePath).openStream());
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public static URL getResourceAsUrl(Class<?> classFromBundle, String resourcePath) {
        try {
            Bundle bundle = FrameworkUtil.getBundle(classFromBundle);
            URL resourceUrl = bundle.getResource(resourcePath);
            return FileLocator.toFileURL((URL)resourceUrl);
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public static String getResourceAsString(Class<?> classFromBundle, String resourcePath) {
        try {
            return Lib.inputStreamToString((InputStream)OsgiUtil.getResourceAsStream(classFromBundle, resourcePath));
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }
}

