/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.osee.framework.core.publishing.OptionType;

public enum RendererOption {
    ADD_MERGE_TAG("Add Merge Tag", OptionType.Boolean),
    ALL_ATTRIBUTES("All Attributes", OptionType.Boolean),
    BRANCH("Branch", OptionType.BranchId),
    BRANCH_NAME("Branch Name", OptionType.String),
    CLIENT_RENDERER_CAN_STREAM("Client Renderer Can Stream", OptionType.Boolean),
    COMPARE_BRANCH("Compare Branch", OptionType.BranchId),
    CONTENT_ARTIFACT_TYPE("Content Artifact Type", OptionType.ArtifactTypeToken),
    CONTENT_ATTRIBUTE_ONLY("Template Only", OptionType.Boolean),
    EXECUTE_VB_SCRIPT("execute.vb.script", OptionType.String),
    FILENAME_FORMAT("FilenameFormat", OptionType.FilenameFormat),
    FIRST_TIME("First Time", OptionType.Boolean),
    IN_PUBLISH_MODE("In Publish Mode", OptionType.Boolean),
    INCLUDE_UUIDS("Include Uuids", OptionType.Boolean),
    LINK_TYPE("linkType", OptionType.LinkType),
    MAINTAIN_ORDER("Maintain Order", OptionType.Boolean),
    MAX_OUTLINE_DEPTH("Maximum Outlining Depth", OptionType.Integer),
    NO_DISPLAY("No Display", OptionType.Boolean),
    OPEN_OPTION("open.option", OptionType.String),
    ORIG_PUBLISH_AS_DIFF("Orig Publish As Diff", OptionType.Boolean),
    OUTLINING_OPTION_OVERRIDE_EXCLUDE_ARTIFACT_TYPES("ExcludeArtifactTypes", OptionType.ArtifactTypes),
    OUTLINING_OPTION_OVERRIDE_CONTENT_ATTRIBUTE_TYPE("ContentAttributeType", OptionType.String),
    OUTLINING_OPTION_OVERRIDE_HEADING_ARTIFACT_TYPE("HeadingArtifactType", OptionType.String),
    OUTLINING_OPTION_OVERRIDE_HEADING_ATTRIBUTE_TYPE("HeadingAttributeType", OptionType.String),
    OUTLINING_OPTION_OVERRIDE_INCLUDE_HEADINGS("IncludeHeadings", OptionType.IncludeHeadings),
    OUTLINING_OPTION_OVERRIDE_INCLUDE_MAIN_CONTENT_FOR_HEADINGS("IncludeMainContentForHeadings", OptionType.IncludeMainContentForHeadings),
    OUTLINING_OPTION_OVERRIDE_INCLUDE_METADATA_ATTRIBUTES("IncludeMetadataAttributes", OptionType.IncludeMetadataAttributes),
    OUTLINING_OPTION_OVERRIDE_OUTLINE_NUMBER("OutlineNumber", OptionType.String),
    OUTLINE_TYPE("Outline Type", OptionType.String),
    OUTPUT_PATH("OutputPath", OptionType.Path),
    OUTPUT_STREAM("Output Stream", OptionType.OutputStream),
    OVERRIDE_DATA_RIGHTS("Override Data Rights", OptionType.String),
    PARAGRAPH_NUMBER("Paragraph Number", OptionType.String),
    PROGRESS_MONITOR("Progress Monitor", OptionType.ProgressMonitor),
    PUBLISH_DIFF("Publish Diff", OptionType.Boolean),
    PUBLISH_IDENTIFIER("Publish Identifier", OptionType.String),
    PUBLISHING_FORMAT("PublishingFormat", OptionType.FormatIndicator),
    PUBLISHING_TEMPLATE_IDENTIFIER("Publishing Template Identifier", OptionType.String),
    RECURSE_ON_LOAD("Recurse On Load", OptionType.Boolean),
    RENDER_LOCATION("RenderLocation", OptionType.RenderLocation),
    RESULT_PATH_RETURN("resultPath", OptionType.String),
    SECOND_TIME("SecondTime", OptionType.Boolean),
    SKIP_DIALOGS("Skip Dialogs", OptionType.Boolean),
    SKIP_ERRORS("Skip Errors", OptionType.Boolean),
    TEMPLATE_OPTION("Template", OptionType.String),
    THREE_WAY_MERGE("THREE_WAY_MERGE", OptionType.String),
    TRANSACTION_OPTION("Transaction Option", OptionType.Transaction),
    UPDATE_PARAGRAPH_NUMBERS("Update Paragraph Numbers", OptionType.Boolean),
    USE_ARTIFACT_NAMES("Use Artifact Names", OptionType.Boolean),
    USE_PARAGRAPH_NUMBERS("Use Paragraph Numbers", OptionType.Boolean),
    USE_TEMPLATE_ONCE("Use Template Once", OptionType.Boolean),
    VIEW("View", OptionType.ArtifactId),
    WAS_BRANCH("Was Branch", OptionType.BranchId),
    DIFF_NO_ATTRIBUTES_VALUE("DIFF_NO_ATTRIBUTES", OptionType.String),
    DIFF_VALUE("DIFF", OptionType.String),
    OPEN_IN_MARKDOWN_EDITOR_VALUE("Markdown Editor", OptionType.String),
    OPEN_IN_MS_WORD_VALUE("MS Word", OptionType.String),
    PREVIEW_ALL_NO_ATTRIBUTES_VALUE("PREVIEW_ALL_NO_ATTRIBUTES", OptionType.String),
    PREVIEW_ALL_RECURSE_NO_ATTRIBUTES_VALUE("PREVIEW_WITH_RECURSE_NO_ATTRIBUTES", OptionType.String),
    PREVIEW_ALL_RECURSE_VALUE("PREVIEW_ALL_RECURSE", OptionType.String),
    PREVIEW_ALL_VALUE("PreviewAll", OptionType.String),
    PREVIEW_WITH_RECURSE_VALUE("PREVIEW_WITH_RECURSE", OptionType.String);

    private static ObjectMapper objectMapper;
    private static final Map<String, RendererOption> rendererOptions;
    private final String key;
    private final OptionType type;

    static {
        objectMapper = RendererOption.createObjectMapper();
        rendererOptions = new HashMap<String, RendererOption>();
        RendererOption[] rendererOptionArray = RendererOption.values();
        int n = rendererOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            RendererOption rendererOption = rendererOptionArray[n2];
            rendererOptions.put(rendererOption.getKey(), rendererOption);
            ++n2;
        }
    }

    private static <T> void addDeserializer(SimpleModule simpleModule, Class<T> objectClass, JsonDeserializer<?> jsonDeserializer) {
        simpleModule.addDeserializer(objectClass, jsonDeserializer);
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule simpleModule = RendererOption.createSimpleModule(objectMapper);
        objectMapper.registerModule((Module)simpleModule);
        return objectMapper;
    }

    private static SimpleModule createSimpleModule(ObjectMapper objectMapper) {
        Version version = new Version(1, 0, 0, "", "", "");
        SimpleModule simpleModule = new SimpleModule(RendererOption.class.getName(), version);
        RendererOption[] rendererOptionArray = RendererOption.values();
        int n = rendererOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            RendererOption rendererOption = rendererOptionArray[n2];
            OptionType optionType = rendererOption.getType();
            JsonDeserializer<?> jsonDeserializer = optionType.getJsonDeserializer();
            Class<?> optionClass = optionType.getImplementationClass();
            if (jsonDeserializer != null) {
                RendererOption.addDeserializer(simpleModule, optionClass, jsonDeserializer);
            }
            ++n2;
        }
        return simpleModule;
    }

    public static Optional<RendererOption> ofKey(String key) {
        return Objects.nonNull(key) ? Optional.ofNullable(rendererOptions.get(key)) : Optional.empty();
    }

    @JsonCreator
    public static RendererOption valueOfKey(String key) {
        return rendererOptions.get(key);
    }

    private RendererOption(String key, OptionType type) {
        this.key = key;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public OptionType getType() {
        return this.type;
    }

    public Object readValue(JsonNode jsonNode) {
        try {
            OptionType optionType = this.getType();
            if (optionType.isCollection()) {
                CollectionType javaType = objectMapper.getTypeFactory().constructCollectionType(List.class, optionType.getImplementationClass());
                jsonNode.toString();
                Object vector = objectMapper.readValue(jsonNode.traverse(), (JavaType)javaType);
                return vector;
            }
            Object scalar = objectMapper.treeToValue((TreeNode)jsonNode, this.getType().getImplementationClass());
            return scalar;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

