/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class OutlineSectionResult {
    private final @NonNull SectionStatus sectionStatus;
    private final @Nullable CharSequence sectionText;

    private OutlineSectionResult(@NonNull SectionStatus sectionStatus, @Nullable CharSequence sectionText) {
        this.sectionStatus = sectionStatus;
        this.sectionText = sectionText;
    }

    static @NonNull OutlineSectionResult of(@NonNull CharSequence sectionText) {
        CharSequence safeSectionText = (CharSequence)Conditions.requireNonNull((Object)sectionText);
        return new OutlineSectionResult(SectionStatus.STARTED, safeSectionText);
    }

    static @NonNull OutlineSectionResult excluded() {
        return new OutlineSectionResult(SectionStatus.EXCLUDED, null);
    }

    static @NonNull OutlineSectionResult notAHeading() {
        return new OutlineSectionResult(SectionStatus.NOT_A_HEADING, null);
    }

    public boolean isStarted() {
        return this.sectionStatus == SectionStatus.STARTED;
    }

    public void ifStarted(@NonNull Consumer<@NonNull CharSequence> consumer) {
        if (this.sectionStatus == SectionStatus.STARTED) {
            Consumer safeConsumer = (Consumer)Conditions.requireNonNull(consumer, (String)"consumer");
            Conditions.requireNonNull((Object)this.sectionText, (Conditions.ValueType)Conditions.ValueType.MEMBER, (String)"sectionText");
            safeConsumer.accept(this.sectionText);
        }
    }

    public void ifStartedOrElse(@NonNull Consumer<@NonNull CharSequence> consumer, @NonNull Runnable runnable) {
        if (this.sectionStatus == SectionStatus.STARTED) {
            Consumer safeConsumer = (Consumer)Conditions.requireNonNull(consumer, (String)"consumer");
            Conditions.requireNonNull((Object)this.sectionText, (Conditions.ValueType)Conditions.ValueType.MEMBER, (String)"sectionText");
            safeConsumer.accept(this.sectionText);
        } else {
            Runnable safeRunnable = (Runnable)Conditions.requireNonNull((Object)runnable, (String)"runnable");
            safeRunnable.run();
        }
    }

    public boolean isExcluded() {
        return this.sectionStatus == SectionStatus.EXCLUDED;
    }

    public boolean isNotAHeading() {
        return this.sectionStatus == SectionStatus.NOT_A_HEADING;
    }

    public @NonNull CharSequence getHeadingText() {
        return (CharSequence)Conditions.requireNonNull((Object)this.sectionText, (Conditions.ValueType)Conditions.ValueType.MEMBER, (String)"sectionText");
    }

    private static enum SectionStatus {
        STARTED,
        EXCLUDED,
        NOT_A_HEADING;

    }
}

