/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.core.publishing.SectionNumberWhenMaximumOutlineLevelExceeded;
import org.eclipse.osee.framework.core.publishing.TrailingDot;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class OutlineNumber {
    private static int maximumMaximumOutlineLevel = 16;
    private static Pattern splitPattern = Pattern.compile("\\.");
    private int currentIndex;
    private int currentIndexNoMaximum;
    private String currentOutlineNumber;
    private final int maximumIndex;
    private final int maximumOutlineLevel;
    private final int outlineLevelInitialValue;
    private final @NonNull int[] outlineNumber;
    private final @NonNull Pattern outlineNumberCheckPattern;
    private final @NonNull String[] outlineStrings;
    private final @NonNull SectionNumberWhenMaximumOutlineLevelExceeded sectionNumberWhenMaximumOutlineLevelExceeded;
    private final @NonNull TrailingDot trailingDot;

    public OutlineNumber(int maximumOutlineLevel, int outlineLevelInitialValue, @NonNull TrailingDot trailingDot, @NonNull SectionNumberWhenMaximumOutlineLevelExceeded sectionNumberWhenMaximumOutlineLevelExceeded) {
        this.trailingDot = (TrailingDot)((Object)Conditions.requireNonNull((Object)((Object)trailingDot), (String)"trailingDot"));
        this.sectionNumberWhenMaximumOutlineLevelExceeded = (SectionNumberWhenMaximumOutlineLevelExceeded)((Object)Conditions.requireNonNull((Object)((Object)sectionNumberWhenMaximumOutlineLevelExceeded), (String)"sectionNumberWhenMaximumOutlineLevelExceeded"));
        this.maximumOutlineLevel = maximumOutlineLevel = maximumOutlineLevel < 1 ? 1 : (maximumOutlineLevel > maximumMaximumOutlineLevel ? maximumMaximumOutlineLevel : maximumOutlineLevel);
        this.outlineLevelInitialValue = outlineLevelInitialValue;
        this.maximumIndex = maximumOutlineLevel - 1;
        this.currentIndex = 0;
        this.currentIndexNoMaximum = 0;
        this.outlineNumber = new int[maximumOutlineLevel];
        this.outlineStrings = new String[maximumOutlineLevel];
        this.outlineNumber[0] = this.outlineLevelInitialValue;
        this.outlineStrings[0] = Integer.toString(this.outlineLevelInitialValue);
        int i = 1;
        while (i < maximumOutlineLevel) {
            this.outlineNumber[i] = -1;
            this.outlineStrings[i] = null;
            ++i;
        }
        this.outlineNumberCheckPattern = maximumOutlineLevel == 1 ? Pattern.compile("[0-9]+\\.?") : Pattern.compile("(?:[0-9]+\\.){0," + this.maximumIndex + "}[0-9]+\\.?");
        this.generateOutlineNumberString();
    }

    public void endLevel() {
        int lastIndex = this.currentIndex;
        if (this.currentIndexNoMaximum <= 0) {
            this.currentIndexNoMaximum = 0;
            this.currentIndex = 0;
        } else {
            --this.currentIndexNoMaximum;
            int n = this.currentIndex = this.currentIndexNoMaximum <= this.maximumIndex ? this.currentIndexNoMaximum : this.maximumIndex;
        }
        if (lastIndex != this.currentIndex) {
            this.outlineNumber[lastIndex] = -1;
            this.outlineStrings[lastIndex] = null;
        } else {
            int n = lastIndex;
            this.outlineNumber[n] = this.outlineNumber[n] - 1;
            int sectionNumber = this.outlineNumber[lastIndex];
            this.outlineStrings[lastIndex] = Integer.toString(sectionNumber);
        }
        this.generateOutlineNumberString();
    }

    private void generateOutlineNumberString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        int i = 0;
        while (i < this.maximumOutlineLevel && this.outlineNumber[i] >= 0) {
            stringBuilder.append(this.outlineStrings[i]).append(".");
            ++i;
        }
        if (this.trailingDot.isNo()) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        this.currentOutlineNumber = stringBuilder.toString();
    }

    public int getOutlineLevel() {
        return this.currentIndex + 1;
    }

    public Optional<String> getOutlineNumberString() {
        if (this.currentIndexNoMaximum <= this.maximumIndex) {
            return Optional.of(this.currentOutlineNumber);
        }
        switch (this.sectionNumberWhenMaximumOutlineLevelExceeded) {
            case INCREMENT_CURRENT_LEVEL: {
                return Optional.of(this.currentOutlineNumber);
            }
            case NO_SECTION_NUMBER: {
                return Optional.empty();
            }
        }
        throw Conditions.invalidCase((Object)((Object)this.sectionNumberWhenMaximumOutlineLevelExceeded), (String)"sectionNumberWhenMaximumOutlineLevelExceeded", string -> new OseeCoreException(string, new Object[0]));
    }

    public boolean isAtOrAboveMaximumOutlingLevel() {
        return this.currentIndexNoMaximum >= this.maximumIndex;
    }

    public boolean isAboveMaximumOutlingLevel() {
        return this.currentIndexNoMaximum > this.maximumIndex;
    }

    public boolean isValidOutlineNumber(@Nullable CharSequence outlineNumber) {
        String[] outlineStrings;
        if (Strings.isInvalidOrBlank((CharSequence)outlineNumber)) {
            return false;
        }
        Matcher matcher = this.outlineNumberCheckPattern.matcher(outlineNumber);
        boolean patternMatches = matcher.matches();
        if (!patternMatches) {
            return false;
        }
        String[] stringArray = outlineStrings = splitPattern.split(outlineNumber);
        int n = outlineStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String levelString = stringArray[n2];
            Integer level = Integer.valueOf(levelString);
            if (level < this.outlineLevelInitialValue) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void nextSection() {
        int n = this.currentIndex;
        int n2 = this.outlineNumber[n] + 1;
        this.outlineNumber[n] = n2;
        int sectionNumber = n2;
        this.outlineStrings[this.currentIndex] = Integer.toString(sectionNumber);
        this.generateOutlineNumberString();
    }

    public String setOutlineNumber(CharSequence outlineNumber) {
        Matcher matcher = this.outlineNumberCheckPattern.matcher(outlineNumber);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(new Message().title((CharSequence)"OutlineNumber::setOutlineNumber, outline line number does not match outline number pattern.").indentInc().segment((CharSequence)"Outline Number", (Object)outlineNumber).segment((CharSequence)"Outline Number Check Pattern", (Object)this.outlineNumberCheckPattern).toString());
        }
        String[] outlineStrings = splitPattern.split(outlineNumber, this.maximumOutlineLevel);
        int i = 0;
        while (i < this.maximumOutlineLevel) {
            if (i < outlineStrings.length) {
                String outlineSegment;
                this.outlineStrings[i] = outlineSegment = outlineStrings[i];
                this.outlineNumber[i] = Integer.valueOf(outlineSegment);
            } else {
                this.outlineStrings[i] = null;
                this.outlineNumber[i] = -1;
            }
            ++i;
        }
        this.currentIndexNoMaximum = outlineStrings.length - 1;
        this.currentIndex = this.currentIndexNoMaximum <= this.maximumIndex ? this.currentIndexNoMaximum : this.maximumIndex;
        this.generateOutlineNumberString();
        return this.currentOutlineNumber;
    }

    public void startLevel() {
        ++this.currentIndexNoMaximum;
        if (this.currentIndexNoMaximum <= this.maximumIndex) {
            this.currentIndex = this.currentIndexNoMaximum;
            this.outlineNumber[this.currentIndex] = this.outlineLevelInitialValue;
        } else {
            int n = this.currentIndex;
            this.outlineNumber[n] = this.outlineNumber[n] + 1;
        }
        int sectionNumber = this.outlineNumber[this.currentIndex];
        this.outlineStrings[this.currentIndex] = Integer.toString(sectionNumber);
        this.generateOutlineNumberString();
    }
}

