/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.core.publishing.IncludeHeadings;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Message;

public class IncludeHeadingsDeserializer
extends StdDeserializer<IncludeHeadings> {
    private static final long serialVersionUID = 1L;

    public IncludeHeadingsDeserializer() {
        super(IncludeHeadings.class);
    }

    public @NonNull IncludeHeadings deserialize(@NonNull JsonParser jsonParser, @Nullable DeserializationContext deserializationContext) throws IOException {
        JsonParser safeJsonParser = (JsonParser)Conditions.requireNonNull((Object)jsonParser);
        JsonNode readTree = (JsonNode)safeJsonParser.getCodec().readTree(safeJsonParser);
        JsonNode safeReadTree = (JsonNode)Conditions.requireNonNull((Object)readTree);
        String includeHeadingsValue = safeReadTree instanceof TextNode ? ((TextNode)readTree).asText() : readTree.get("includeHeading").asText();
        IncludeHeadings includeHeadings = IncludeHeadings.ofOutliningOptionName(includeHeadingsValue).orElseThrow(() -> new OseeCoreException(new Message().title((CharSequence)"IncludeHeadings::deserialize, unknown value name.").indentInc().segment((CharSequence)"Value Name", (Object)includeHeadingsValue).toString(), new Object[0]));
        return (IncludeHeadings)((Object)Conditions.requireNonNull((Object)((Object)includeHeadings)));
    }
}

