/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.publishing.FilenameFactory;
import org.eclipse.osee.framework.core.publishing.FilenameFormat;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class FilenameSpecification {
    private final FilenameFormat filenameFormat;
    private final @NonNull CharSequence extension;
    private final @NonNull String key;
    private final @NonNull CharSequence[] segments;

    public FilenameSpecification(@NonNull String key, @NonNull FilenameFormat filenameFormat, @NonNull CharSequence extension, CharSequence ... segments) {
        this.key = (String)Conditions.requireNonNull((Object)key, (String)"key");
        this.filenameFormat = (FilenameFormat)((Object)Conditions.requireNonNull((Object)((Object)filenameFormat), (String)"filenameFormat"));
        this.extension = (CharSequence)Conditions.requireNonNull((Object)extension, (String)"extension");
        this.segments = (CharSequence[])Conditions.requireNonNull((Object)segments, (String)"segments");
    }

    @NonNull String build() {
        switch (this.filenameFormat) {
            case PREVIEW: {
                String filename = FilenameFactory.create((CharSequence)FilenameFactory.getDateSegment(), (CharSequence)FilenameFactory.getRandomSegment(), this.extension, this.segments);
                return filename;
            }
            case EXPORT: {
                String filename = FilenameFactory.create(this.extension, this.segments[0]);
                return filename;
            }
        }
        throw Conditions.invalidCase((Object)((Object)this.filenameFormat), (String)"filenameFormat", IllegalStateException::new);
    }

    public @NonNull String getKey() {
        return this.key;
    }
}

