/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public enum AllowedOutlineTypes {
    ANYTHING{

        @Override
        public boolean isAllowed(@NonNull PublishingArtifact artifact, @Nullable ArtifactTypeToken allowedHeadingArtifactTypeToken) {
            Conditions.requireNonNull((Object)artifact, (String)"artifact");
            return true;
        }
    }
    ,
    FOLDERS_ONLY{

        @Override
        public boolean isAllowed(@NonNull PublishingArtifact artifact, @Nullable ArtifactTypeToken allowedHeadingArtifactTypeToken) {
            PublishingArtifact safeArtifact = (PublishingArtifact)Conditions.requireNonNull((Object)artifact, (String)"artifact");
            return safeArtifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.Folder});
        }
    }
    ,
    HEADERS_AND_FOLDERS_ONLY{

        @Override
        public boolean isAllowed(@NonNull PublishingArtifact artifact, @Nullable ArtifactTypeToken allowedHeadingArtifactTypeToken) {
            PublishingArtifact safeArtifact = (PublishingArtifact)Conditions.requireNonNull((Object)artifact, (String)"artifact");
            return safeArtifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractHeading, CoreArtifactTypes.Folder});
        }
    }
    ,
    HEADERS_ONLY{

        @Override
        public boolean isAllowed(@NonNull PublishingArtifact artifact, @Nullable ArtifactTypeToken allowedHeadingArtifactTypeToken) {
            PublishingArtifact safeArtifact = (PublishingArtifact)Conditions.requireNonNull((Object)artifact, (String)"artifact");
            return safeArtifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractHeading});
        }
    }
    ,
    RESTRICTED{

        @Override
        public boolean isAllowed(@NonNull PublishingArtifact artifact, @Nullable ArtifactTypeToken allowedHeadingArtifactTypeToken) {
            PublishingArtifact safeArtifact = (PublishingArtifact)Conditions.requireNonNull((Object)artifact, (String)"artifact");
            return Objects.nonNull(allowedHeadingArtifactTypeToken) ? safeArtifact.isOfType(new ArtifactTypeId[]{allowedHeadingArtifactTypeToken}) : true;
        }
    };


    public abstract boolean isAllowed(@NonNull PublishingArtifact var1, @Nullable ArtifactTypeToken var2);
}

