/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchIdDeserializer;
import org.eclipse.osee.framework.core.data.BranchIdSerializer;
import org.eclipse.osee.framework.jdk.core.type.BaseId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Lib;

@JsonSerialize(using=BranchIdSerializer.class)
@JsonDeserialize(using=BranchIdDeserializer.class)
public interface BranchId
extends Id {
    public static final BranchId SENTINEL = BranchId.valueOf(Id.SENTINEL);

    public static BranchId valueOf(String id) {
        return (BranchId)Id.valueOf((String)id, BranchId::valueOf);
    }

    public static BranchId create(Long id, ArtifactId view) {
        final class BranchIdImpl
        extends BaseId
        implements BranchId {
            private final ArtifactId viewId;

            public BranchIdImpl(Long id, ArtifactId view) {
                super(id);
                this.viewId = view;
            }

            @Override
            public ArtifactId getViewId() {
                return this.viewId;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof BranchId)) {
                    return false;
                }
                BranchId otherBranchId = (BranchId)obj;
                if (!super.equals((Object)otherBranchId)) {
                    return false;
                }
                ArtifactId otherViewId = otherBranchId.getViewId();
                if (Objects.isNull(this.viewId) && Objects.isNull(otherViewId)) {
                    return true;
                }
                if (Objects.isNull(this.viewId)) {
                    return false;
                }
                return this.viewId.equals(otherViewId);
            }

            @Override
            public boolean isSameBranch(BranchId other) {
                return this.id.equals(Objects.requireNonNull(other).getId());
            }
        }
        return new BranchIdImpl(id, view);
    }

    public static BranchId valueOf(Long id) {
        return BranchId.create(id, ArtifactId.SENTINEL);
    }

    public static BranchId create() {
        return BranchId.valueOf(Lib.generateUuid());
    }

    default public ArtifactId getViewId() {
        return ArtifactId.SENTINEL;
    }

    default public boolean isSameBranch(BranchId other) {
        Long thisId = Objects.requireNonNull(this.getId());
        Long otherId = Objects.requireNonNull(Objects.requireNonNull(other).getId());
        return thisId.equals(otherId);
    }
}

