/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.Multiplicity;
import org.eclipse.osee.framework.jdk.core.type.Id;

public class ArtifactWithRelationsAttribute {
    private final AttributeTypeToken attributeTypeToken;
    private final Multiplicity multiplicity;
    private final IAttribute<?> attribute;
    private final ArtifactTypeToken artifactTypeToken;
    private final OrcsTokenService tokenService;

    public ArtifactWithRelationsAttribute(AttributeTypeToken attributeTypeToken, Multiplicity multiplicity) {
        this.attributeTypeToken = attributeTypeToken;
        this.multiplicity = multiplicity;
        this.attribute = null;
        this.artifactTypeToken = null;
        this.tokenService = null;
    }

    public ArtifactWithRelationsAttribute(IAttribute<?> attribute, ArtifactTypeToken artifactTypeToken, OrcsTokenService tokenService) {
        this.attribute = attribute;
        this.artifactTypeToken = artifactTypeToken;
        this.tokenService = tokenService;
        this.attributeTypeToken = attribute.getAttributeType();
        this.multiplicity = null;
    }

    public String getName() {
        return this.attributeTypeToken.getName();
    }

    public String getTypeId() {
        return this.attributeTypeToken.getIdString();
    }

    public String getStoreType() {
        return this.attributeTypeToken.getStoreType();
    }

    public String getMultiplicityId() {
        if (this.multiplicity != null) {
            return this.multiplicity.getIdString();
        }
        if (this.tokenService != null && this.artifactTypeToken != null && this.attribute != null) {
            return this.tokenService.getArtifactType(this.artifactTypeToken.getId()).getValidAttributeTypes().stream().filter(attrType -> this.attribute.getAttributeType().getId().equals(attrType.getId())).map(attrTok -> this.artifactTypeToken.getMultiplicity((AttributeTypeToken)attrTok).getIdString()).findFirst().orElse(Id.SENTINEL.toString());
        }
        return "";
    }

    public String getId() {
        if (this.attribute != null) {
            return this.attribute.getIdString();
        }
        return "";
    }

    public String getValue() {
        if (this.attribute != null) {
            Object value = this.attribute.getValue();
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return (String)value;
            }
            try {
                Object nameAttribute = value.getClass().getMethod("getName", new Class[0]).invoke(value, new Object[0]);
                return nameAttribute != null ? nameAttribute.toString() : "";
            }
            catch (Exception exception) {
                return value.toString();
            }
        }
        return "";
    }
}

