/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.logger.slf4j.internal;

import java.util.Objects;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.logger.Log;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Sfl4jLogImpl
implements Log {
    private static final int LOG_ERROR = 1;
    private static final int LOG_WARNING = 2;
    private static final int LOG_INFO = 3;
    private static final int LOG_DEBUG = 4;
    private static final int LOG_TRACE = 5;
    private Logger logger;
    private Marker marker;

    public void start(ComponentContext context) {
        if (this.logger == null) {
            Bundle usingBundle = context.getUsingBundle();
            String symbolicName = null;
            symbolicName = usingBundle != null ? usingBundle.getSymbolicName() : "Osee Log";
            this.logger = LoggerFactory.getLogger((String)symbolicName);
            this.marker = MarkerFactory.getMarker((String)symbolicName);
            this.debug("Logger setup for [%s]", this.logger.getName());
        }
    }

    public void stop() {
        this.logger = null;
        this.marker = null;
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(5);
    }

    public void trace(String format, Object ... args) {
        this.logHelper(5, null, format, args);
    }

    public void trace(Throwable th, String format, Object ... args) {
        this.logHelper(5, th, format, args);
    }

    public void traceNoFormat(Throwable throwable, CharSequence message) {
        this.logHelperNoFormat(5, throwable, message);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(4);
    }

    public void debug(String format, Object ... args) {
        this.logHelper(4, null, format, args);
    }

    public void debug(Throwable th, String format, Object ... args) {
        this.logHelper(4, th, format, args);
    }

    public void debugNoFormat(Throwable throwable, CharSequence message) {
        this.logHelperNoFormat(4, throwable, message);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(3);
    }

    public void info(String format, Object ... args) {
        this.logHelper(3, null, format, args);
    }

    public void info(Throwable th, String format, Object ... args) {
        this.logHelper(3, th, format, args);
    }

    public void infoNoFormat(Throwable throwable, CharSequence message) {
        this.logHelperNoFormat(3, throwable, message);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(2);
    }

    public void warn(String format, Object ... args) {
        this.logHelper(2, null, format, args);
    }

    public void warn(Throwable th, String format, Object ... args) {
        this.logHelper(2, th, format, args);
    }

    public void warnNoFormat(Throwable throwable, CharSequence message) {
        this.logHelperNoFormat(2, throwable, message);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(1);
    }

    public void error(String format, Object ... args) {
        this.logHelper(1, null, format, args);
    }

    public void error(Throwable th, String format, Object ... args) {
        this.logHelper(1, th, format, args);
    }

    public void errorNoFormat(Throwable throwable, CharSequence message) {
        this.logHelperNoFormat(1, throwable, message);
    }

    private boolean isEnabled(int level) {
        if (Objects.isNull(this.logger)) {
            return false;
        }
        switch (level) {
            case 4: {
                return this.logger.isDebugEnabled();
            }
            case 1: {
                return this.logger.isErrorEnabled();
            }
            case 2: {
                return this.logger.isWarnEnabled();
            }
            case 3: {
                return this.logger.isInfoEnabled();
            }
        }
        return this.logger.isTraceEnabled();
    }

    private void logAtLevel(int level, Throwable throwable, CharSequence message) {
        if (Objects.isNull(this.logger)) {
            return;
        }
        switch (level) {
            case 4: {
                this.logger.debug(this.marker, message.toString(), throwable);
                break;
            }
            case 1: {
                this.logger.error(this.marker, message.toString(), throwable);
                break;
            }
            case 2: {
                this.logger.warn(this.marker, message.toString(), throwable);
                break;
            }
            case 3: {
                this.logger.info(this.marker, message.toString(), throwable);
                break;
            }
            default: {
                this.logger.trace(this.marker, message.toString(), throwable);
            }
        }
    }

    private void logHelper(int level, Throwable th, String format, Object ... args) {
        if (!this.isEnabled(level)) {
            return;
        }
        String message = Sfl4jLogImpl.safeFormat(format, args);
        if (Objects.isNull(message)) {
            return;
        }
        this.logAtLevel(level, th, message);
    }

    private void logHelperNoFormat(int level, Throwable throwable, CharSequence message) {
        if (!this.isEnabled(level)) {
            return;
        }
        message = Objects.nonNull(message) ? message : "";
        this.logAtLevel(level, throwable, message);
    }

    private static String safeFormat(String message, Object ... args) {
        String toReturn;
        try {
            toReturn = String.format(message, args);
        }
        catch (RuntimeException ex) {
            StringBuilder builder = new StringBuilder();
            builder.append("Log message could not be formatted:");
            builder.append(message);
            builder.append(" with the following arguments [");
            builder.append(Collections.toString((String)",", (Object[])args));
            builder.append("].  Cause [");
            builder.append(ex.toString());
            builder.append("]");
            toReturn = builder.toString();
        }
        return toReturn;
    }
}

