/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.world.search.VersionTargetedForTeamSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldUISearchItem;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class WorkingCompletePeerReviewReportSearchItem
extends VersionTargetedForTeamSearchItem {
    public WorkingCompletePeerReviewReportSearchItem() {
        super(null, null, false, WorldSearchItem.LoadView.WorldEditor);
    }

    @Override
    public Collection<Artifact> performSearch(WorldSearchItem.SearchType searchType) {
        ArrayList<Artifact> arts = new ArrayList<Artifact>();
        for (IAtsTeamWorkflow teamWf : AtsApiService.get().getVersionService().getTargetedForTeamWorkflows(this.getSearchVersionArtifact())) {
            for (IAtsAbstractReview review : AtsApiService.get().getReviewService().getReviews(teamWf)) {
                if (!review.isPeerReview() || !review.isInWork() && !review.isCompleted()) continue;
                arts.add((Artifact)review.getStoreObject());
            }
        }
        if (this.isCancelled()) {
            return EMPTY_SET;
        }
        return arts;
    }

    @Override
    public WorldUISearchItem copy() {
        return new WorkingCompletePeerReviewReportSearchItem();
    }

    @Override
    public String getName() {
        return "Working/Completed Peer Review Search";
    }

    @Override
    public String getSelectedName(WorldSearchItem.SearchType searchType) {
        return this.getName();
    }
}

