/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.ide.config.editor.AtsConfigLabelProvider;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldUISearchItem;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeDialog;

public class SearchTeamWorkflowsByProgramSearchItem
extends WorldUISearchItem {
    private final boolean includeCompletedCancelled;
    private IAtsProgram program;

    public SearchTeamWorkflowsByProgramSearchItem(String name, IAtsProgram program, boolean includeCompletedCancelled) {
        super(name, AtsImage.GLOBE);
        this.program = program;
        this.includeCompletedCancelled = includeCompletedCancelled;
    }

    public SearchTeamWorkflowsByProgramSearchItem(SearchTeamWorkflowsByProgramSearchItem searchItem) {
        super(searchItem.getName(), AtsImage.GLOBE);
        this.includeCompletedCancelled = searchItem.includeCompletedCancelled;
        this.program = searchItem.program;
    }

    @Override
    public Collection<Artifact> performSearch(WorldSearchItem.SearchType searchType) {
        if (this.isCancelled()) {
            return EMPTY_SET;
        }
        ArrayList<Artifact> arts = new ArrayList<Artifact>();
        AtsSearchData data = new AtsSearchData(this.getName());
        data.getWorkItemTypes().add(WorkItemType.TeamWorkflow);
        for (IAtsTeamDefinition teamDef : AtsApiService.get().getProgramService().getTeamDefs(this.program)) {
            data.getTeamDefIds().add(teamDef.getId());
        }
        if (!this.includeCompletedCancelled) {
            data.setStateTypes(Arrays.asList(StateType.Working));
        }
        arts.addAll(Collections.castAll((Collection)AtsApiService.get().getQueryService().getArtifacts(data, null).getArtifacts()));
        return arts;
    }

    @Override
    public void performUI(WorldSearchItem.SearchType searchType) {
        super.performUI(searchType);
        if (this.program == null) {
            FilteredTreeDialog dialog = new FilteredTreeDialog("Select Program", "Select Program", (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new AtsConfigLabelProvider(null));
            dialog.setInput((Object)AtsApiService.get().getProgramService().getPrograms());
            dialog.setMultiSelect(false);
            if (dialog.open() == 0) {
                this.program = (IAtsProgram)dialog.getSelectedFirst();
            } else {
                this.cancelled = true;
            }
        }
    }

    @Override
    public WorldUISearchItem copy() {
        return new SearchTeamWorkflowsByProgramSearchItem(this);
    }
}

