/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.ide.util.AtsEditor;
import org.eclipse.osee.ats.ide.world.IWorldEditorConsumer;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class MultipleIdSearchData
implements IWorldEditorConsumer {
    private String enteredIds = "";
    private final List<String> ids = new ArrayList<String>();
    private boolean includeArtIds;
    private BranchId branch;
    private String name;
    private WorldEditor worldEditor;
    private final AtsEditor atsEditor;
    private boolean openEach = false;

    public MultipleIdSearchData(String name, AtsEditor atsEditor) {
        this.name = name;
        this.atsEditor = atsEditor;
    }

    public boolean hasValidInput() {
        return Strings.isValid((String)this.enteredIds);
    }

    public boolean isIncludeArtIds() {
        return this.includeArtIds;
    }

    public String getEnteredIds() {
        return this.enteredIds;
    }

    private void extractIds() {
        String[] stringArray = this.getEnteredIds().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            str = str.replaceAll("^\\s+", "");
            if (!(str = str.replaceAll("\\s+$", "")).equals("")) {
                this.ids.add(str);
            }
            if (str.length() == 5 && !this.ids.contains(str.toUpperCase())) {
                this.ids.add(str.toUpperCase());
            }
            ++n2;
        }
    }

    public List<String> getIds() {
        if (this.ids.isEmpty()) {
            this.extractIds();
        }
        return this.ids;
    }

    public BranchId getBranchForIncludeArtIds() {
        return this.branch;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setWorldEditor(WorldEditor worldEditor) {
        this.worldEditor = worldEditor;
    }

    @Override
    public WorldEditor getWorldEditor() {
        return this.worldEditor;
    }

    public void setEnteredIds(String enteredIds) {
        this.enteredIds = enteredIds;
    }

    public void setIncludeArtIds(boolean includeArtIds) {
        this.includeArtIds = includeArtIds;
    }

    public void setBranch(BranchId branch) {
        this.branch = branch;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AtsEditor getAtsEditor() {
        return this.atsEditor;
    }

    public boolean isOpenEach() {
        return this.openEach;
    }

    public void setOpenEach(boolean openEach) {
        this.openEach = openEach;
    }
}

