/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.transition;

import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.model.LayoutItem;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.util.widgets.dialog.CancelledReasonEnumDialog;
import org.eclipse.osee.ats.ide.util.widgets.dialog.UserListDialog;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.Displays;

public class TransitionDataUi {
    public static void getCancellationReason(final TransitionData transData) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                IAtsWorkItem workItem = (IAtsWorkItem)transData.getWorkItems().iterator().next();
                StateDefinition stateDef = null;
                try {
                    stateDef = AtsApiService.get().getWorkDefinitionService().getStateDefinitionByName(workItem, transData.getToStateName());
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
                if (stateDef != null && stateDef.isCancelled()) {
                    TransitionResults results = new TransitionResults();
                    AtsApiService.get().getWorkItemService().validateUserGroupTransition(workItem, stateDef, results);
                    if (!results.isEmpty()) {
                        results.getTimeRd().addTimeMapToResultData();
                    } else {
                        boolean useEntryCancelWidgetDialog = false;
                        for (LayoutItem layoutItem : stateDef.getLayoutItems()) {
                            if (!layoutItem.getName().contains("Cancel")) continue;
                            useEntryCancelWidgetDialog = true;
                            break;
                        }
                        CancelledReasonEnumDialog cancelDialog = useEntryCancelWidgetDialog ? new CancelledReasonEnumDialog("Cancellation Reason", "Select cancellation reason.  If other, please specify with details in the text entry.") : new EntryDialog("Cancellation Reason", "Enter cancellation reason.");
                        if (cancelDialog.open() != 0) {
                            transData.setDialogCancelled(true);
                        }
                        if (useEntryCancelWidgetDialog) {
                            transData.setCancellationReason(cancelDialog.getEntry());
                            transData.setCancellationReasonAttrType((AttributeTypeToken)AtsAttributeTypes.CancelledReasonEnum);
                            transData.setCancellationReasonDetails(cancelDialog.getCancelledDetails());
                        } else {
                            transData.setCancellationReason(cancelDialog.getEntry());
                            transData.setCancellationReasonAttrType((AttributeTypeToken)AtsAttributeTypes.CancelledReason);
                        }
                    }
                }
            }
        }, (boolean)true);
    }

    public static void getTransitionBy(final TransitionData transData) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                UserListDialog diag;
                AtsApiIde atsApi = AtsApiService.get();
                IAtsWorkItem workItem = (IAtsWorkItem)transData.getWorkItems().iterator().next();
                AtsUser currUser = atsApi.getUserService().getCurrentUser();
                String toStateName = transData.getToStateName();
                StateDefinition toState = workItem.getWorkDefinition().getStateByName(toStateName);
                HashSet<AtsUser> users = new HashSet<AtsUser>();
                String title = "";
                if (workItem.isCompletedOrCancelled() && toState.isWorking()) {
                    users.addAll(workItem.getImplementers());
                    users.add(currUser);
                    title = "Select new Assignee";
                } else {
                    if (workItem.getAssignees().contains(AtsCoreUsers.UNASSIGNED_USER)) {
                        transData.setToAssignees(Arrays.asList(atsApi.getUserService().getCurrentUser()));
                        return;
                    }
                    if (!workItem.getAssignees().contains(currUser)) {
                        users.addAll(workItem.getAssignees());
                        users.remove(AtsCoreUsers.UNASSIGNED_USER);
                        if (users.isEmpty()) {
                            users.addAll(atsApi.getUserService().getUsers(Active.Active));
                        } else {
                            users.add(currUser);
                        }
                        title = "Not Assignee; Select Transition-By User";
                    }
                }
                if (!users.isEmpty() && (diag = new UserListDialog(Displays.getActiveShell(), title, users)).open() == 0) {
                    AtsUser user = diag.getSelectedFirst();
                    transData.setTransitionUser(user);
                }
            }
        }, (boolean)true);
    }
}

