/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.related;

import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.task.related.DerivedFromTaskData;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.task.related.AbstractShowRelatedAction;
import org.eclipse.osee.ats.ide.workflow.task.trace.TraceabilityResultsEditor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class ShowRelatedTestCasesAction
extends AbstractShowRelatedAction {
    private static final String ACTION_TITLE = "Show Related Test Cases";

    public ShowRelatedTestCasesAction(ISelectedAtsArtifacts selectedAtsArtifacts) {
        super(ACTION_TITLE, selectedAtsArtifacts);
    }

    public void run() {
        final Collection<IAtsTask> tasks = this.getSelectedTasks();
        if (!this.isAutoGenRelatedArtTasks(tasks)) {
            return;
        }
        final LinkedList taskArtsNotFound = new LinkedList();
        final LinkedList requirements = new LinkedList();
        Job job = new Job(ACTION_TITLE){

            protected IStatus run(IProgressMonitor monitor) {
                for (IAtsTask task : tasks) {
                    try {
                        DerivedFromTaskData reqData = AtsApiService.get().getTaskRelatedService().getDerivedFromTaskData(task);
                        BranchToken workingBranch = AtsApiService.get().getBranchService().getWorkingBranchInWork(task.getParentTeamWorkflow());
                        Artifact artRef = (Artifact)reqData.getHeadArtifact();
                        if (artRef == null) {
                            taskArtsNotFound.add(task);
                            continue;
                        }
                        Artifact onWorkingBranch = null;
                        if (workingBranch.isValid()) {
                            onWorkingBranch = ArtifactQuery.getArtifactFromId((ArtifactId)artRef, (BranchId)workingBranch);
                        }
                        requirements.add(onWorkingBranch == null ? artRef : onWorkingBranch);
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
                TraceabilityResultsEditor editor = new TraceabilityResultsEditor("Open Test Cases Editor", "org.eclipse.osee.ats.ide", requirements);
                return Operations.executeWork((IOperation)editor);
            }
        };
        job.setPriority(20);
        job.schedule();
    }
}

