/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.workflow.task.IXTaskViewer;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskXViewer;
import org.eclipse.osee.ats.ide.workflow.task.internal.TaskMover;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.IWorldEditor;
import org.eclipse.osee.ats.ide.world.WorldComposite;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactData;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.artifact.ArtifactTransfer;
import org.eclipse.osee.framework.ui.swt.IDirtiableEditor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TaskComposite
extends WorldComposite {
    private final IXTaskViewer iXTaskViewer;
    private TaskXViewer taskXViewer;
    private final IAtsTeamWorkflow teamWf;

    public TaskComposite(IXTaskViewer iXTaskViewer, IWorldEditor worldEditor, IXViewerFactory xViewerFactory, Composite parent, int style, IDirtiableEditor dirtiableEditor, boolean tasksEditable, IAtsTeamWorkflow teamWf) {
        super(worldEditor, xViewerFactory, parent, style, false);
        this.iXTaskViewer = iXTaskViewer;
        this.teamWf = teamWf;
        this.taskXViewer.setTeamWf(teamWf);
    }

    @Override
    protected WorldXViewer createXViewer(IXViewerFactory xViewerFactory, Composite mainComp) {
        this.taskXViewer = new TaskXViewer(mainComp, 67586, xViewerFactory, null, this.teamWf);
        return this.taskXViewer;
    }

    @Override
    protected void setupDragAndDropSupport(boolean createDragAndDrop) {
        DragSource source = new DragSource((Control)this.taskXViewer.getTree(), 1);
        source.setTransfer(new Transfer[]{ArtifactTransfer.getInstance()});
        source.addDragListener(new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                List<TaskArtifact> arts = TaskComposite.this.taskXViewer.getSelectedTaskArtifacts();
                if (arts.size() > 0) {
                    event.data = new ArtifactData(arts.toArray(new Artifact[arts.size()]), "", "org.eclipse.osee.ats.ide.editor.WorkflowEditor");
                }
            }

            public void dragStart(DragSourceEvent event) {
            }
        });
        DropTarget target = new DropTarget((Control)this.taskXViewer.getTree(), 1);
        target.setTransfer(new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance(), ArtifactTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                TaskComposite.this.performDrop(event);
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 1;
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
    }

    private void performDrop(DropTargetEvent e) {
        if (e.data instanceof ArtifactData) {
            try {
                if (this.iXTaskViewer.getTeamWfArt() == null) {
                    return;
                }
                LinkedList<TaskArtifact> taskArts = new LinkedList<TaskArtifact>();
                Artifact[] artifactArray = ((ArtifactData)e.data).getArtifacts();
                int n = artifactArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Artifact art = artifactArray[n2];
                    if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) {
                        taskArts.add((TaskArtifact)art);
                    }
                    ++n2;
                }
                if (taskArts.isEmpty()) {
                    AWorkbench.popup((String)"No Tasks To Drop");
                    return;
                }
                TaskMover mover = new TaskMover(this.iXTaskViewer.getTeamWfArt(), taskArts);
                mover.moveTasks();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    }

    @Override
    public WorldXViewer getXViewer() {
        return this.taskXViewer;
    }

    public IXTaskViewer getIXTaskViewer() {
        return this.iXTaskViewer;
    }

    public TaskXViewer getTaskXViewer() {
        return this.taskXViewer;
    }

    public TeamWorkFlowArtifact getTeamArt() {
        return (TeamWorkFlowArtifact)this.teamWf.getStoreObject();
    }

    @Override
    public Collection<TeamWorkFlowArtifact> getSelectedTeamWorkflowArtifacts() {
        return Arrays.asList((TeamWorkFlowArtifact)this.getIXTaskViewer().getTeamWfArt());
    }
}

