/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.priority;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osee.ats.api.team.Priorities;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.priority.PriorityLabelProvider;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredListDialog;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class PriorityDialog
extends FilteredListDialog<Priorities> {
    private final Collection<IAtsTeamWorkflow> teamWfs;
    private boolean clearAllowed = true;
    private Composite container;
    private Priorities initialPriority = null;
    private String descUrl;

    public PriorityDialog(Collection<IAtsTeamWorkflow> teamWfs, List<Priorities> priorities) {
        super("Select Priority", "Select Priority", (ILabelProvider)new PriorityLabelProvider());
        if (teamWfs != null) {
            this.teamWfs = teamWfs;
            this.setInput(this.getValues());
        } else {
            this.teamWfs = null;
            this.setInput(priorities);
        }
    }

    protected Control createDialogArea(Composite container) {
        Button button;
        Composite composite;
        this.container = container;
        Control control = super.createDialogArea(container);
        if (this.initialPriority != null) {
            super.setSelection(Arrays.asList(this.initialPriority).toArray());
        }
        if (this.clearAllowed) {
            composite = new Composite((Composite)control, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData());
            button = new Button(composite, 8);
            button.setText("Clear and Close");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PriorityDialog.this.setSelection(null);
                    PriorityDialog.this.close();
                }
            });
        }
        if (Strings.isValid((String)this.descUrl)) {
            composite = new Composite((Composite)control, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData());
            button = new Button(composite, 8);
            button.setText("Show Descriptions");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Program.launch((String)PriorityDialog.this.descUrl);
                    PriorityDialog.this.close();
                }
            });
        }
        return control;
    }

    public boolean isClearAllowedSelected() {
        if (!this.clearAllowed) {
            return false;
        }
        return this.clearAllowed;
    }

    public String getSelectedOption() {
        if (this.clearAllowed || this.getSelected() == null) {
            return "";
        }
        return ((Priorities)this.getSelected()).getName();
    }

    public boolean isclearAllowed() {
        return this.clearAllowed;
    }

    public void setclearAllowed(boolean clearAllowed) {
        this.clearAllowed = clearAllowed;
    }

    private Collection<Priorities> getValues() {
        Pair pair = AtsApiService.get().getWorkItemService().hasSamePriorities(this.teamWfs);
        boolean samePriorities = (Boolean)pair.getFirst();
        Collection changeTypes = (Collection)pair.getSecond();
        if (!samePriorities) {
            AWorkbench.popup((String)"Can not change Priority for teams with different Priorities");
            return Collections.emptyList();
        }
        return changeTypes;
    }

    public void setSelected(Priorities priorities) {
        if (Widgets.isAccessible((Widget)this.container)) {
            super.setSelection(Arrays.asList(priorities).toArray());
        } else {
            this.initialPriority = priorities;
        }
    }

    public void setDescUrl(String descUrl) {
        this.descUrl = descUrl;
    }
}

