/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.util.AbstractAtsAttributeResolverServiceImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;

public class AtsAttributeResolverServiceImpl
extends AbstractAtsAttributeResolverServiceImpl {
    public AtsAttributeResolverServiceImpl(AtsApi atsApi) {
        super(atsApi);
    }

    public <T> T getSoleAttributeValue(IAtsObject atsObject, AttributeTypeToken attributeType, T defaultReturnValue) {
        return (T)this.getArtifact(atsObject).getSoleAttributeValue((AttributeTypeId)attributeType, defaultReturnValue);
    }

    public List<String> getAttributesToStringList(IAtsObject atsObject, AttributeTypeToken attributeType) {
        return this.getArtifact(atsObject).getAttributesToStringList((AttributeTypeId)attributeType);
    }

    public List<String> getAttributesToStringList(ArtifactId artifact, AttributeTypeToken attributeType) {
        return ((Artifact)this.atsApi.getQueryService().getArtifact(artifact)).getAttributesToStringList((AttributeTypeId)attributeType);
    }

    public boolean isAttributeTypeValid(IAtsWorkItem workItem, AttributeTypeToken attributeType) {
        return this.getArtifact((ArtifactId)workItem.getStoreObject()).isAttributeTypeValid((AttributeTypeId)attributeType);
    }

    public String getSoleAttributeValueAsString(IAtsObject atsObject, AttributeTypeToken attributeType, String defaultValue) {
        String result = defaultValue;
        Artifact artifact = this.getArtifact(atsObject.getArtifactId());
        if (artifact != null) {
            result = artifact.getSoleAttributeValueAsString(attributeType, defaultValue);
        }
        return result;
    }

    public String getSoleAttributeValueAsString(ArtifactId artifact, AttributeTypeToken attributeType, String defaultValue) {
        String result = defaultValue;
        Artifact art = (Artifact)this.atsApi.getQueryService().getArtifact(artifact);
        if (art != null) {
            result = art.getSoleAttributeValueAsString(attributeType, defaultValue);
        }
        return result;
    }

    private Artifact getArtifact(IAtsObject atsObject) {
        Artifact art = null;
        if (atsObject instanceof ArtifactId) {
            art = this.getArtifact((ArtifactId)atsObject);
        }
        if (art == null) {
            art = atsObject.getStoreObject() == null ? this.getArtifact(atsObject.getArtifactId()) : this.getArtifact((ArtifactId)atsObject.getStoreObject());
        }
        return art;
    }

    private Artifact getArtifact(ArtifactId artifact) {
        if (artifact instanceof Artifact) {
            return (Artifact)artifact;
        }
        ArtifactToken art = this.atsApi.getQueryService().getArtifact(artifact);
        if (art instanceof Artifact) {
            return (Artifact)this.atsApi.getQueryService().getArtifact((ArtifactId)art);
        }
        return null;
    }

    public void setSoleAttributeValue(IAtsObject atsObject, AttributeTypeId attributeType, Object value) {
        this.getArtifact(atsObject).setSoleAttributeValue(attributeType, value);
    }

    public int getAttributeCount(IAtsWorkItem workItem, AttributeTypeToken attributeType) {
        return this.getArtifact((IAtsObject)workItem).getAttributeCount((AttributeTypeId)attributeType);
    }

    public int getAttributeCount(IAtsObject atsObject, AttributeTypeToken attributeType) {
        return this.getArtifact(atsObject).getAttributeCount((AttributeTypeId)attributeType);
    }

    public int getAttributeCount(ArtifactId artifact, AttributeTypeToken attributeType) {
        return this.getArtifact(artifact).getAttributeCount((AttributeTypeId)attributeType);
    }

    public void addAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType, Object value) {
        this.getArtifact((IAtsObject)workItem).addAttribute(attributeType, value);
    }

    public <T> Collection<IAttribute<T>> getAttributes(IAtsObject atsObject, AttributeTypeToken attributeType) {
        ArrayList<IAttribute<T>> attrs = new ArrayList<IAttribute<T>>();
        for (Attribute attr : this.getArtifact(atsObject).getAttributes((AttributeTypeId)attributeType)) {
            attrs.add((IAttribute<T>)attr);
        }
        return attrs;
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeId attributeType) {
        this.getArtifact((IAtsObject)workItem).deleteSoleAttribute(attributeType);
    }

    public <T> void setValue(IAtsWorkItem workItem, IAttribute<String> attr, AttributeTypeId attributeType, T value) {
        Attribute attribute = (Attribute)attr;
        attribute.setValue(value);
    }

    public <T> void deleteAttribute(IAtsWorkItem workItem, IAttribute<T> attr) {
        Artifact artifact = this.getArtifact((IAtsObject)workItem);
        Attribute attribute = (Attribute)attr;
        Attribute attributeById = artifact.getAttributeById(attribute.getId().longValue(), false);
        attributeById.delete();
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeToken attributeType, IAtsChangeSet changes) {
        if (changes != null) {
            changes.deleteSoleAttribute(workItem, attributeType);
        } else {
            this.deleteSoleAttribute(workItem, (AttributeTypeId)attributeType);
        }
    }

    public void setSoleAttributeValue(IAtsObject atsObject, AttributeTypeToken attributeType, Object value, IAtsChangeSet changes) {
        if (changes != null) {
            changes.setSoleAttributeValue(atsObject, attributeType, value);
        } else {
            this.setSoleAttributeValue(atsObject, (AttributeTypeId)attributeType, value);
        }
    }

    public void addAttribute(IAtsWorkItem workItem, AttributeTypeToken attributeType, Object value, IAtsChangeSet changes) {
        if (changes != null) {
            changes.addAttribute((IAtsObject)workItem, attributeType, value);
        } else {
            this.getArtifact((IAtsObject)workItem).addAttribute((AttributeTypeId)attributeType, value);
        }
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeToken attributeType, Object value, IAtsChangeSet changes) {
        if (changes != null) {
            changes.deleteAttribute((IAtsObject)workItem, attributeType, value);
        } else {
            this.getArtifact((IAtsObject)workItem).deleteAttribute((AttributeTypeId)attributeType, value);
        }
    }

    public <T> void setValue(IAtsWorkItem workItem, IAttribute<T> attr, AttributeTypeId attributeType, T value, IAtsChangeSet changes) {
        if (changes != null) {
            changes.setValue(workItem, attr, attributeType, value);
        } else {
            Attribute attribute = (Attribute)attr;
            attribute.setValue(value);
        }
    }

    public <T> void deleteAttribute(IAtsWorkItem workItem, IAttribute<T> attr, IAtsChangeSet changes) {
        if (changes != null) {
            changes.deleteAttribute(workItem, attr);
        } else {
            Artifact artifact = this.getArtifact((IAtsObject)workItem);
            Attribute attribute = (Attribute)attr;
            Attribute attributeById = artifact.getAttributeById(attribute.getId().longValue(), false);
            attributeById.delete();
        }
    }

    public <T> T getSoleAttributeValue(ArtifactId artifact, AttributeTypeToken attributeType, T defaultValue) {
        if (this.getArtifact(artifact) != null) {
            return (T)this.getArtifact(artifact).getSoleAttributeValue((AttributeTypeId)attributeType, defaultValue);
        }
        return null;
    }

    public <T> Collection<T> getAttributeValues(ArtifactId artifact, AttributeTypeToken attributeType) {
        Assert.isNotNull((Object)artifact, (String)"Artifact can not be null");
        Assert.isNotNull((Object)attributeType, (String)"Attribute Type can not be null");
        return this.getArtifact(artifact).getAttributeValues((AttributeTypeId)attributeType);
    }

    public <T> Collection<T> getAttributeValues(IAtsObject atsObject, AttributeTypeToken attributeType) {
        Assert.isNotNull((Object)atsObject, (String)"ATS Object can not be null");
        Assert.isNotNull((Object)attributeType, (String)"Attribute Type can not be null");
        return this.getAttributeValues((ArtifactId)atsObject.getStoreObject(), attributeType);
    }

    public <T> Collection<IAttribute<T>> getAttributes(ArtifactId artifact, AttributeTypeToken attributeType) {
        Assert.isNotNull((Object)artifact, (String)"Artifact can not be null");
        Assert.isNotNull((Object)attributeType, (String)"Attribute Type can not be null");
        LinkedList<IAttribute<T>> attributes = new LinkedList<IAttribute<T>>();
        for (Attribute attr : this.getArtifact(artifact).getAttributes((AttributeTypeId)attributeType)) {
            attributes.add((IAttribute<T>)attr);
        }
        return attributes;
    }

    public <T> Collection<IAttribute<T>> getAttributes(ArtifactId artifact) {
        LinkedList<IAttribute<T>> attributes = new LinkedList<IAttribute<T>>();
        for (Attribute attr : this.getArtifact(artifact).getAttributes()) {
            attributes.add((IAttribute<T>)attr);
        }
        return attributes;
    }

    public <T> Collection<IAttribute<T>> getAttributes(IAtsWorkItem workItem) {
        return this.getAttributes((ArtifactId)workItem.getStoreObject());
    }

    public List<String> getAttributesToStringListFromArt(ArtifactToken artifact, AttributeTypeToken attributeType) {
        return this.getArtifact((ArtifactId)artifact).getAttributesToStringList((AttributeTypeId)attributeType);
    }

    public List<String> getAttributesToStringListFromArt(ArtifactToken artifact, AttributeTypeToken attributeType, DeletionFlag deletionFlag) {
        return this.getArtifact((ArtifactId)artifact).getAttributesToStringList(attributeType, deletionFlag);
    }
}

