/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.cr;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.team.CreateTeamOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionToken;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionTokens;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XButton;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.widgets.Shell;

public abstract class XCreateEscapeWfXButton
extends XButton
implements ArtifactWidget {
    private TeamWorkFlowArtifact teamWf;
    boolean creating = false;
    protected AtsApi atsApi;
    private final XModifiedListener listener = new XModifiedListener(){
        String fName;
        {
            this.fName = XCreateEscapeWfXButton.this.getLabel();
        }

        public void widgetModified(XWidget widget) {
            XCreateEscapeWfXButton.this.createWorkflow(this.fName);
        }
    };

    public XCreateEscapeWfXButton(String name) {
        super(name);
        this.setImage(ImageManager.getImage((OseeImage)AtsImage.PLAY_GREEN));
        this.setToolTip(this.getToolTip());
        this.addXModifiedListener(this.listener);
        this.atsApi = AtsApiService.get();
    }

    public String getToolTip() {
        return "Click to Create/Open Escape Analysis Workflow";
    }

    public String getTitle() {
        return "Analyze the Escape for this Change Request";
    }

    public abstract IAtsActionableItem getAi();

    public List<AtsUser> getAssignees() {
        return Arrays.asList(AtsCoreUsers.UNASSIGNED_USER);
    }

    protected void createWorkflow(String name) {
        String title = this.getTitle();
        for (IAtsTeamWorkflow sibling : this.atsApi.getWorkItemService().getSiblings((IAtsTeamWorkflow)this.teamWf)) {
            if (!sibling.getName().equals(title)) continue;
            WorkflowEditor.edit((IAtsWorkItem)sibling);
            return;
        }
        if (this.creating) {
            AWorkbench.popup((String)"Creating Workflow, Please Wait");
            return;
        }
        this.creating = true;
        String useName = name;
        if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)useName, (String)(String.valueOf(useName) + "?"))) {
            this.creating = false;
            return;
        }
        final String fName = name;
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                XCreateEscapeWfXButton.this.setLabel(String.valueOf(fName) + " - Creating...");
                XCreateEscapeWfXButton.this.comp.layout(true);
                XCreateEscapeWfXButton.this.parent.layout(true);
            }
        });
        final TeamWorkFlowArtifact teamWf = this.teamWf;
        Job job = new Job(name){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IAtsChangeSet changes = AtsApiService.get().createChangeSet(this.getName());
                    Date createdDate = new Date();
                    AtsUser currentUser = XCreateEscapeWfXButton.this.atsApi.getUserService().getCurrentUser();
                    IAtsTeamDefinition teamDef = XCreateEscapeWfXButton.this.atsApi.getActionableItemService().getTeamDefinitionInherited(XCreateEscapeWfXButton.this.getAi());
                    IAtsTeamWorkflow newTeamWf = AtsApiService.get().getActionService().createTeamWorkflow(teamWf.getParentAction(), teamDef, Collections.singleton(XCreateEscapeWfXButton.this.getAi()), XCreateEscapeWfXButton.this.getAssignees(), changes, createdDate, currentUser, Collections.singleton(new NewEscapeActionListener()), new CreateTeamOption[]{CreateTeamOption.Duplicate_If_Exists});
                    if (!changes.isEmpty()) {
                        changes.execute();
                    }
                    WorkflowEditor.edit((IAtsWorkItem)newTeamWf);
                }
                catch (Throwable throwable) {
                    Displays.ensureInDisplayThread((Runnable)new Runnable(fName){
                        private final /* synthetic */ String val$fName;
                        {
                            this.val$fName = string;
                        }

                        @Override
                        public void run() {
                            XCreateEscapeWfXButton.this.setLabel(this.val$fName);
                            (this).XCreateEscapeWfXButton.this.creating = false;
                        }
                    });
                    throw throwable;
                }
                Displays.ensureInDisplayThread((Runnable)new /* invalid duplicate definition of identical inner class */);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public ArtifactTypeToken getOverrideCrArtifactType(IAtsTeamDefinition teamDef) {
        return AtsArtifactTypes.TeamWorkflow;
    }

    public AtsWorkDefinitionToken getOverrideCrWorkDefinitionId(IAtsTeamDefinition teamDef) {
        return AtsWorkDefinitionTokens.WorkDef_Team_Simple_InWork;
    }

    public TeamWorkFlowArtifact getArtifact() {
        return this.teamWf;
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void revert() {
    }

    public void saveToArtifact() {
    }

    public void setArtifact(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            this.teamWf = (TeamWorkFlowArtifact)artifact;
        }
        super.setEditable(true);
    }

    private class NewEscapeActionListener
    implements INewActionListener {
        private NewEscapeActionListener() {
        }

        public void teamCreated(IAtsAction action, IAtsTeamWorkflow teamWf, IAtsChangeSet changes) {
            TeamWorkFlowArtifact teamArt = (TeamWorkFlowArtifact)teamWf.getStoreObject();
            teamArt.setName(XCreateEscapeWfXButton.this.getTitle());
        }

        public AtsWorkDefinitionToken getOverrideWorkDefinitionId(IAtsTeamDefinition teamDef) {
            return XCreateEscapeWfXButton.this.getOverrideCrWorkDefinitionId(teamDef);
        }

        public ArtifactTypeToken getOverrideArtifactType(IAtsTeamDefinition teamDef) {
            return XCreateEscapeWfXButton.this.getOverrideCrArtifactType(teamDef);
        }
    }
}

