/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractAtsArtifact;
import org.eclipse.osee.ats.ide.workflow.action.ActionArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.review.DecisionReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.review.PeerToPeerReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.sprint.SprintArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactFactory;

public class AtsArtifactFactory
extends ArtifactFactory {
    private final List<ArtifactTypeToken> disabledUserCreationTypes = new ArrayList<ArtifactTypeToken>(20);
    private List<ArtifactTypeToken> supportedTypes = null;
    private static final Pattern nameIdPattern = Pattern.compile("\\[(.*)\\]-\\[(.*)\\]");

    public AtsArtifactFactory() {
        super(new ArtifactTypeToken[0]);
    }

    private Collection<ArtifactTypeToken> getSupportedTypes() {
        if (this.supportedTypes == null) {
            this.supportedTypes = new LinkedList<ArtifactTypeToken>();
            this.supportedTypes.addAll(Arrays.asList(AtsArtifactTypes.Action, AtsArtifactTypes.PeerToPeerReview, AtsArtifactTypes.DecisionReview, AtsArtifactTypes.Task, AtsArtifactTypes.TeamWorkflow, AtsArtifactTypes.Goal, AtsArtifactTypes.AgileSprint, AtsArtifactTypes.AgileBacklog));
            this.supportedTypes.addAll(AtsArtifactTypes.TeamWorkflow.getAllDescendantTypes());
            this.supportedTypes.addAll(AtsArtifactTypes.Task.getAllDescendantTypes());
            this.supportedTypes.addAll(AtsArtifactTypes.PeerToPeerReview.getAllDescendantTypes());
            this.supportedTypes.addAll(AtsArtifactTypes.Action.getAllDescendantTypes());
            this.supportedTypes.addAll(AtsArtifactTypes.DecisionReview.getAllDescendantTypes());
            this.supportedTypes.addAll(AtsArtifactTypes.Goal.getAllDescendantTypes());
            this.supportedTypes.addAll(AtsArtifactTypes.AgileSprint.getAllDescendantTypes());
            this.supportedTypes.addAll(AtsArtifactTypes.AgileBacklog.getAllDescendantTypes());
        }
        return this.supportedTypes;
    }

    public boolean isResponsibleFor(ArtifactTypeToken artifactType) {
        for (ArtifactTypeToken artType : this.getSupportedTypes()) {
            if (!artifactType.inheritsFrom((ArtifactTypeId)artType)) continue;
            return true;
        }
        return false;
    }

    public Artifact getArtifactInstance(Long id, String guid, BranchToken branch, ArtifactTypeToken artifactType, boolean inDataStore) {
        AbstractAtsArtifact toReturn;
        if (artifactType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.Task)) {
            toReturn = new TaskArtifact(id, guid, branch, artifactType);
        } else if (artifactType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.TeamWorkflow)) {
            toReturn = new TeamWorkFlowArtifact(id, guid, branch, artifactType);
        } else if (artifactType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.DecisionReview)) {
            toReturn = new DecisionReviewArtifact(id, guid, branch, artifactType);
        } else if (artifactType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.PeerToPeerReview)) {
            toReturn = new PeerToPeerReviewArtifact(id, guid, branch, artifactType);
        } else if (artifactType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.Goal)) {
            toReturn = new GoalArtifact(id, guid, branch, artifactType);
        } else if (artifactType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.AgileSprint)) {
            toReturn = new SprintArtifact(id, guid, branch, artifactType);
        } else if (artifactType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.Action)) {
            toReturn = new ActionArtifact(id, guid, branch, artifactType);
        } else {
            throw new OseeArgumentException("AtsArtifactFactory did not recognize the artifact type [%s]", new Object[]{artifactType});
        }
        return toReturn;
    }

    public Collection<ArtifactTypeId> getEternalArtifactTypes() {
        return Arrays.asList(AtsArtifactTypes.WorkDefinition, AtsArtifactTypes.Version, AtsArtifactTypes.TeamDefinition, AtsArtifactTypes.ActionableItem);
    }

    public boolean isUserCreationEnabled(ArtifactTypeToken artifactType) {
        if (this.disabledUserCreationTypes.isEmpty()) {
            this.setupDisabledUserCreationArtifactTypes();
        }
        if (this.disabledUserCreationTypes.contains(artifactType)) {
            return false;
        }
        return !artifactType.inheritsFrom((ArtifactTypeId)AtsArtifactTypes.TeamWorkflow);
    }

    public void setupDisabledUserCreationArtifactTypes() {
        this.disabledUserCreationTypes.addAll(this.getSupportedTypes());
        this.disabledUserCreationTypes.add(AtsArtifactTypes.AgileTeam);
        this.disabledUserCreationTypes.add(AtsArtifactTypes.AgileFeatureGroup);
        this.disabledUserCreationTypes.add(AtsArtifactTypes.AgileSprint);
        String configValue = AtsApiService.get().getConfigValue("UserCreationDisabled2");
        if (Strings.isValid((String)configValue)) {
            String[] stringArray = configValue.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String artifactTypeNamedIdStr = stringArray[n2];
                ArtifactTypeToken artifactType = AtsArtifactFactory.createArtifactTypeIdFromToken(artifactTypeNamedIdStr);
                if (artifactType == null) {
                    OseeLog.logf(Activator.class, (Level)Level.SEVERE, (String)"Artifact Type Name [%s] specified in AtsConfig.[%s] is invalid", (Object[])new Object[]{"UserCreationDisabled2"});
                } else {
                    this.disabledUserCreationTypes.add(artifactType);
                }
                ++n2;
            }
        }
    }

    private static ArtifactTypeToken createArtifactTypeIdFromToken(String token) {
        Matcher matcher = nameIdPattern.matcher(token);
        if (matcher.find()) {
            long id = Long.valueOf(matcher.group(2));
            String name = matcher.group(1);
            return ArtifactTypeToken.valueOf((long)id, (String)name, (ArtifactTypeToken[])new ArtifactTypeToken[0]);
        }
        return null;
    }
}

