/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workdef;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.workdef.WidgetOption;
import org.eclipse.osee.ats.api.workdef.model.CompositeLayoutItem;
import org.eclipse.osee.ats.api.workdef.model.LayoutItem;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.widgets.commit.XCommitManager;
import org.eclipse.osee.ats.ide.workdef.StateXWidgetPage;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XOption;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class WidgetPageUtil {
    public static void dispose(SwtXWidgetRenderer dynamicXWidgetLayout) {
        try {
            for (XWidgetRendererItem layoutData : dynamicXWidgetLayout.getLayoutDatas()) {
                layoutData.getXWidget().dispose();
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public static String getHtml(String backgroundColor, String preHtml, String postHtml, Set<XWidgetRendererItem> set, String name) {
        StringBuffer sb = new StringBuffer();
        int defaultWidth = 100;
        sb.append(AHTML.startBorderTable((int)defaultWidth, (String)backgroundColor, (String)name));
        if (preHtml != null) {
            sb.append(preHtml);
        }
        for (XWidgetRendererItem layoutData : set) {
            XWidget xWidget = layoutData.getXWidget();
            if (xWidget instanceof ArtifactWidget) {
                ((ArtifactWidget)xWidget).setArtifact(layoutData.getArtifact());
            }
            sb.append(layoutData.getXWidget().toHTML("<font color=\"black\" face=\"Arial\" size=\"-1\">"));
            sb.append(AHTML.newline());
        }
        if (postHtml != null) {
            sb.append(postHtml);
        }
        sb.append(AHTML.endBorderTable());
        return sb.toString();
    }

    public static void createXWidgetLayoutData(XWidgetRendererItem layoutData, XWidget xWidget, FormToolkit toolkit, Artifact art, XModifiedListener xModListener, boolean isEditable) {
        if (!Strings.isValid((String)xWidget.getToolTip())) {
            String description = "";
            if (layoutData.getXWidgetName().equals(XCommitManager.class.getSimpleName())) {
                description = "Commit branches to parent and parallel branches.";
            }
            AttributeTypeGeneric type = null;
            if (layoutData.getStoreId() > 0L) {
                type = AttributeTypeManager.getAttributeType((Long)layoutData.getStoreId());
            }
            if (type == null && Strings.isValid((String)layoutData.getStoreName())) {
                type = AttributeTypeManager.getType((String)layoutData.getStoreName());
            }
            if (type != null && Strings.isValid((String)type.getDescription())) {
                description = type.getDescription();
            }
            if (Strings.isValid((String)description)) {
                xWidget.setToolTip(description);
                layoutData.setToolTip(description);
            }
        }
        if (xWidget.getControl() != null) {
            xWidget.getControl().setData((Object)layoutData);
        }
    }

    public static void generateLayoutDatas(AbstractWorkflowArtifact sma, Collection<LayoutItem> layoutItems, SwtXWidgetRenderer dynamicXWidgetLayout) {
        for (LayoutItem stateItem : layoutItems) {
            if (stateItem instanceof WidgetDefinition) {
                WidgetPageUtil.processWidgetDefinition((WidgetDefinition)stateItem, sma, dynamicXWidgetLayout);
                continue;
            }
            if (!(stateItem instanceof CompositeLayoutItem)) continue;
            WidgetPageUtil.processComposite((CompositeLayoutItem)stateItem, sma, dynamicXWidgetLayout);
        }
    }

    public static void processComposite(CompositeLayoutItem compositeLayoutItem, AbstractWorkflowArtifact sma, SwtXWidgetRenderer dynamicXWidgetLayout) {
        boolean firstWidget = true;
        boolean inGroupComp = false;
        if (compositeLayoutItem.isGroupComposite()) {
            inGroupComp = true;
            XWidgetRendererItem newCompItem = new XWidgetRendererItem(dynamicXWidgetLayout, new XOption[0]);
            newCompItem.setName(compositeLayoutItem.getName());
            newCompItem.setBeginGroupComposite(compositeLayoutItem.getNumColumns());
            dynamicXWidgetLayout.addWorkLayoutData(newCompItem);
        }
        List stateItems = compositeLayoutItem.getLayoutItems();
        int x = 0;
        while (x < stateItems.size()) {
            boolean lastWidget = x == stateItems.size() - 1;
            LayoutItem stateItem = (LayoutItem)stateItems.get(x);
            if (stateItem instanceof WidgetDefinition) {
                XWidgetRendererItem renderItem = WidgetPageUtil.processWidgetDefinition((WidgetDefinition)stateItem, sma, dynamicXWidgetLayout);
                if (firstWidget && compositeLayoutItem.getNumColumns() > 0 && !compositeLayoutItem.isGroupComposite()) {
                    renderItem.setBeginComposite(compositeLayoutItem.getNumColumns());
                }
                if (lastWidget) {
                    renderItem.setEndComposite(true);
                }
            } else if (stateItem instanceof CompositeLayoutItem) {
                CompositeLayoutItem compLayoutItem = (CompositeLayoutItem)stateItem;
                WidgetPageUtil.processComposite(compLayoutItem, sma, dynamicXWidgetLayout);
            }
            firstWidget = false;
            ++x;
        }
        if (inGroupComp) {
            XWidgetRendererItem newCompItem = new XWidgetRendererItem(dynamicXWidgetLayout, new XOption[0]);
            newCompItem.setEndGroupComposite(true);
            dynamicXWidgetLayout.addWorkLayoutData(newCompItem);
        }
    }

    public static XWidgetRendererItem processWidgetDefinition(WidgetDefinition widgetDef, AbstractWorkflowArtifact sma, SwtXWidgetRenderer dynamicXWidgetLayout) {
        XWidgetRendererItem rItem = null;
        try {
            rItem = new XWidgetRendererItem(dynamicXWidgetLayout, new XOption[0]);
            rItem.setDefaultValue(widgetDef.getDefaultValue());
            rItem.setHeight(widgetDef.getHeight());
            if (widgetDef.getAttributeType() != null) {
                rItem.setStoreName(widgetDef.getAttributeType().getName());
                rItem.setStoreId(widgetDef.getAttributeType().getId());
                rItem.setAttributeType(widgetDef.getAttributeType());
            }
            if (widgetDef.getAttributeType2() != null) {
                rItem.setStoreName(widgetDef.getAttributeType().getName());
                rItem.setStoreId(widgetDef.getAttributeType().getId());
                rItem.setAttributeType2(widgetDef.getAttributeType2());
            }
            rItem.setWidgetHints(widgetDef.getWidgetHints());
            rItem.setEnumeratedArt(widgetDef.getEnumeratedArt());
            rItem.getParameters().putAll(widgetDef.getParameters());
            rItem.setRelationTypeSide(widgetDef.getRelationTypeSide());
            rItem.setOseeImage(widgetDef.getOseeImage());
            rItem.setEnumeratedArt(widgetDef.getEnumeratedArt());
            rItem.setComputedCharacteristic(widgetDef.getComputedCharacteristic());
            rItem.setToolTip(widgetDef.getToolTip());
            rItem.setId(widgetDef.getName());
            rItem.setXWidgetName(widgetDef.getXWidgetName());
            rItem.setArtifact((Artifact)sma);
            rItem.setName(widgetDef.getName());
            rItem.setObject((Object)widgetDef);
            if (widgetDef.is(WidgetOption.MULTI_SELECT)) {
                rItem.getXOptionHandler().add(XOption.MULTI_SELECT);
            } else if (widgetDef.is(WidgetOption.SINGLE_SELECT)) {
                rItem.getXOptionHandler().add(XOption.SINGLE_SELECT);
            }
            if (widgetDef.is(WidgetOption.REQUIRED_FOR_TRANSITION)) {
                rItem.getXOptionHandler().add(XOption.REQUIRED);
            } else if (widgetDef.is(WidgetOption.REQUIRED_FOR_COMPLETION)) {
                rItem.getXOptionHandler().add(XOption.REQUIRED_FOR_COMPLETION);
            }
            if (widgetDef.is(WidgetOption.FILL_HORIZONTALLY)) {
                rItem.getXOptionHandler().add(XOption.FILL_HORIZONTALLY);
            } else if (widgetDef.is(WidgetOption.FILL_VERTICALLY)) {
                rItem.getXOptionHandler().add(XOption.FILL_VERTICALLY);
            }
            for (WidgetOption widgetOpt : widgetDef.getOptions().getXOptions()) {
                XOption option = null;
                try {
                    option = XOption.valueOf((String)widgetOpt.name());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (option == null) continue;
                rItem.getXOptionHandler().add(option);
            }
            rItem.setConditions(widgetDef.getConditions());
            rItem.setUserGroup(widgetDef.getUserGroup());
            dynamicXWidgetLayout.addWorkLayoutData(rItem);
        }
        catch (Exception ex) {
            rItem = new XWidgetRendererItem(dynamicXWidgetLayout, new XOption[0]);
            rItem.setId(Lib.generateArtifactIdAsInt().toString());
            rItem.setXWidgetName("XLabel");
            rItem.setName("Error: " + widgetDef.getName() + " (double-click to view error)");
            rItem.setToolTip("Double-click to see error.");
            rItem.setDoubleClickText(Lib.exceptionToString((Exception)ex));
            OseeLog.logf(StateXWidgetPage.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Exception processing widget [%s]", (Object[])new Object[]{widgetDef.getName()});
            rItem.setObject((Object)widgetDef);
            dynamicXWidgetLayout.addWorkLayoutData(rItem);
        }
        return rItem;
    }
}

