/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.walker;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.walker.IActionWalkerItem;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.ArtifactImageManager;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.zest.core.viewers.IConnectionStyleProvider;

public class ActionWalkerLabelProvider
implements ILabelProvider,
IConnectionStyleProvider {
    public Image getImage(Object obj) {
        if (obj instanceof Artifact) {
            return ArtifactImageManager.getImage((Artifact)AtsApiService.get().getQueryServiceIde().getArtifact(obj));
        }
        if (obj instanceof IActionWalkerItem) {
            return ((IActionWalkerItem)obj).getImage();
        }
        return null;
    }

    public String getText(Object obj) {
        String str = "";
        if (obj instanceof TeamWorkFlowArtifact) {
            try {
                str = ((TeamWorkFlowArtifact)((Object)obj)).getEditorTitle();
            }
            catch (OseeCoreException ex) {
                str = "Exception - " + ex.getLocalizedMessage();
            }
        } else if (obj instanceof GoalArtifact) {
            try {
                str = ((GoalArtifact)obj).getEditorTitle();
            }
            catch (OseeCoreException ex) {
                str = "Exception - " + ex.getLocalizedMessage();
            }
        } else if (obj instanceof Artifact && AtsApiService.get().getQueryServiceIde().getArtifact(obj).isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
            try {
                str = "Agile Sprint : " + AtsApiService.get().getQueryServiceIde().getArtifact(obj).getName();
            }
            catch (OseeCoreException ex) {
                str = "Exception - " + ex.getLocalizedMessage();
            }
        } else if (obj instanceof Artifact && !(obj instanceof IAtsAction)) {
            str = obj.toString();
        } else if (obj instanceof IActionWalkerItem) {
            str = ((IActionWalkerItem)obj).getName();
        } else if (this.isDerivedLink(obj)) {
            str = "Derived";
        }
        return Strings.truncate((String)str, (int)50, (boolean)true);
    }

    public void addListener(ILabelProviderListener arg0) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener arg0) {
    }

    public Color getColor(Object arg0) {
        if (this.isDerivedLink(arg0)) {
            return Displays.getSystemColor((int)10);
        }
        return null;
    }

    private boolean isDerivedLink(Object arg0) {
        if (arg0 instanceof EntityConnectionData) {
            EntityConnectionData conn = (EntityConnectionData)arg0;
            if (conn.source instanceof TeamWorkFlowArtifact && conn.dest instanceof TeamWorkFlowArtifact) {
                return true;
            }
        }
        return false;
    }

    public int getConnectionStyle(Object arg0) {
        return 0;
    }

    public Color getHighlightColor(Object arg0) {
        return null;
    }

    public int getLineWidth(Object arg0) {
        return 0;
    }

    public IFigure getTooltip(Object arg0) {
        if (this.isDerivedLink(arg0)) {
            Label lab = new Label();
            EntityConnectionData conn = (EntityConnectionData)arg0;
            TeamWorkFlowArtifact source = (TeamWorkFlowArtifact)((Object)conn.source);
            TeamWorkFlowArtifact dest = (TeamWorkFlowArtifact)((Object)conn.dest);
            if (conn.source instanceof TeamWorkFlowArtifact && conn.dest instanceof TeamWorkFlowArtifact) {
                lab.setText(String.format("%s\n%s\nDerived\n%s\n%s", source.getArtifactType().getName(), source.toStringWithId(), dest.getArtifactType().getName(), dest.toStringWithId()));
            }
            return lab;
        }
        return null;
    }
}

