/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.signby;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsWorkItemHook;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.WidgetHint;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.internal.Activator;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.AttributeType2Widget;
import org.eclipse.osee.framework.ui.skynet.widgets.AttributeTypeWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XButtonWithLabelDam;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class XAbstractSignByAndDateButton
extends XButtonWithLabelDam
implements AttributeTypeWidget,
AttributeType2Widget {
    protected AttributeTypeToken dateAttrType;
    protected AttributeTypeToken byAttrType;
    private final XModifiedListener listener = new XModifiedListener(){

        public void widgetModified(XWidget widget) {
            XAbstractSignByAndDateButton.this.handleSelection();
        }
    };

    public XAbstractSignByAndDateButton(AttributeTypeToken attrType1, AttributeTypeToken attrType2) {
        super(attrType1.isDate() ? attrType2.getUnqualifiedName() : attrType1.getUnqualifiedName(), "Sign or Clear", ImageManager.getImage((KeyedImage)FrameworkImage.RUN_EXC));
        this.setAttributeType(attrType1);
        this.setAttributeType2(attrType2);
        this.dateAttrType = attrType1.isDate() ? attrType1 : attrType2;
        this.byAttrType = attrType1.isDate() ? attrType2 : attrType1;
        this.addListener();
    }

    protected void addListener() {
        this.addXModifiedListener(this.listener);
    }

    public String getResultsText() {
        User user;
        Date date = (Date)this.artifact.getSoleAttributeValue((AttributeTypeId)this.dateAttrType, null);
        if (date != null && (user = UserManager.getUserByArtId((long)((Long)this.artifact.getSoleAttributeValue((AttributeTypeId)this.byAttrType, (Object)SystemUser.UnAssigned.getId())))) != null) {
            return String.format("Signed by %s on %s", user.getName(), DateUtil.getDateNow((Date)date, (String)"MM/dd/yyyy hh:mm a"));
        }
        return "";
    }

    public void handleSelection() {
        try {
            XResultData result = this.isAuthorizedToChange();
            if (result.isErrors()) {
                XResultDataUI.report((XResultData)result, (String)"Unable to Sign");
                return;
            }
            final int res = MessageDialog.open((int)3, (Shell)Displays.getActiveShell(), (String)this.getLabel(), (String)this.getSignMessage(), (int)0, (String[])new String[]{"Ok", "Cancel", "Clear"});
            Job signJob = new Job(this.getSignMessage()){

                protected IStatus run(IProgressMonitor monitor) {
                    if (res == 2) {
                        if (XAbstractSignByAndDateButton.this.userHasPermission()) {
                            XAbstractSignByAndDateButton.setSigned(XAbstractSignByAndDateButton.this.artifact, (AttributeTypeId)XAbstractSignByAndDateButton.this.dateAttrType, (AttributeTypeId)XAbstractSignByAndDateButton.this.byAttrType, XAbstractSignByAndDateButton.this.getLabel(), false);
                            XAbstractSignByAndDateButton.this.refresh();
                        }
                    } else if (res == 0 && XAbstractSignByAndDateButton.this.userHasPermission()) {
                        XAbstractSignByAndDateButton.setSigned(XAbstractSignByAndDateButton.this.artifact, (AttributeTypeId)XAbstractSignByAndDateButton.this.dateAttrType, (AttributeTypeId)XAbstractSignByAndDateButton.this.byAttrType, XAbstractSignByAndDateButton.this.getLabel(), true);
                        XAbstractSignByAndDateButton.this.refresh();
                    }
                    return Status.OK_STATUS;
                }
            };
            Operations.scheduleJob((Job)signJob, (boolean)false, (int)20, null);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    protected XResultData isAuthorizedToChange() {
        Artifact storeArt;
        String teamArtifactId;
        Artifact teamArtifact;
        XResultData rd = new XResultData();
        if (this.hasWidgetHint(WidgetHint.LeadRequired) && !(teamArtifact = ArtifactQuery.getArtifactFromId((ArtifactId)ArtifactId.valueOf((String)(teamArtifactId = (storeArt = this.getArtifact()).getSoleAttribute((AttributeTypeId)AtsAttributeTypes.TeamDefinitionReference).getValue().toString())), (BranchId)CoreBranches.COMMON)).getRelatedArtifacts(AtsRelationTypes.TeamLead_Lead).contains(UserManager.getUser())) {
            rd.errorf("Insufficient Privileges to Sign [%s].\nOnly a ATS Team Lead may perform this action.\nTeam Leads for this workflow are %s\n", new Object[]{this.byAttrType.getUnqualifiedName(), teamArtifact.getRelatedArtifacts(AtsRelationTypes.TeamLead_Lead).toString()});
        }
        if (rd.isSuccess()) {
            this.hasUserGroupAuthorization(rd);
        }
        if (rd.isSuccess()) {
            for (IAtsWorkItemHook wiHook : AtsApiService.get().getWorkItemService().getWorkItemHooks()) {
                wiHook.isModifiableAttribute((ArtifactToken)this.artifact, this.getSignByAttrType(), rd);
            }
        }
        return rd;
    }

    private void hasUserGroupAuthorization(XResultData rd) {
        if (this.userGroup.getId() > 0L) {
            IUserGroup group = AtsApiService.get().userService().getUserGroupOrNull(this.userGroup);
            if (group != null && group.getId() > 0L) {
                if (!group.isMember((UserId)UserManager.getUser())) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("You are not authorized to Sign.\n\n");
                    sb.append("\n\nAuthorized Users Are:\n-----------------------------\n");
                    for (UserToken member : group.getMembers()) {
                        sb.append(member.getName());
                        sb.append("\n");
                    }
                    rd.error(sb.toString());
                }
            } else {
                rd.errorf("User Group %s Not Found", new Object[]{"User Group needs to be setup.", this.userGroup.toStringWithId()});
            }
        }
    }

    protected String getSignMessage() {
        return "Sign [" + this.getLabel() + "]?";
    }

    public boolean userHasPermission() {
        return true;
    }

    public static void setSigned(Artifact artifact, AttributeTypeId signDateAttrType, AttributeTypeId signByAttrType, String label, boolean signed) {
        XAbstractSignByAndDateButton.setSigned(Collections.singleton(artifact), signDateAttrType, signByAttrType, label, signed);
    }

    public static void setSigned(Collection<Artifact> artifacts, AttributeTypeId signDateAttrType, AttributeTypeId signByAttrType, String label, boolean signed) {
        SkynetTransaction tx = TransactionManager.createTransaction((BranchId)artifacts.iterator().next().getBranch(), (String)("Set " + label));
        for (Artifact art : artifacts) {
            if (signed) {
                art.setSoleAttributeValue(signByAttrType, (Object)UserManager.getUser().getId());
                art.setSoleAttributeValue(signDateAttrType, (Object)new Date());
            } else {
                art.deleteSoleAttribute(signByAttrType);
                art.deleteSoleAttribute(signDateAttrType);
            }
            tx.addArtifact(art);
        }
        tx.execute();
    }

    public boolean isEditable() {
        return true;
    }

    public AttributeTypeId getSignDateAttrType() {
        return this.dateAttrType;
    }

    public IStatus isValid() {
        Date date;
        if (this.isRequiredEntry() && this.artifact.getSoleAttributeValue(this.getSignDateAttrType(), null) == null && (date = (Date)this.getArtifact().getSoleAttributeValue((AttributeTypeId)this.dateAttrType, null)) == null) {
            return new Status(4, "org.eclipse.osee.framework.ui.skynet", String.valueOf(this.getLabel()) + " must be signed");
        }
        return Status.OK_STATUS;
    }

    public void setUnsigned() {
        XAbstractSignByAndDateButton.setSigned(this.getArtifact(), (AttributeTypeId)this.dateAttrType, (AttributeTypeId)this.byAttrType, this.getLabel(), false);
    }

    public void setSigned() {
        XAbstractSignByAndDateButton.setSigned(this.getArtifact(), (AttributeTypeId)this.dateAttrType, (AttributeTypeId)this.byAttrType, this.getLabel(), true);
    }

    public Label getControl() {
        return this.labelWidget;
    }

    public AttributeTypeToken getSignByAttrType() {
        return this.byAttrType;
    }

    public void setAttributeType(AttributeTypeToken attributeType) {
        super.setAttributeType(attributeType);
        if (attributeType.isDate()) {
            this.dateAttrType = attributeType;
        } else {
            this.byAttrType = attributeType;
        }
    }

    public void setAttributeType2(AttributeTypeToken attributeType2) {
        super.setAttributeType2(attributeType2);
        if (attributeType2.isDate()) {
            this.dateAttrType = attributeType2;
        } else {
            this.byAttrType = attributeType2;
        }
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        super.createControls(parent, horizontalSpan);
        if (this.getOseeImage() != null) {
            Image img = ImageManager.getImage((OseeImage)this.getOseeImage());
            this.setImage(img);
            this.getbutton().setImage(img);
        }
    }
}

