/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.dialog;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsObjectLabelProvider;
import org.eclipse.osee.ats.ide.util.widgets.dialog.TeamDefinitionTreeContentProvider;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.util.ArtifactNameSorter;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TeamDefinitionCheckTreeDialog
extends FilteredCheckboxTreeDialog<IAtsTeamDefinition> {
    private final Active active;
    private List<IAtsTeamDefinition> initialTeamDefs;
    private final boolean requiredSelection;

    public TeamDefinitionCheckTreeDialog(String title, String message, Active active, boolean requiredSelection) {
        super(title, message, (IContentProvider)new TeamDefinitionTreeContentProvider(active), (IBaseLabelProvider)new AtsObjectLabelProvider(), (ViewerComparator)new ArtifactNameSorter());
        this.active = active;
        this.requiredSelection = requiredSelection;
    }

    public Collection<IAtsTeamDefinition> getChecked() {
        return super.getTreeViewer().getChecked();
    }

    protected Control createDialogArea(Composite container) {
        Control comp = super.createDialogArea(container);
        try {
            Collection topLevelTeamDefinitions = AtsApiService.get().getTeamDefinitionService().getTopLevelTeamDefinitions(this.active);
            this.getTreeViewer().getViewer().setInput((Object)topLevelTeamDefinitions);
            if (this.getInitialTeamDefs() != null) {
                this.getTreeViewer().setInitalChecked(this.getInitialTeamDefs());
                if (this.getInitialTeamDefs().size() == 1) {
                    this.getTreeViewer().getCheckboxTreeViewer().expandToLevel((Object)this.initialTeamDefs.iterator().next(), 1);
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return comp;
    }

    protected Result isComplete() {
        super.isComplete();
        Result result = Result.TrueResult;
        try {
            if (this.requiredSelection && this.getChecked().isEmpty()) {
                result = new Result("Must select Team Definition(s)");
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return result;
    }

    public List<IAtsTeamDefinition> getInitialTeamDefs() {
        return this.initialTeamDefs;
    }

    public void setInitialTeamDefs(List<IAtsTeamDefinition> initialTeamDefs) {
        this.initialTeamDefs = initialTeamDefs;
        if (initialTeamDefs.size() == 1) {
            this.getTreeViewer().getCheckboxTreeViewer().expandToLevel((Object)initialTeamDefs.iterator().next(), 1);
        }
    }
}

