/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.commit;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.commit.CommitXManager;
import org.eclipse.osee.ats.ide.util.widgets.commit.XCommitContentProvider;
import org.eclipse.osee.ats.ide.util.widgets.commit.XCommitLabelProvider;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactTopicEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IBranchEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEvent;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.GenericXWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidgetUtility;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class XCommitManager
extends GenericXWidget
implements ArtifactWidget,
IBranchEventListener,
IArtifactEventListener,
IArtifactTopicEventListener {
    private CommitXManager xCommitManager;
    public static final String normalColor = "#EEEEEE";
    private TeamWorkFlowArtifact teamArt;
    private static final int paddedTableHeightHint = 2;
    private Label extraInfoLabel;
    public static final String NAME = "Commit Manager";
    public static final String DESCRIPTION = "Commit branches to parent and parallel branches.";
    private int lastDefectListSize = 0;
    private Composite mainComp;
    private Composite parentComp;

    public XCommitManager() {
        super(NAME);
        OseeEventManager.addListener((IEventListener)this);
    }

    public TeamWorkFlowArtifact getArtifact() {
        return this.teamArt;
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        this.parentComp = new Composite(parent, 0x800000);
        this.parentComp.setLayoutData((Object)new GridData(768));
        this.parentComp.setLayout((Layout)ALayout.getZeroMarginLayout());
        this.redrawComposite();
    }

    private void redrawComposite() {
        if (this.parentComp == null || !Widgets.isAccessible((Widget)this.parentComp)) {
            return;
        }
        if (this.mainComp != null && Widgets.isAccessible((Widget)this.mainComp)) {
            this.mainComp.dispose();
            this.xCommitManager = null;
        }
        this.mainComp = new Composite(this.parentComp, 0x800000);
        this.mainComp.setLayoutData((Object)new GridData(768));
        this.mainComp.setLayout((Layout)new GridLayout(1, true));
        if (this.toolkit != null) {
            this.toolkit.paintBordersFor(this.mainComp);
        }
        this.labelWidget = new Label(this.mainComp, 0);
        this.labelWidget.setText(String.valueOf(this.getLabel()) + ":");
        if (this.getToolTip() != null) {
            this.labelWidget.setToolTipText(this.getToolTip());
        }
        try {
            if (AtsApiService.get().getBranchService().isWorkingBranchCreationInProgress((IAtsTeamWorkflow)this.teamArt)) {
                this.labelWidget.setText(String.valueOf(this.getLabel()) + ": Branch Creation in Progress");
            } else if (!AtsApiService.get().getBranchService().isWorkingBranchInWork((IAtsTeamWorkflow)this.teamArt) && !AtsApiService.get().getBranchService().isCommittedBranchExists((IAtsTeamWorkflow)this.teamArt)) {
                this.labelWidget.setText(String.valueOf(this.getLabel()) + ": No Working Branch or Committed changes available.");
            } else {
                Composite tableComp = new Composite(this.mainComp, 2048);
                tableComp.setLayoutData((Object)new GridData(768));
                tableComp.setLayout((Layout)ALayout.getZeroMarginLayout());
                if (this.toolkit != null) {
                    this.toolkit.paintBordersFor(tableComp);
                }
                this.createTaskActionBar(tableComp);
                this.labelWidget.setText(String.valueOf(this.getLabel()) + ": ");
                if (AtsApiService.get().getUserService().isAtsAdmin() && !AtsApiService.get().getStoreService().isProductionDb()) {
                    this.labelWidget.addListener(4, new Listener(){

                        public void handleEvent(Event event) {
                            if (event.button == 3) {
                                if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Auto Commit Branches", (String)"ATS Admin\n\nAuto Commit Branches?")) {
                                    return;
                                }
                                try {
                                    Collection branches = AtsApiService.get().getBranchService().getBranchesLeftToCommit((IAtsTeamWorkflow)XCommitManager.this.teamArt);
                                    Iterator it = branches.iterator();
                                    while (it.hasNext()) {
                                        BranchId destinationBranch = (BranchId)it.next();
                                        XResultData rd = AtsApiService.get().getBranchServiceIde().commitWorkingBranch(XCommitManager.this.teamArt, false, true, destinationBranch, !it.hasNext(), new XResultData());
                                        if (!rd.isErrors()) continue;
                                        ResultsEditor.open((String)"Commit Failed", (XResultData)rd);
                                    }
                                }
                                catch (Exception ex) {
                                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                                }
                            }
                        }
                    });
                }
                this.xCommitManager = new CommitXManager(tableComp, 67586, this, this.teamArt, AtsApiService.get());
                this.xCommitManager.getTree().setLayoutData((Object)new GridData(768));
                this.xCommitManager.setContentProvider((IContentProvider)new XCommitContentProvider());
                this.xCommitManager.setLabelProvider((IBaseLabelProvider)new XCommitLabelProvider(this.xCommitManager, this.teamArt));
                if (this.toolkit != null && this.xCommitManager.getStatusLabel() != null) {
                    this.toolkit.adapt((Control)this.xCommitManager.getStatusLabel(), false, false);
                }
                this.setXviewerTree();
                this.loadTable();
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        XWidgetUtility.setLabelFontsBold((Control)this.labelWidget, (Font)FontManager.getDefaultLabelFont());
        this.parentComp.layout();
    }

    public void setXviewerTree() {
        Tree tree = this.xCommitManager.getTree();
        int defectListSize = this.xCommitManager.getTree().getItemCount();
        if (defectListSize == this.lastDefectListSize) {
            return;
        }
        this.lastDefectListSize = defectListSize;
        int treeItemHeight = this.xCommitManager.getTree().getItemHeight();
        GridData gridData = new GridData(768);
        gridData.heightHint = treeItemHeight * (2 + defectListSize);
        tree.setLayout((Layout)ALayout.getZeroMarginLayout());
        tree.setLayoutData((Object)gridData);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
    }

    public void createTaskActionBar(Composite parent) {
        Composite bComp = new Composite(parent, 0);
        bComp.setLayout((Layout)new GridLayout(2, false));
        bComp.setLayoutData((Object)new GridData(768));
        Composite leftComp = new Composite(bComp, 0);
        leftComp.setLayout((Layout)new GridLayout());
        leftComp.setLayoutData((Object)new GridData(769));
        this.extraInfoLabel = new Label(leftComp, 0);
        this.extraInfoLabel.setLayoutData((Object)new GridData(768));
        this.extraInfoLabel.setText("");
        this.extraInfoLabel.setForeground(Displays.getSystemColor((int)3));
        Composite rightComp = new Composite(bComp, 0);
        rightComp.setLayout((Layout)new GridLayout());
        rightComp.setLayoutData((Object)new GridData(3));
        ToolBar toolBar = new ToolBar(rightComp, 0x820000);
        GridData gd = new GridData(768);
        toolBar.setLayoutData((Object)gd);
        ToolItem item = null;
        item = new ToolItem(toolBar, 8);
        item.setImage(ImageManager.getImage((KeyedImage)PluginUiImage.REFRESH));
        item.setToolTipText("Refresh");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XCommitManager.this.loadTable();
            }
        });
    }

    public void loadTable() {
        try {
            if (this.xCommitManager != null && this.teamArt != null && this.xCommitManager.getContentProvider() != null) {
                Collection commitMgrInputObjs = AtsApiService.get().getBranchService().getCommitTransactionsAndConfigItemsForTeamWf((IAtsTeamWorkflow)this.teamArt);
                this.xCommitManager.setInput(commitMgrInputObjs);
                this.xCommitManager.refresh();
                this.refresh();
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public Control getControl() {
        if (this.xCommitManager == null) {
            return null;
        }
        return this.xCommitManager.getTree();
    }

    public void dispose() {
        if (this.xCommitManager != null) {
            this.xCommitManager.dispose();
        }
        OseeEventManager.removeListener((IEventListener)this);
    }

    public void refresh() {
        if (this.xCommitManager == null || this.xCommitManager.getTree() == null || this.xCommitManager.getTree().isDisposed()) {
            return;
        }
        this.setXviewerTree();
    }

    private void updateExtraInfoLabel(final int color, final String infoStr) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Widgets.isAccessible((Widget)XCommitManager.this.extraInfoLabel)) {
                    String currentString = XCommitManager.this.extraInfoLabel.getText();
                    if (infoStr == null && currentString != null || infoStr != null && currentString == null || infoStr != null && currentString != null && !infoStr.equals(currentString)) {
                        XCommitManager.this.extraInfoLabel.setText("Double-click item to perform Action; Right-click for more options.");
                    }
                    XCommitManager.this.extraInfoLabel.setForeground(Displays.getSystemColor((int)color));
                }
            }
        });
    }

    public IStatus isValid() {
        Status returnStatus = new Status(0, ((Object)((Object)this)).getClass().getSimpleName(), "");
        try {
            boolean workingBranchInWork;
            int backgroundColor = 2;
            String infoStr = "Double-click item to perform Action";
            if (this.xCommitManager != null && this.xCommitManager.getXCommitViewer() != null && this.xCommitManager.getXCommitViewer().getTeamArt() != null && (workingBranchInWork = AtsApiService.get().getBranchService().isWorkingBranchInWork((IAtsTeamWorkflow)this.teamArt)) && !AtsApiService.get().getBranchService().isAllObjectsToCommitToConfigured((IAtsTeamWorkflow)this.xCommitManager.getXCommitViewer().getTeamArt())) {
                infoStr = "All branches must be committed, configured, or overridden before transitioning";
                backgroundColor = 3;
                returnStatus = new Status(4, ((Object)((Object)this)).getClass().getSimpleName(), "All branches must be configured and committed.");
            }
            this.updateExtraInfoLabel(backgroundColor, infoStr);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return new Status(4, ((Object)((Object)this)).getClass().getSimpleName(), ex.getLocalizedMessage());
        }
        return returnStatus;
    }

    public CommitXManager getXViewer() {
        return this.xCommitManager;
    }

    public Object getData() {
        return this.xCommitManager.getInput();
    }

    public void setArtifact(Artifact artifact) {
        if (!artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            throw new OseeStateException("Must be TeamWorkflowArtifact, set was a [%s]", new Object[]{artifact.getArtifactTypeName()});
        }
        this.teamArt = (TeamWorkFlowArtifact)artifact;
        this.loadTable();
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void revert() {
    }

    public void saveToArtifact() {
    }

    public TeamWorkFlowArtifact getTeamArt() {
        return this.teamArt;
    }

    public Control getErrorMessageControl() {
        return this.labelWidget;
    }

    public String toString() {
        return String.format("%s", this.getLabel());
    }

    public void handleBranchEvent(Sender sender, BranchEvent branchEvent) {
        if (Widgets.isAccessible((Widget)this.mainComp)) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    XCommitManager.this.redrawComposite();
                }
            });
        }
    }

    public void handleArtifactEvent(ArtifactEvent artifactEvent, Sender sender) {
        if (Widgets.isAccessible((Widget)this.mainComp)) {
            if (artifactEvent.isModified((Artifact)this.getTeamArt())) {
                this.reloadTableInDisplayThread();
                return;
            }
            if (artifactEvent.isRelAddedChangedDeleted((Artifact)this.getTeamArt())) {
                this.reloadTableInDisplayThread();
            }
        }
    }

    private void reloadTableInDisplayThread() {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                XCommitManager.this.loadTable();
            }
        });
    }

    public void handleArtifactTopicEvent(ArtifactTopicEvent artifactTopicEvent, Sender sender) {
        if (Widgets.isAccessible((Widget)this.mainComp) && artifactTopicEvent.isModified((Artifact)this.getTeamArt())) {
            this.reloadTableInDisplayThread();
        }
    }

    public List<? extends IEventFilter> getEventFilters() {
        return null;
    }

    public List<? extends ITopicEventFilter> getTopicEventFilters() {
        return null;
    }

    public boolean isEmpty() {
        return this.xCommitManager.getXCommitViewer().getXViewer().getTree().getItemCount() == 0;
    }
}

