/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.LinkedList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.agile.SprintFilteredListDialog;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelCmdValueSelection;

public class XSprintHyperlinkWidget
extends XHyperlinkLabelCmdValueSelection {
    protected IAgileSprint sprint;
    protected IAtsTeamWorkflow teamWf;
    protected IAtsTeamDefinition teamDef;
    AtsApi atsApi = AtsApiService.get();

    public XSprintHyperlinkWidget() {
        super("Sprint", true, Integer.valueOf(50));
    }

    public String getCurrentValue() {
        return this.sprint == null ? "" : this.sprint.getName();
    }

    public boolean handleSelection() {
        TeamDefinition useTeamDef;
        IAgileTeam agileTeam = null;
        if (this.teamWf != null) {
            agileTeam = this.atsApi.getAgileService().getAgileTeam((IAtsWorkItem)this.teamWf);
        } else if (this.teamDef != null) {
            agileTeam = this.atsApi.getAgileService().getAgileTeam(this.teamDef);
        } else if (this.getTeamId().isValid() && (useTeamDef = this.atsApi.getTeamDefinitionService().getTeamDefinitionById(this.getTeamId())) != null) {
            agileTeam = this.atsApi.getAgileService().getAgileTeam((IAtsTeamDefinition)useTeamDef);
        }
        if (agileTeam == null) {
            AWorkbench.popup((String)"No Agile Team configured for this ATS Team");
            return false;
        }
        LinkedList<IAgileSprint> activeSprints = new LinkedList<IAgileSprint>();
        for (IAgileSprint agileSprint : this.atsApi.getAgileService().getAgileSprints(agileTeam)) {
            if (!agileSprint.isActive()) continue;
            activeSprints.add(agileSprint);
        }
        SprintFilteredListDialog dialog = new SprintFilteredListDialog("Select Sprint", "Select Sprint", activeSprints);
        int result = dialog.open();
        if (result != 0) {
            return false;
        }
        Object obj = dialog.getSelectedFirst();
        this.sprint = (IAgileSprint)obj;
        return true;
    }

    public boolean handleClear() {
        this.sprint = null;
        return true;
    }

    public IAgileSprint getSelected() {
        return this.sprint;
    }

    public void setSprint(IAgileSprint sprint) {
        this.sprint = sprint;
    }

    public void setTeamWf(IAtsTeamWorkflow teamWf) {
        this.teamWf = teamWf;
    }

    public IAtsTeamDefinition getTeamDef() {
        return this.teamDef;
    }

    public void setTeamDef(IAtsTeamDefinition teamDef) {
        this.teamDef = teamDef;
    }

    public void setSelected(IAgileSprint sprint) {
        this.sprint = sprint;
    }
}

